/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.protoc;

import io.github.ascopes.protobufmavenplugin.dependencies.ImmutableMavenDependency;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifactPathResolver;
import io.github.ascopes.protobufmavenplugin.dependencies.PlatformClassifierFactory;
import io.github.ascopes.protobufmavenplugin.dependencies.UrlResourceFetcher;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import io.github.ascopes.protobufmavenplugin.utils.HostSystem;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import io.github.ascopes.protobufmavenplugin.utils.SystemPathBinaryResolver;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Finds or downloads the required version of protoc from various locations")
@MojoExecutionScoped
@Named
public final class ProtocResolver {
    private static final String EXECUTABLE_NAME = "protoc";
    private static final String GROUP_ID = "com.google.protobuf";
    private static final String ARTIFACT_ID = "protoc";
    private static final String TYPE = "exe";
    private static final Logger log = LoggerFactory.getLogger(ProtocResolver.class);
    private final HostSystem hostSystem;
    private final MavenArtifactPathResolver artifactPathResolver;
    private final PlatformClassifierFactory platformClassifierFactory;
    private final SystemPathBinaryResolver systemPathResolver;
    private final UrlResourceFetcher urlResourceFetcher;

    @Inject
    public ProtocResolver(HostSystem hostSystem, MavenArtifactPathResolver artifactPathResolver, PlatformClassifierFactory platformClassifierFactory, SystemPathBinaryResolver systemPathResolver, UrlResourceFetcher urlResourceFetcher) {
        this.hostSystem = hostSystem;
        this.artifactPathResolver = artifactPathResolver;
        this.platformClassifierFactory = platformClassifierFactory;
        this.systemPathResolver = systemPathResolver;
        this.urlResourceFetcher = urlResourceFetcher;
    }

    public Optional<Path> resolve(String version) throws ResolutionException {
        Optional<Path> path;
        if (version.equalsIgnoreCase("LATEST")) {
            log.warn("You have set the protoc version to 'latest'. This will likely not behave as you would expect, since Google have released incorrect version numbers of protoc in the past. To remove this warning, please use a pinned version instead.");
        }
        if (version.equalsIgnoreCase("PATH")) {
            return this.systemPathResolver.resolve("protoc");
        }
        Optional<Path> optional = path = version.contains(":") ? this.resolveFromUrl(version) : this.resolveFromMavenRepositories(version);
        if (path.isPresent()) {
            Path resolvedPath = path.get();
            try {
                FileUtils.makeExecutable(resolvedPath);
            }
            catch (IOException ex) {
                throw new ResolutionException("Failed to set executable bit on protoc binary at " + String.valueOf(resolvedPath) + ": " + ex.getMessage(), ex);
            }
        }
        return path;
    }

    private Optional<Path> resolveFromUrl(String url) throws ResolutionException {
        try {
            return this.urlResourceFetcher.fetchFileFromUrl(new URL(url), ".exe");
        }
        catch (IOException ex) {
            throw new ResolutionException("Failed to fetch resource from URL " + url + ": " + ex.getMessage(), ex);
        }
    }

    private Optional<Path> resolveFromMavenRepositories(String version) throws ResolutionException {
        if (this.hostSystem.isProbablyTermux()) {
            log.warn("It looks like you are using Termux! If you are using an environment such as Termux, then you may find that the Maven-distributed versions of protoc fail to run. This is due to Android's kernel restricting the types of system calls that can be made. You may wish to run 'pkg in protobuf' to install a modified version of protoc, and reinvoke Maven with '-Dprotobuf.compiler.version=PATH' to force this Maven plugin to use a compatible version. Also ensure you have the latest JDK installed in this case. If you do not encounter any issues, then great! You can safely ignore this warning.");
        }
        ImmutableMavenDependency artifact = ImmutableMavenDependency.builder().groupId(GROUP_ID).artifactId("protoc").version(version).type(TYPE).classifier(this.platformClassifierFactory.getClassifier("protoc")).build();
        return Optional.of(this.artifactPathResolver.resolveArtifact(artifact));
    }
}

