/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.mojo;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenDependencyBean;
import io.github.ascopes.protobufmavenplugin.digests.Digest;
import io.github.ascopes.protobufmavenplugin.generation.GenerationResult;
import io.github.ascopes.protobufmavenplugin.generation.ImmutableGenerationRequest;
import io.github.ascopes.protobufmavenplugin.generation.Language;
import io.github.ascopes.protobufmavenplugin.generation.OutputDescriptorAttachmentRegistrar;
import io.github.ascopes.protobufmavenplugin.generation.ProtobufBuildOrchestrator;
import io.github.ascopes.protobufmavenplugin.generation.SourceRootRegistrar;
import io.github.ascopes.protobufmavenplugin.plugins.MavenProtocPluginBean;
import io.github.ascopes.protobufmavenplugin.plugins.PathProtocPluginBean;
import io.github.ascopes.protobufmavenplugin.plugins.UriProtocPluginBean;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenerateMojo
extends AbstractMojo {
    private static final String DEFAULT_FALSE = "false";
    private static final String DEFAULT_TRUE = "true";
    private static final String DEFAULT_TRANSITIVE = "TRANSITIVE";
    private static final String COMPILER_VERSION_PROPERTY = "protobuf.compiler.version";
    private static final Logger log = LoggerFactory.getLogger(AbstractGenerateMojo.class);
    @Inject
    ProtobufBuildOrchestrator sourceCodeGenerator;
    @Inject
    MavenProject mavenProject;
    @Inject
    MavenProjectHelper mavenProjectHelper;
    @Parameter
    @Nullable List<String> arguments;
    @Parameter
    @Nullable List<MavenProtocPluginBean> binaryMavenPlugins;
    @Parameter
    @Nullable List<PathProtocPluginBean> binaryPathPlugins;
    @Parameter
    @Nullable List<UriProtocPluginBean> binaryUrlPlugins;
    @Parameter(defaultValue="false")
    boolean cleanOutputDirectories;
    @Deprecated(since="3.10.1", forRemoval=true)
    @Parameter(defaultValue="false")
    boolean cppEnabled;
    @Deprecated(since="3.10.1", forRemoval=true)
    @Parameter(defaultValue="false")
    boolean csharpEnabled;
    @Parameter(defaultValue="TRANSITIVE")
    DependencyResolutionDepth dependencyResolutionDepth;
    @Parameter
    @Nullable Set<String> dependencyScopes;
    @Parameter(defaultValue="false")
    boolean embedSourcesInClassOutputs;
    @Parameter
    @Nullable Map<String, String> environmentVariables;
    @Parameter(property="protobuf.compiler.excludes")
    @Nullable List<String> excludes;
    @Deprecated(since="3.10.1", forRemoval=true)
    @Parameter(defaultValue="false")
    boolean failOnInvalidDependencies;
    @Deprecated(since="3.10.1", forRemoval=true)
    @Parameter(defaultValue="true")
    boolean failOnMissingSources;
    @Parameter(defaultValue="true")
    boolean failOnMissingTargets;
    @Parameter(defaultValue="false")
    boolean fatalWarnings;
    @Parameter(defaultValue="false")
    boolean ignoreProjectDependencies;
    @Parameter
    @Nullable List<MavenDependencyBean> importDependencies;
    @Parameter
    @Nullable List<Path> importPaths;
    @Parameter(property="protobuf.compiler.includes")
    @Nullable List<String> includes;
    @Parameter(defaultValue="true", property="protobuf.compiler.incremental")
    boolean incrementalCompilation;
    @Parameter(defaultValue="true")
    boolean javaEnabled;
    @Parameter
    @Nullable List<MavenProtocPluginBean> jvmMavenPlugins;
    @Parameter(defaultValue="false")
    boolean kotlinEnabled;
    @Parameter(defaultValue="false")
    boolean liteOnly;
    @Deprecated(since="3.10.1", forRemoval=true)
    @Parameter(defaultValue="false")
    boolean objcEnabled;
    @Parameter
    @Nullable Path outputDescriptorFile;
    @Parameter(defaultValue="false")
    boolean outputDescriptorAttached;
    @Parameter
    @Nullable String outputDescriptorAttachmentType;
    @Parameter
    @Nullable String outputDescriptorAttachmentClassifier;
    @Parameter(defaultValue="false")
    boolean outputDescriptorIncludeImports;
    @Parameter(defaultValue="false")
    boolean outputDescriptorIncludeSourceInfo;
    @Parameter(defaultValue="false")
    boolean outputDescriptorRetainOptions;
    @Parameter
    @Nullable Path outputDirectory;
    @Deprecated(since="3.10.1", forRemoval=true)
    @Parameter(defaultValue="false")
    boolean phpEnabled;
    @Parameter(property="protobuf.compiler.digest")
    @Nullable Digest protocDigest;
    @Parameter(alias="protoc", required=true, property="protobuf.compiler.version")
    String protocVersion;
    @Parameter(defaultValue="false")
    boolean pythonEnabled;
    @Parameter(defaultValue="false")
    boolean pythonStubsEnabled;
    @Parameter(defaultValue="true")
    boolean registerAsCompilationRoot;
    @Parameter(defaultValue="false")
    boolean rubyEnabled;
    @Deprecated(since="3.10.1", forRemoval=true)
    @Parameter(defaultValue="false")
    boolean rustEnabled;
    @Parameter(property="protobuf.sanctioned-executable-path")
    @Nullable Path sanctionedExecutablePath;
    @Parameter(defaultValue="false", property="protobuf.skip")
    boolean skip;
    @Parameter
    @Nullable List<MavenDependencyBean> sourceDependencies;
    @Parameter
    @Nullable List<MavenDependencyBean> sourceDescriptorDependencies;
    @Parameter(alias="sourcePaths")
    @Nullable List<Path> sourceDirectories;
    @Parameter
    @Nullable List<Path> sourceDescriptorPaths;

    abstract Collection<Path> defaultSourceDirectories();

    abstract Path defaultOutputDirectory();

    abstract Set<String> defaultDependencyScopes();

    abstract OutputDescriptorAttachmentRegistrar outputDescriptorAttachmentRegistrar();

    abstract SourceRootRegistrar sourceRootRegistrar();

    public void execute() throws MojoExecutionException, MojoFailureException {
        GenerationResult result;
        if (Runtime.version().feature() < 17) {
            log.warn("It looks like you are using a JDK older than Java 17. From v4.0.0 of this plugin, you will need to run Maven with Java 17 or newer for the build to succeed. Please consider updating to a newer JDK where possible.");
        }
        if (this.skip) {
            log.info("Execution of this plugin has been skipped in the configuration");
            return;
        }
        EnumSet<Language> enabledLanguages = Language.languageSet().addIf(this.cppEnabled, Language.CPP).addIf(this.csharpEnabled, Language.C_SHARP).addIf(this.javaEnabled, Language.JAVA).addIf(this.kotlinEnabled, Language.KOTLIN).addIf(this.objcEnabled, Language.OBJECTIVE_C).addIf(this.phpEnabled, Language.PHP).addIf(this.pythonEnabled, Language.PYTHON).addIf(this.pythonStubsEnabled, Language.PYI).addIf(this.rubyEnabled, Language.RUBY).addIf(this.rustEnabled, Language.RUST).build();
        ImmutableGenerationRequest request = ImmutableGenerationRequest.builder().arguments(AbstractGenerateMojo.nonNullList(this.arguments)).binaryMavenPlugins(AbstractGenerateMojo.nonNullList(this.binaryMavenPlugins)).binaryPathPlugins(AbstractGenerateMojo.nonNullList(this.binaryPathPlugins)).binaryUrlPlugins(AbstractGenerateMojo.nonNullList(this.binaryUrlPlugins)).cleanOutputDirectories(this.cleanOutputDirectories).dependencyResolutionDepth(this.dependencyResolutionDepth).dependencyScopes(this.dependencyScopes()).embedSourcesInClassOutputs(this.embedSourcesInClassOutputs).environmentVariables(AbstractGenerateMojo.nonNullMap(this.environmentVariables)).enabledLanguages(enabledLanguages).excludes(AbstractGenerateMojo.nonNullList(this.excludes)).failOnInvalidDependencies(this.failOnInvalidDependencies).failOnMissingSources(this.failOnMissingSources).failOnMissingTargets(this.failOnMissingTargets).fatalWarnings(this.fatalWarnings).ignoreProjectDependencies(this.ignoreProjectDependencies).importDependencies(AbstractGenerateMojo.nonNullList(this.importDependencies)).importPaths(AbstractGenerateMojo.determinePaths(this.importPaths, List::of)).includes(AbstractGenerateMojo.nonNullList(this.includes)).incrementalCompilationEnabled(this.incrementalCompilation).jvmMavenPlugins(AbstractGenerateMojo.nonNullList(this.jvmMavenPlugins)).liteEnabled(this.liteOnly).outputDescriptorAttached(this.outputDescriptorAttached).outputDescriptorAttachmentClassifier(this.outputDescriptorAttachmentClassifier).outputDescriptorAttachmentRegistrar(this.outputDescriptorAttachmentRegistrar()).outputDescriptorAttachmentType(this.outputDescriptorAttachmentType).outputDescriptorFile(this.outputDescriptorFile).outputDescriptorIncludeImports(this.outputDescriptorIncludeImports).outputDescriptorIncludeSourceInfo(this.outputDescriptorIncludeSourceInfo).outputDescriptorRetainOptions(this.outputDescriptorRetainOptions).outputDirectory(this.outputDirectory()).protocDigest(this.protocDigest).protocVersion(this.protocVersion()).registerAsCompilationRoot(this.registerAsCompilationRoot).sanctionedExecutablePath(this.sanctionedExecutablePath).sourceDependencies(AbstractGenerateMojo.nonNullList(this.sourceDependencies)).sourceDescriptorDependencies(AbstractGenerateMojo.nonNullList(this.sourceDescriptorDependencies)).sourceDescriptorPaths(AbstractGenerateMojo.determinePaths(this.sourceDescriptorPaths, List::of)).sourceDirectories(AbstractGenerateMojo.determinePaths(this.sourceDirectories, this::defaultSourceDirectories)).sourceRootRegistrar(this.sourceRootRegistrar()).build();
        try {
            result = this.sourceCodeGenerator.generate(request);
        }
        catch (Exception ex) {
            log.error("Generation failed due to an unexpected error - {}", (Object)ex.getMessage(), (Object)ex);
            throw new MojoFailureException("Generation failed due to an unexpected error - " + String.valueOf(ex), (Throwable)ex);
        }
        if (!result.isOk()) {
            log.error("Generation failed - {}", (Object)result);
            throw new MojoExecutionException("Generation failed - " + String.valueOf((Object)result));
        }
        log.info("{}", (Object)result);
    }

    private Set<String> dependencyScopes() {
        return Optional.ofNullable(this.dependencyScopes).filter(Predicate.not(Set::isEmpty)).orElseGet(this::defaultDependencyScopes);
    }

    private Path outputDirectory() {
        return Optional.ofNullable(this.outputDirectory).orElseGet(this::defaultOutputDirectory);
    }

    private String protocVersion() {
        String overriddenVersion = System.getProperty(COMPILER_VERSION_PROPERTY);
        return overriddenVersion == null ? Objects.requireNonNull(this.protocVersion, "protocVersion has not been set") : overriddenVersion;
    }

    private static Collection<Path> determinePaths(@Nullable Collection<Path> inputPaths, Supplier<Collection<Path>> defaultIfMissing) {
        List transformed = Optional.ofNullable(inputPaths).filter(Predicate.not(Collection::isEmpty)).stream().flatMap(Collection::stream).collect(Collectors.toUnmodifiableList());
        List finalValue = transformed.isEmpty() ? defaultIfMissing.get() : transformed;
        return finalValue.stream().filter(path -> {
            if (Files.notExists(path, new LinkOption[0])) {
                log.info("Ignoring non-existent path \"{}\"", path);
                return false;
            }
            return true;
        }).collect(Collectors.toUnmodifiableList());
    }

    private static <T> List<T> nonNullList(@Nullable List<T> list) {
        return Objects.requireNonNullElseGet(list, List::of);
    }

    private static <K, V> Map<K, V> nonNullMap(@Nullable Map<K, V> map) {
        return Objects.requireNonNullElseGet(map, Map::of);
    }
}

