/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependencies;

import io.github.ascopes.protobufmavenplugin.utils.HostSystem;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;

@Description(value="Generates classifiers for protoc binaries based on the current platform")
@MojoExecutionScoped
@Named
public final class PlatformClassifierFactory {
    private final HostSystem hostSystem;
    private final Properties platformMapping;

    @Inject
    public PlatformClassifierFactory(HostSystem hostSystem) throws IOException {
        this.hostSystem = hostSystem;
        try (InputStream is = this.getClass().getResourceAsStream("platforms.properties");){
            this.platformMapping = new Properties();
            this.platformMapping.load(is);
        }
    }

    public String getClassifier(String binaryName) throws ResolutionException {
        String rawArch;
        String osKey = this.hostSystem.isProbablyLinux() ? "linux" : (this.hostSystem.isProbablyMacOs() ? "macos" : (this.hostSystem.isProbablyWindows() ? "windows" : "unknown"));
        String classifier = this.platformMapping.getProperty(osKey + "." + (rawArch = this.hostSystem.getCpuArchitecture()));
        if (classifier != null) {
            return classifier;
        }
        String rawOs = this.hostSystem.getOperatingSystem();
        throw new ResolutionException("No '" + binaryName + "' binary is available for reported OS '" + rawOs + "' and CPU architecture '" + rawArch + "'");
    }
}

