/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.generation;

import java.util.Locale;

public enum GenerationResult {
    PROTOC_SUCCEEDED(true, "Protoc invocation succeeded."),
    NOTHING_TO_DO(true, "There is nothing to do. If this is unexpected, review the above logs for more details."),
    PROTOC_FAILED(false, "Protoc failed with an error. Check the build logs above to find the root cause."),
    NO_SOURCES(false, "No valid protobuf sources were found. Check the build logs above for more details."),
    NO_TARGETS(false, "No output languages were enabled and no protoc plugins were configured.");

    private final boolean ok;
    private final String description;

    private GenerationResult(boolean ok, String description) {
        this.ok = ok;
        this.description = description;
    }

    public boolean isOk() {
        return this.ok;
    }

    public String toString() {
        return this.name().replace("_", " ").toUpperCase(Locale.ROOT) + ": " + this.description;
    }
}

