/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.urls;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

abstract class AbstractUrlStreamHandlerFactory
implements URLStreamHandlerFactory {
    private final List<String> protocols;
    private final UrlStreamHandlerImpl streamHandler;

    AbstractUrlStreamHandlerFactory(String protocol, String ... protocols) {
        this.protocols = Stream.concat(Stream.of(protocol), Stream.of(protocols)).toList();
        this.streamHandler = new UrlStreamHandlerImpl();
    }

    @Override
    public final @Nullable URLStreamHandler createURLStreamHandler(String protocol) {
        return this.protocols.contains(protocol) ? this.streamHandler : null;
    }

    abstract URLConnection createUrlConnection(URL var1) throws IOException;

    private final class UrlStreamHandlerImpl
    extends URLStreamHandler {
        private UrlStreamHandlerImpl() {
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return AbstractUrlStreamHandlerFactory.this.createUrlConnection(url);
        }
    }
}

