/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.urls;

import io.github.ascopes.protobufmavenplugin.urls.HttpRequestException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

final class HttpClientUrlConnection
extends URLConnection {
    private final HttpClient client;
    private final HttpRequest request;
    private @Nullable HttpResponse<InputStream> response;

    HttpClientUrlConnection(URL url, HttpClient client) throws URISyntaxException {
        super(url);
        this.client = client;
        this.request = HttpRequest.newBuilder().uri(url.toURI()).GET().build();
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        try {
            this.response = this.client.send(this.request, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            InterruptedIOException newEx = new InterruptedIOException("HTTP request interrupted for " + String.valueOf(this.url));
            newEx.initCause(e);
            throw newEx;
        }
        catch (IOException e) {
            throw new IOException("Failed to fetch " + String.valueOf(this.url), e);
        }
        this.connected = true;
        if (this.response.statusCode() == 404) {
            throw new FileNotFoundException(this.url.toString());
        }
        if (this.response.statusCode() >= 400) {
            throw HttpRequestException.fromHttpResponse(this.response);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return Objects.requireNonNull(this.response).body();
    }
}

