/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.WebDriverManagerException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WdmConfig {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private WdmConfig() {
        throw new IllegalStateException("Utility class");
    }

    public static String getString(String key) {
        String value = "";
        if (!key.equals("")) {
            value = System.getenv(key.toUpperCase().replace(".", "_"));
            if (value == null) {
                value = System.getProperty(key);
            }
            if (value == null) {
                value = WdmConfig.getProperty(key);
            }
        }
        return value;
    }

    public static int getInt(String key) {
        return Integer.parseInt(WdmConfig.getString(key));
    }

    public static boolean getBoolean(String key) {
        return Boolean.parseBoolean(WdmConfig.getString(key));
    }

    public static URL getUrl(String key) {
        try {
            return new URL(WdmConfig.getString(key));
        }
        catch (MalformedURLException e) {
            throw new WebDriverManagerException(e);
        }
    }

    private static String getProperty(String key) {
        String value = null;
        Properties properties = new Properties();
        try {
            InputStream inputStream = WdmConfig.class.getResourceAsStream(System.getProperty("wdm.properties", "/webdrivermanager.properties"));
            properties.load(inputStream);
            value = properties.getProperty(key);
        }
        catch (Exception e) {
            throw new WebDriverManagerException(e);
        }
        finally {
            if (value == null) {
                log.trace("Property key {} not found, using default value", (Object)key);
                value = "";
            }
        }
        return value;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

