/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;

public enum OperatingSystem {
    WIN(Collections.emptyList()),
    LINUX(Collections.emptyList()),
    MAC(Arrays.asList("osx"));

    List<String> osLabels;

    private OperatingSystem(List<String> osLabels) {
        this.osLabels = osLabels;
    }

    public Stream<String> osLabelsStream() {
        return this.osLabels.stream();
    }

    public boolean matchOs(String os) {
        return this.osLabelsStream().anyMatch(os::contains) || os.contains(this.getName());
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean isWin() {
        return this == WIN;
    }

    public boolean isMac() {
        return this == MAC;
    }

    public boolean isLinux() {
        return this == LINUX;
    }
}

