/*
 * Decompiled with CFR 0.152.
 */
package qrcode.color;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import qrcode.QRCode;
import qrcode.color.Colors;
import qrcode.color.QRCodeColorFunction;
import qrcode.internals.QRCodeSquare;
import qrcode.render.QRCodeGraphics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J(\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lqrcode/color/LinearGradientColorFunction;", "Lqrcode/color/QRCodeColorFunction;", "startForegroundColor", "", "endForegroundColor", "backgroundColor", "vertical", "", "<init>", "(IIIZ)V", "getStartForegroundColor", "()I", "getEndForegroundColor", "getBackgroundColor", "getVertical", "()Z", "setVertical", "(Z)V", "startComponents", "", "endComponents", "fg", "row", "col", "qrCode", "Lqrcode/QRCode;", "qrCodeGraphics", "Lqrcode/render/QRCodeGraphics;", "bg", "qrcode-kotlin"})
public final class LinearGradientColorFunction
implements QRCodeColorFunction {
    private final int startForegroundColor;
    private final int endForegroundColor;
    private final int backgroundColor;
    private boolean vertical;
    @NotNull
    private final int[] startComponents;
    @NotNull
    private final int[] endComponents;

    @JvmOverloads
    public LinearGradientColorFunction(int startForegroundColor, int endForegroundColor, int backgroundColor, boolean vertical) {
        this.startForegroundColor = startForegroundColor;
        this.endForegroundColor = endForegroundColor;
        this.backgroundColor = backgroundColor;
        this.vertical = vertical;
        this.startComponents = Colors.getRGBA(this.startForegroundColor);
        this.endComponents = Colors.getRGBA(this.endForegroundColor);
    }

    public /* synthetic */ LinearGradientColorFunction(int n, int n2, int n3, boolean bl, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n3 = -1;
        }
        if ((n4 & 8) != 0) {
            bl = true;
        }
        this(n, n2, n3, bl);
    }

    public final int getStartForegroundColor() {
        return this.startForegroundColor;
    }

    public final int getEndForegroundColor() {
        return this.endForegroundColor;
    }

    public final int getBackgroundColor() {
        return this.backgroundColor;
    }

    public final boolean getVertical() {
        return this.vertical;
    }

    public final void setVertical(boolean bl) {
        this.vertical = bl;
    }

    @Override
    public int fg(int row, int col, @NotNull QRCode qrCode, @NotNull QRCodeGraphics qrCodeGraphics) {
        Intrinsics.checkNotNullParameter((Object)qrCode, (String)"qrCode");
        Intrinsics.checkNotNullParameter((Object)qrCodeGraphics, (String)"qrCodeGraphics");
        double pct = (double)(this.vertical ? row : col) / (double)((Object[])qrCode.getRawData()).length;
        double r = (double)this.startComponents[0] * (1.0 - pct) + (double)this.endComponents[0] * pct;
        double g = (double)this.startComponents[1] * (1.0 - pct) + (double)this.endComponents[1] * pct;
        double b = (double)this.startComponents[2] * (1.0 - pct) + (double)this.endComponents[2] * pct;
        return Colors.rgba(RangesKt.coerceIn((int)MathKt.roundToInt((double)r), (ClosedRange)((ClosedRange)new IntRange(0, 255))), RangesKt.coerceIn((int)MathKt.roundToInt((double)g), (ClosedRange)((ClosedRange)new IntRange(0, 255))), RangesKt.coerceIn((int)MathKt.roundToInt((double)b), (ClosedRange)((ClosedRange)new IntRange(0, 255))), 255);
    }

    @Override
    public int bg(int row, int col, @NotNull QRCode qrCode, @NotNull QRCodeGraphics qrCodeGraphics) {
        Intrinsics.checkNotNullParameter((Object)qrCode, (String)"qrCode");
        Intrinsics.checkNotNullParameter((Object)qrCodeGraphics, (String)"qrCodeGraphics");
        return this.backgroundColor;
    }

    @Override
    public int colorFn(@NotNull QRCodeSquare square, @NotNull QRCode qrCode, @NotNull QRCodeGraphics qrCodeGraphics) {
        return QRCodeColorFunction.DefaultImpls.colorFn(this, square, qrCode, qrCodeGraphics);
    }

    @Override
    public void beforeRender(@NotNull QRCode qrCode, @NotNull QRCodeGraphics qrCodeGraphics) {
        QRCodeColorFunction.DefaultImpls.beforeRender(this, qrCode, qrCodeGraphics);
    }

    @JvmOverloads
    public LinearGradientColorFunction(int startForegroundColor, int endForegroundColor, int backgroundColor) {
        this(startForegroundColor, endForegroundColor, backgroundColor, false, 8, null);
    }

    @JvmOverloads
    public LinearGradientColorFunction(int startForegroundColor, int endForegroundColor) {
        this(startForegroundColor, endForegroundColor, 0, false, 12, null);
    }
}

