/*
 * Decompiled with CFR 0.152.
 */
package qrcode.internals;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import qrcode.internals.BitBuffer;
import qrcode.internals.QRData;
import qrcode.raw.QRCodeDataType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lqrcode/internals/QRAlphaNum;", "Lqrcode/internals/QRData;", "data", "", "<init>", "(Ljava/lang/String;)V", "write", "", "buffer", "Lqrcode/internals/BitBuffer;", "length", "", "charCode", "c", "", "qrcode-kotlin"})
public final class QRAlphaNum
extends QRData {
    public QRAlphaNum(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(QRCodeDataType.UPPER_ALPHA_NUM, data);
    }

    @Override
    public void write(@NotNull BitBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int i = 0;
        int dataLength = this.getData().length();
        while (i + 1 < dataLength) {
            buffer.put(this.charCode(this.getData().charAt(i)) * 45 + this.charCode(this.getData().charAt(i + 1)), 11);
            i += 2;
        }
        if (i < dataLength) {
            buffer.put(this.charCode(this.getData().charAt(i)), 6);
        }
    }

    @Override
    public int length() {
        return this.getData().length();
    }

    private final int charCode(char c) {
        int n;
        char c2 = c;
        boolean bl = '0' <= c2 ? c2 < ':' : false;
        if (bl) {
            n = c - 48;
        } else {
            boolean bl2 = 'A' <= c2 ? c2 < '[' : false;
            if (bl2) {
                n = c - 65 + 10;
            } else {
                switch (c) {
                    case ' ': {
                        n = 36;
                        break;
                    }
                    case '$': {
                        n = 37;
                        break;
                    }
                    case '%': {
                        n = 38;
                        break;
                    }
                    case '*': {
                        n = 39;
                        break;
                    }
                    case '+': {
                        n = 40;
                        break;
                    }
                    case '-': {
                        n = 41;
                        break;
                    }
                    case '.': {
                        n = 42;
                        break;
                    }
                    case '/': {
                        n = 43;
                        break;
                    }
                    case ':': {
                        n = 44;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal character: " + c);
                    }
                }
            }
        }
        return n;
    }
}

