/*
 * Decompiled with CFR 0.152.
 */
package qrcode.internals;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJF\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lqrcode/internals/QRMath;", "", "<init>", "()V", "EXP_TABLE", "", "LOG_TABLE", "glog", "", "n", "gexp", "rectsIntersect", "", "x1", "y1", "w1", "h1", "x2", "y2", "w2", "h2", "qrcode-kotlin"})
public final class QRMath {
    @NotNull
    public static final QRMath INSTANCE;
    @NotNull
    private static final int[] EXP_TABLE;
    @NotNull
    private static final int[] LOG_TABLE;

    private QRMath() {
    }

    public final int glog(int n) {
        return LOG_TABLE[n];
    }

    public final int gexp(int n) {
        int i;
        for (i = n; i < 0; i += 255) {
        }
        while (i >= 256) {
            i -= 255;
        }
        return EXP_TABLE[i];
    }

    public final boolean rectsIntersect(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        int x1End = x1 + w1;
        int y1End = y1 + h1;
        int x2End = x2 + w2;
        int y2End = y2 + h2;
        return x1End < x2 || x1 > x2End || y1End < y2 || y1 > y2End;
    }

    static {
        int i;
        INSTANCE = new QRMath();
        EXP_TABLE = new int[256];
        LOG_TABLE = new int[256];
        for (i = 0; i < 8; ++i) {
            QRMath.EXP_TABLE[i] = 1 << i;
        }
        for (i = 8; i < 256; ++i) {
            QRMath.EXP_TABLE[i] = EXP_TABLE[i - 4] ^ EXP_TABLE[i - 5] ^ EXP_TABLE[i - 6] ^ EXP_TABLE[i - 8];
        }
        for (i = 0; i < 255; ++i) {
            QRMath.LOG_TABLE[QRMath.EXP_TABLE[i]] = i;
        }
    }
}

