/*
 * Decompiled with CFR 0.152.
 */
package qrcode.render;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\"\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000b2\b\b\u0002\u0010\u0017\u001a\u00020\u00032\b\b\u0002\u0010\u0018\u001a\u00020\u0003J\u0012\u0010\u0019\u001a\u00020\u000b2\b\b\u0002\u0010\u001a\u001a\u00020\u0011H\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014J5\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001e0#H\u0014\u00a2\u0006\u0002\u0010$J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010%\u001a\u00020\u001eJ\u0013\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0016\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u001a\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010+\u001a\u00020,H\u0017J\u0013\u00100\u001a\b\u0012\u0004\u0012\u00020,0'H\u0016\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020\u0001H\u0016J8\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u00108\u001a\u00020!H\u0016J8\u00109\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u00108\u001a\u00020!H\u0016J0\u0010<\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0010\u0010=\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J@\u0010>\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u00108\u001a\u00020!H\u0016J8\u0010@\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J8\u0010A\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u00108\u001a\u00020!H\u0016J0\u0010B\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\"\u0010C\u001a\u00020\u001e2\b\u0010D\u001a\u0004\u0018\u00010*2\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0003H\u0016J\"\u0010C\u001a\u00020\u001e2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0003H\u0016J\u0014\u0010E\u001a\u00020\u001e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0FR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lqrcode/render/QRCodeGraphics;", "", "width", "", "height", "<init>", "(II)V", "getWidth", "()I", "getHeight", "image", "Ljava/awt/image/BufferedImage;", "colorCache", "Ljava/util/HashMap;", "Ljava/awt/Color;", "Lkotlin/collections/HashMap;", "changed", "", "customImage", "customImageOffsetX", "customImageOffsetY", "useCustomBufferedImage", "bufferedImage", "offsetX", "offsetY", "createImage", "force", "createGraphics", "Ljava/awt/Graphics2D;", "draw", "", "color", "strokeThickness", "", "action", "Lkotlin/Function1;", "(ILjava/lang/Double;Lkotlin/jvm/functions/Function1;)V", "reset", "dimensions", "", "()[Ljava/lang/Integer;", "getBytes", "", "format", "", "writeImage", "destination", "Ljava/io/OutputStream;", "availableFormats", "()[Ljava/lang/String;", "nativeImage", "drawLine", "x1", "y1", "x2", "y2", "thickness", "drawRect", "x", "y", "fillRect", "fill", "drawRoundRect", "borderRadius", "fillRoundRect", "drawEllipse", "fillEllipse", "drawImage", "rawData", "directDraw", "Ljava/util/function/Consumer;", "qrcode-kotlin"})
public class QRCodeGraphics {
    private final int width;
    private final int height;
    private BufferedImage image;
    @NotNull
    private final HashMap<Integer, Color> colorCache;
    private boolean changed;
    private boolean customImage;
    private int customImageOffsetX;
    private int customImageOffsetY;

    public QRCodeGraphics(int width, int height) {
        this.width = width;
        this.height = height;
        this.colorCache = new HashMap();
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final QRCodeGraphics useCustomBufferedImage(@NotNull BufferedImage bufferedImage, int offsetX, int offsetY) {
        Intrinsics.checkNotNullParameter((Object)bufferedImage, (String)"bufferedImage");
        this.customImage = true;
        this.image = bufferedImage;
        this.customImageOffsetX = offsetX;
        this.customImageOffsetY = offsetY;
        return this;
    }

    public static /* synthetic */ QRCodeGraphics useCustomBufferedImage$default(QRCodeGraphics qRCodeGraphics, BufferedImage bufferedImage, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: useCustomBufferedImage");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return qRCodeGraphics.useCustomBufferedImage(bufferedImage, n, n2);
    }

    @NotNull
    protected BufferedImage createImage(boolean force) {
        BufferedImage bufferedImage;
        if (!this.customImage && (force || this.image == null)) {
            this.image = new BufferedImage(this.width, this.height, 2);
            this.customImageOffsetX = 0;
            this.customImageOffsetY = 0;
        }
        if ((bufferedImage = this.image) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"image");
            bufferedImage = null;
        }
        return bufferedImage;
    }

    public static /* synthetic */ BufferedImage createImage$default(QRCodeGraphics qRCodeGraphics, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createImage");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return qRCodeGraphics.createImage(bl);
    }

    @NotNull
    protected Graphics2D createGraphics() {
        Graphics2D graphics2D = QRCodeGraphics.createImage$default(this, false, 1, null).createGraphics();
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"createGraphics(...)");
        return graphics2D;
    }

    protected void draw(int color, @Nullable Double strokeThickness, @NotNull Function1<? super Graphics2D, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.changed = true;
        Graphics2D graphics = this.createGraphics();
        Color color2 = this.colorCache.computeIfAbsent(color, arg_0 -> QRCodeGraphics.draw$lambda$1(arg_0 -> QRCodeGraphics.draw$lambda$0(color, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"computeIfAbsent(...)");
        Color jdkColor = color2;
        if (strokeThickness != null && strokeThickness > 0.0) {
            graphics.setStroke(new BasicStroke((float)strokeThickness.doubleValue(), 1, 1));
        }
        graphics.setColor(jdkColor);
        graphics.setBackground(jdkColor);
        graphics.setPaint(jdkColor);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        action.invoke((Object)graphics);
        graphics.dispose();
    }

    public static /* synthetic */ void draw$default(QRCodeGraphics qRCodeGraphics, int n, Double d, Function1 function1, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: draw");
        }
        if ((n2 & 2) != 0) {
            d = null;
        }
        qRCodeGraphics.draw(n, d, (Function1<? super Graphics2D, Unit>)function1);
    }

    public boolean changed() {
        return this.changed;
    }

    public final void reset() {
        if (this.changed) {
            this.changed = false;
            this.createImage(true);
        }
    }

    @NotNull
    public Integer[] dimensions() {
        Integer[] integerArray = new Integer[]{this.width, this.height};
        return integerArray;
    }

    @NotNull
    public byte[] getBytes() {
        return this.getBytes("PNG");
    }

    @NotNull
    public byte[] getBytes(@NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        ByteArrayOutputStream it = new ByteArrayOutputStream();
        boolean bl = false;
        this.writeImage(it, format);
        byte[] byArray = it.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"let(...)");
        return byArray;
    }

    @JvmOverloads
    public void writeImage(@NotNull OutputStream destination, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        boolean wasImageWritten = ImageIO.write((RenderedImage)QRCodeGraphics.createImage$default(this, false, 1, null), format, destination);
        if (!wasImageWritten) {
            throw new UnsupportedOperationException("Unsupported format: " + format);
        }
    }

    public static /* synthetic */ void writeImage$default(QRCodeGraphics qRCodeGraphics, OutputStream outputStream, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeImage");
        }
        if ((n & 2) != 0) {
            string = "PNG";
        }
        qRCodeGraphics.writeImage(outputStream, string);
    }

    @NotNull
    public String[] availableFormats() {
        String[] stringArray = ImageIO.getWriterFileSuffixes();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getWriterFileSuffixes(...)");
        return stringArray;
    }

    @NotNull
    public Object nativeImage() {
        return QRCodeGraphics.createImage$default(this, false, 1, null);
    }

    public void drawLine(int x1, int y1, int x2, int y2, int color, double thickness) {
        this.draw(color, thickness, (Function1<? super Graphics2D, Unit>)((Function1)arg_0 -> QRCodeGraphics.drawLine$lambda$3(x1, this, y1, x2, y2, arg_0)));
    }

    public void drawRect(int x, int y, int width, int height, int color, double thickness) {
        this.draw(color, thickness, (Function1<? super Graphics2D, Unit>)((Function1)arg_0 -> QRCodeGraphics.drawRect$lambda$4(thickness, x, this, y, width, height, arg_0)));
    }

    public void fillRect(int x, int y, int width, int height, int color) {
        QRCodeGraphics.draw$default(this, color, null, arg_0 -> QRCodeGraphics.fillRect$lambda$5(x, this, y, width, height, arg_0), 2, null);
    }

    public void fill(int color) {
        this.fillRect(0 + this.customImageOffsetX, 0 + this.customImageOffsetY, this.width, this.height, color);
    }

    public void drawRoundRect(int x, int y, int width, int height, int borderRadius, int color, double thickness) {
        this.draw(color, thickness, (Function1<? super Graphics2D, Unit>)((Function1)arg_0 -> QRCodeGraphics.drawRoundRect$lambda$6(thickness, x, this, y, width, height, borderRadius, arg_0)));
    }

    public void fillRoundRect(int x, int y, int width, int height, int borderRadius, int color) {
        QRCodeGraphics.draw$default(this, color, null, arg_0 -> QRCodeGraphics.fillRoundRect$lambda$7(x, this, y, width, height, borderRadius, arg_0), 2, null);
    }

    public void drawEllipse(int x, int y, int width, int height, int color, double thickness) {
        this.draw(color, thickness, (Function1<? super Graphics2D, Unit>)((Function1)arg_0 -> QRCodeGraphics.drawEllipse$lambda$8(thickness, x, this, y, width, height, arg_0)));
    }

    public void fillEllipse(int x, int y, int width, int height, int color) {
        QRCodeGraphics.draw$default(this, color, null, arg_0 -> QRCodeGraphics.fillEllipse$lambda$9(x, this, y, width, height, arg_0), 2, null);
    }

    public void drawImage(@Nullable byte[] rawData, int x, int y) {
        if (rawData != null && !(rawData.length == 0)) {
            QRCodeGraphics.draw$default(this, 0, null, arg_0 -> QRCodeGraphics.drawImage$lambda$11(rawData, this, x, y, arg_0), 2, null);
        }
    }

    public void drawImage(@Nullable BufferedImage image, int x, int y) {
        if (image != null) {
            QRCodeGraphics.draw$default(this, 0, null, arg_0 -> QRCodeGraphics.drawImage$lambda$12(image, x, this, y, arg_0), 2, null);
        }
    }

    public final void directDraw(@NotNull Consumer<Graphics2D> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.draw(0, null, (Function1<? super Graphics2D, Unit>)((Function1)arg_0 -> QRCodeGraphics.directDraw$lambda$13(action, arg_0)));
    }

    @JvmOverloads
    public final void writeImage(@NotNull OutputStream destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        QRCodeGraphics.writeImage$default(this, destination, null, 2, null);
    }

    private static final Color draw$lambda$0(int $color, Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Color($color, true);
    }

    private static final Color draw$lambda$1(Function1 $tmp0, Object p0) {
        return (Color)$tmp0.invoke(p0);
    }

    private static final Unit drawLine$lambda$3(int $x1, QRCodeGraphics this$0, int $y1, int $x2, int $y2, Graphics2D it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.drawLine($x1 + this$0.customImageOffsetX, $y1 + this$0.customImageOffsetY, $x2 + this$0.customImageOffsetX, $y2 + this$0.customImageOffsetY);
        return Unit.INSTANCE;
    }

    private static final Unit drawRect$lambda$4(double $thickness, int $x, QRCodeGraphics this$0, int $y, int $width, int $height, Graphics2D it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int halfThickness = RangesKt.coerceAtLeast((int)MathKt.roundToInt((double)($thickness / 2.0)), (int)0);
        it.drawRect($x + halfThickness + this$0.customImageOffsetX, $y + halfThickness + this$0.customImageOffsetY, $width - halfThickness * 2, $height - halfThickness * 2);
        return Unit.INSTANCE;
    }

    private static final Unit fillRect$lambda$5(int $x, QRCodeGraphics this$0, int $y, int $width, int $height, Graphics2D it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.fillRect($x + this$0.customImageOffsetX, $y + this$0.customImageOffsetY, $width, $height);
        return Unit.INSTANCE;
    }

    private static final Unit drawRoundRect$lambda$6(double $thickness, int $x, QRCodeGraphics this$0, int $y, int $width, int $height, int $borderRadius, Graphics2D it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int halfThickness = RangesKt.coerceAtLeast((int)MathKt.roundToInt((double)($thickness / 2.0)), (int)0);
        it.drawRoundRect($x + halfThickness + this$0.customImageOffsetX, $y + halfThickness + this$0.customImageOffsetY, $width - halfThickness * 2, $height - halfThickness * 2, $borderRadius, $borderRadius);
        return Unit.INSTANCE;
    }

    private static final Unit fillRoundRect$lambda$7(int $x, QRCodeGraphics this$0, int $y, int $width, int $height, int $borderRadius, Graphics2D it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.fillRoundRect($x + this$0.customImageOffsetX, $y + this$0.customImageOffsetY, $width, $height, $borderRadius, $borderRadius);
        return Unit.INSTANCE;
    }

    private static final Unit drawEllipse$lambda$8(double $thickness, int $x, QRCodeGraphics this$0, int $y, int $width, int $height, Graphics2D it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int halfThickness = RangesKt.coerceAtLeast((int)MathKt.roundToInt((double)($thickness / 2.0)), (int)0);
        it.drawOval($x + halfThickness + this$0.customImageOffsetX, $y + halfThickness + this$0.customImageOffsetY, $width - 1 - halfThickness * 2, $height - 1 - halfThickness * 2);
        return Unit.INSTANCE;
    }

    private static final Unit fillEllipse$lambda$9(int $x, QRCodeGraphics this$0, int $y, int $width, int $height, Graphics2D it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.fillOval($x + this$0.customImageOffsetX, $y + this$0.customImageOffsetY, $width, $height);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit drawImage$lambda$11(byte[] $rawData, QRCodeGraphics this$0, int $x, int $y, Graphics2D it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Closeable closeable = new ByteArrayInputStream($rawData);
        Throwable throwable = null;
        try {
            ByteArrayInputStream inStream = (ByteArrayInputStream)closeable;
            boolean bl = false;
            this$0.drawImage(ImageIO.read(inStream), $x + this$0.customImageOffsetX, $y + this$0.customImageOffsetY);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawImage$lambda$12(BufferedImage $image, int $x, QRCodeGraphics this$0, int $y, Graphics2D it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.drawImage((Image)$image, $x + this$0.customImageOffsetX, $y + this$0.customImageOffsetY, null);
        return Unit.INSTANCE;
    }

    private static final Unit directDraw$lambda$13(Consumer $action, Graphics2D it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $action.accept(it);
        return Unit.INSTANCE;
    }
}

