/*
 * Decompiled with CFR 0.152.
 */
package qrcode.shape;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import qrcode.render.QRCodeGraphics;
import qrcode.shape.DefaultShapeFunction;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B'\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J@\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lqrcode/shape/RoundSquaresShapeFunction;", "Lqrcode/shape/DefaultShapeFunction;", "squareSize", "", "radius", "innerSpace", "<init>", "(III)V", "fillRect", "", "x", "y", "width", "height", "color", "canvas", "Lqrcode/render/QRCodeGraphics;", "drawRect", "thickness", "", "Companion", "qrcode-kotlin"})
public class RoundSquaresShapeFunction
extends DefaultShapeFunction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int radius;

    @JvmOverloads
    public RoundSquaresShapeFunction(int squareSize, int radius, int innerSpace) {
        super(squareSize, innerSpace);
        this.radius = radius;
    }

    public /* synthetic */ RoundSquaresShapeFunction(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            n = 25;
        }
        if ((n4 & 2) != 0) {
            n2 = Companion.defaultRadius(n);
        }
        if ((n4 & 4) != 0) {
            n3 = Companion.defaultInnerSpace(n);
        }
        this(n, n2, n3);
    }

    @Override
    public void fillRect(int x, int y, int width, int height, int color, @NotNull QRCodeGraphics canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.fillRoundRect(x, y, width, height, this.radius, color);
    }

    @Override
    public void drawRect(int x, int y, int width, int height, int color, double thickness, @NotNull QRCodeGraphics canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.drawRoundRect(x, y, width, height, this.radius, color, thickness);
    }

    @JvmOverloads
    public RoundSquaresShapeFunction(int squareSize, int radius) {
        this(squareSize, radius, 0, 4, null);
    }

    @JvmOverloads
    public RoundSquaresShapeFunction(int squareSize) {
        this(squareSize, 0, 0, 6, null);
    }

    @JvmOverloads
    public RoundSquaresShapeFunction() {
        this(0, 0, 0, 7, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"Lqrcode/shape/RoundSquaresShapeFunction$Companion;", "", "<init>", "()V", "defaultRadius", "", "squareSize", "defaultInnerSpace", "qrcode-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public final int defaultRadius(int squareSize) {
            return MathKt.roundToInt((double)((double)squareSize / 1.75));
        }

        public final int defaultInnerSpace(int squareSize) {
            return MathKt.roundToInt((double)((double)squareSize * 0.05));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

