/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration.library.reader;

import io.github.kbuntrock.JavaClassAnalyser;
import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.library.reader.AstractLibraryReader;
import io.github.kbuntrock.configuration.library.reader.ClassLoaderUtils;
import io.github.kbuntrock.model.DataObject;
import io.github.kbuntrock.model.Endpoint;
import io.github.kbuntrock.model.OperationType;
import io.github.kbuntrock.model.ParameterObject;
import io.github.kbuntrock.model.Tag;
import io.github.kbuntrock.utils.OpenApiTypeResolver;
import io.github.kbuntrock.utils.ParameterLocation;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.http.HttpStatus;

public class JavaxRsReader
extends AstractLibraryReader {
    private Class jakartaNotNull;
    private Class jakartaHttpServletRequest;
    private Class responseAnnotation;

    public JavaxRsReader(ApiConfiguration apiConfiguration, OpenApiTypeResolver openApiTypeResolver) {
        super(apiConfiguration, openApiTypeResolver);
        try {
            this.jakartaNotNull = ClassLoaderUtils.getByName("jakarta.validation.constraints.NotNull");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            this.jakartaHttpServletRequest = ClassLoaderUtils.getByName("jakarta.servlet.http.HttpServletRequest");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.initCustomResponseAnnotation(apiConfiguration);
    }

    private void initCustomResponseAnnotation(ApiConfiguration apiConfiguration) {
        if (apiConfiguration.getCustomResponseTypeAnnotation() != null) {
            String annotationName = apiConfiguration.getCustomResponseTypeAnnotation();
            try {
                this.responseAnnotation = ClassLoaderUtils.getByName(annotationName);
                try {
                    Method responseAnnotationMethod = this.responseAnnotation.getMethod("value", new Class[0]);
                    if (responseAnnotationMethod.getReturnType() != Class.class) {
                        throw new RuntimeException("Annotation " + annotationName + " does not declare a method called value()");
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Annotation " + annotationName + " does not declare a method value() returning a Class");
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load annotation class " + annotationName);
            }
        }
    }

    @Override
    public List<String> readBasePaths(Class<?> clazz, MergedAnnotations mergedAnnotations) {
        String path;
        List<String> basePaths = Collections.singletonList("");
        MergedAnnotation requestMappingMergedAnnotation = mergedAnnotations.get("javax.ws.rs.Path");
        if (requestMappingMergedAnnotation.isPresent() && !StringUtils.isEmpty((CharSequence)(path = requestMappingMergedAnnotation.getString("value")))) {
            basePaths = Collections.singletonList(path);
        }
        return basePaths;
    }

    @Override
    public void computeAnnotations(Class clazz, String basePath, Method method, MergedAnnotations mergedAnnotations, Tag tag) throws MojoFailureException {
        MergedAnnotation requestMappingMergedAnnotation = mergedAnnotations.get("javax.ws.rs.Path");
        if (requestMappingMergedAnnotation.isPresent()) {
            for (JavaxRsHttpVerb verb : JavaxRsHttpVerb.values()) {
                MergedAnnotation m = mergedAnnotations.get(verb.getAnnotationClass());
                if (!m.isPresent()) continue;
                String methodIdentifier = JavaClassAnalyser.createMethodIdentifier(method);
                List<ParameterObject> parameterObjects = this.readParameters(clazz, method, mergedAnnotations);
                DataObject responseObject = this.readResponseObject(clazz, method, mergedAnnotations);
                int responseCode = this.readResponseCode(null);
                String path = this.readEndpointPaths(basePath, (MergedAnnotation<? extends Annotation>)requestMappingMergedAnnotation).get(0);
                Endpoint endpoint = new Endpoint();
                endpoint.setType(OperationType.fromJavax(verb.getAnnotationClass()));
                endpoint.setPath(path);
                endpoint.setName(method.getName());
                endpoint.setParameters(parameterObjects);
                endpoint.setResponseObject(responseObject);
                endpoint.setResponseCode(responseCode);
                this.setConsumeProduceProperties(endpoint, mergedAnnotations);
                endpoint.setIdentifier(methodIdentifier);
                endpoint.setDeprecated(this.isDeprecated(method));
                this.setSwaggerAnnotatedEndpointProperties(endpoint, mergedAnnotations);
                tag.addEndpoint(endpoint);
                this.logger.debug((CharSequence)("Finished parsing endpoint : " + endpoint.getName() + " - " + endpoint.getType().name()));
            }
        }
    }

    @Override
    protected List<ParameterObject> readParameters(Class clazz, Method originalMethod, MergedAnnotations endpointAnnotations) {
        this.logger.debug((CharSequence)("Reading parameters from " + originalMethod.getName()));
        Set overridenMethods = MethodUtils.getOverrideHierarchy((Method)originalMethod, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE);
        LinkedHashMap<String, ParameterObject> parameters = new LinkedHashMap<String, ParameterObject>();
        for (Method method : overridenMethods) {
            boolean bodyParameterDetected = false;
            for (Parameter parameter : method.getParameters()) {
                MergedAnnotation requestParamMA;
                MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)parameter, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
                if (!this.openApiTypeResolver.canBeDocumented(parameter, mergedAnnotations)) continue;
                this.logger.debug((CharSequence)("Parameter : " + parameter.getName()));
                ParameterObject paramObj = new ParameterObject(parameter.getName(), this.genericityResolver.resolve(clazz, parameter.getParameterizedType()), this.openApiTypeResolver);
                paramObj = this.unwrapParameterObject(paramObj);
                if (mergedAnnotations.get("javax.ws.rs.BeanParam").isPresent()) continue;
                parameters.putIfAbsent(paramObj.getName(), paramObj);
                MergedAnnotation notnullMA = mergedAnnotations.get("javax.validation.constraints.NotNull");
                if (notnullMA.isPresent()) {
                    paramObj.setRequired(notnullMA.isPresent());
                } else if (this.jakartaNotNull != null) {
                    paramObj.setRequired(mergedAnnotations.get(this.jakartaNotNull).isPresent());
                }
                MergedAnnotation pathVariableMA = mergedAnnotations.get("javax.ws.rs.PathParam");
                if (pathVariableMA.isPresent()) {
                    paramObj.setLocation(ParameterLocation.PATH);
                    paramObj.setRequired(true);
                    String value = pathVariableMA.getString("value");
                    if (!StringUtils.isEmpty((CharSequence)value)) {
                        paramObj.setName(value);
                    }
                    this.logger.debug((CharSequence)("PathParam annotation detected (" + paramObj.getName() + ")"));
                }
                if ((requestParamMA = mergedAnnotations.get("javax.ws.rs.QueryParam")).isPresent()) {
                    if (paramObj.isMultipartFile()) {
                        paramObj.setLocation(ParameterLocation.BODY);
                    } else {
                        paramObj.setLocation(ParameterLocation.QUERY);
                    }
                    String value = requestParamMA.getString("value");
                    if (!StringUtils.isEmpty((CharSequence)value)) {
                        paramObj.setName(value);
                    }
                    this.logger.debug((CharSequence)("QueryParam annotation detected (" + paramObj.getName() + "), location is " + paramObj.getLocation().toString()));
                }
                if (paramObj.getLocation() == null) {
                    if (bodyParameterDetected) {
                        bodyParameterDetected = true;
                        this.logger.error((CharSequence)("Cannot set multiple body parameters, (" + paramObj.getName() + ")"));
                    } else {
                        paramObj.setLocation(ParameterLocation.BODY);
                        this.logger.debug((CharSequence)("Body parameter detected (" + paramObj.getName() + "), location is " + paramObj.getLocation().toString()));
                    }
                }
                this.setSwaggerAnnotatedParameterProperties(parameter, mergedAnnotations, paramObj);
            }
        }
        return parameters.values().stream().filter(x -> x.getLocation() != null).collect(Collectors.toList());
    }

    @Override
    protected List<String> readEndpointPaths(String basePath, MergedAnnotation<? extends Annotation> pathMergedAnnotation) {
        String path = pathMergedAnnotation.getString("value");
        if (path == null) {
            return Arrays.asList(JavaxRsReader.concatenateBasePathAndMethodPath(basePath, "", this.apiConfiguration.getPathEnhancement()));
        }
        return Arrays.asList(JavaxRsReader.concatenateBasePathAndMethodPath(basePath, path, this.apiConfiguration.getPathEnhancement()));
    }

    @Override
    protected void setConsumeProduceProperties(Endpoint endpoint, MergedAnnotations mergedAnnotations) throws MojoFailureException {
        String[] produces;
        String[] consumes;
        MergedAnnotation consumesMergedAnnotation = mergedAnnotations.get("javax.ws.rs.Consumes");
        MergedAnnotation producesMergedAnnotation = mergedAnnotations.get("javax.ws.rs.Produces");
        Optional<ParameterObject> body = endpoint.getParameters().stream().filter(x -> ParameterLocation.BODY == x.getLocation()).findAny();
        if (body.isPresent() && consumesMergedAnnotation.isPresent() && (consumes = consumesMergedAnnotation.getStringArray("value")).length > 0) {
            body.get().setFormats(Arrays.asList(consumes));
        }
        if (endpoint.getResponseObject() != null && producesMergedAnnotation.isPresent() && (produces = producesMergedAnnotation.getStringArray("value")).length > 0) {
            endpoint.setResponseFormats(Arrays.asList(produces));
        }
    }

    @Override
    protected int readResponseCode(MergedAnnotations mergedAnnotations) {
        return HttpStatus.OK.value();
    }

    @Override
    protected Type readResponseMethodType(Method method, MergedAnnotations mergedAnnotations) {
        if (this.responseAnnotation != null && mergedAnnotations.isPresent(this.responseAnnotation)) {
            return (Class)mergedAnnotations.get(this.responseAnnotation).getValue("value").get();
        }
        return method.getGenericReturnType();
    }

    private static enum JavaxRsHttpVerb {
        GET("javax.ws.rs.GET"),
        PUT("javax.ws.rs.PUT"),
        POST("javax.ws.rs.POST"),
        DELETE("javax.ws.rs.DELETE"),
        PATCH("javax.ws.rs.PATCH"),
        OPTIONS("javax.ws.rs.OPTIONS"),
        HEAD("javax.ws.rs.HEAD");

        private final String annotationClass;

        private JavaxRsHttpVerb(String annotationClass) {
            this.annotationClass = annotationClass;
        }

        public String getAnnotationClass() {
            return this.annotationClass;
        }
    }
}

