/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.github.javaparser.javadoc.JavadocBlockTag;
import io.github.kbuntrock.MojoRuntimeException;
import io.github.kbuntrock.TagLibrary;
import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.parser.CommonParserUtils;
import io.github.kbuntrock.configuration.parser.JsonParserUtils;
import io.github.kbuntrock.javadoc.ClassDocumentation;
import io.github.kbuntrock.javadoc.JavadocWrapper;
import io.github.kbuntrock.model.DataObject;
import io.github.kbuntrock.model.Endpoint;
import io.github.kbuntrock.model.ParameterObject;
import io.github.kbuntrock.model.Tag;
import io.github.kbuntrock.model.annotation.OperationResponse;
import io.github.kbuntrock.reflection.AdditionnalSchemaLibrary;
import io.github.kbuntrock.utils.Logger;
import io.github.kbuntrock.utils.ObjectsUtils;
import io.github.kbuntrock.utils.OpenApiConstants;
import io.github.kbuntrock.utils.OpenApiDataType;
import io.github.kbuntrock.utils.ParameterLocation;
import io.github.kbuntrock.utils.ProduceConsumeUtils;
import io.github.kbuntrock.yaml.model.Content;
import io.github.kbuntrock.yaml.model.Info;
import io.github.kbuntrock.yaml.model.Operation;
import io.github.kbuntrock.yaml.model.ParameterElement;
import io.github.kbuntrock.yaml.model.Property;
import io.github.kbuntrock.yaml.model.RequestBody;
import io.github.kbuntrock.yaml.model.Response;
import io.github.kbuntrock.yaml.model.Schema;
import io.github.kbuntrock.yaml.model.Server;
import io.github.kbuntrock.yaml.model.Specification;
import io.github.kbuntrock.yaml.model.TagElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class YamlWriter {
    private static final String SERVERS_FIELD = "servers";
    private static final String SECURITY_FIELD = "security";
    private static final String EXTERNAL_DOC_FIELD = "externalDocs";
    private static final String FILEFORMAT_JSON = "json";
    private final Log logger = Logger.INSTANCE.getLogger();
    private final ObjectMapper om;
    private final ApiConfiguration apiConfiguration;
    private final TagLibrary tagLibrary;
    private final MavenProject mavenProject;
    private Optional<JsonNode> freefields = Optional.empty();
    private Map<String, JsonNode> defaultErrors;

    public YamlWriter(MavenProject mavenProject, ApiConfiguration apiConfiguration, TagLibrary tagLibrary) {
        this.mavenProject = mavenProject;
        this.apiConfiguration = apiConfiguration;
        this.tagLibrary = tagLibrary;
        this.om = FILEFORMAT_JSON.equals(apiConfiguration.getFileFormat()) ? new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT) : new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR));
    }

    private void populateSpecificationFreeFields(Specification specification, Optional<JsonNode> freefields) {
        if (freefields.isPresent() && freefields.get().get(SERVERS_FIELD) != null) {
            specification.setServers(freefields.get().get(SERVERS_FIELD));
        } else {
            Server server = new Server();
            server.setUrl("");
            specification.setServers(Collections.singletonList(server));
        }
        if (freefields.isPresent()) {
            if (freefields.get().get(SECURITY_FIELD) != null) {
                specification.setSecurity(freefields.get().get(SECURITY_FIELD));
            }
            if (freefields.get().get(EXTERNAL_DOC_FIELD) != null) {
                specification.setExternalDocs(freefields.get().get(EXTERNAL_DOC_FIELD));
            }
        }
    }

    private String computeFreeFields(MavenProject mavenProject, ApiConfiguration apiConfiguration) {
        if (apiConfiguration.isMergeFreeFields() && apiConfiguration.getBaseFreeField() != null) {
            String baseContent = CommonParserUtils.getContentFromFileOrText(mavenProject, apiConfiguration.getBaseFreeField());
            String mergingContent = CommonParserUtils.getContentFromFileOrText(mavenProject, apiConfiguration.getFreeFields());
            return JsonParserUtils.merge(baseContent, mergingContent);
        }
        return CommonParserUtils.getContentFromFileOrText(mavenProject, apiConfiguration.getFreeFields());
    }

    public void write(File file, TagLibrary tagLibrary) throws IOException {
        this.freefields = JsonParserUtils.parse(this.computeFreeFields(this.mavenProject, this.apiConfiguration));
        Optional<JsonNode> defaultErrorsNode = JsonParserUtils.parse(CommonParserUtils.getContentFromFileOrText(this.mavenProject, this.apiConfiguration.getDefaultErrors()));
        if (defaultErrorsNode.isPresent()) {
            this.defaultErrors = new LinkedHashMap<String, JsonNode>();
            Iterator iterator = defaultErrorsNode.get().fields();
            iterator.forEachRemaining(entry -> this.defaultErrors.put((String)entry.getKey(), (JsonNode)entry.getValue()));
        }
        Specification specification = new Specification();
        Info info = new Info(this.mavenProject.getName(), this.mavenProject.getVersion(), this.freefields);
        specification.setInfo(info);
        this.populateSpecificationFreeFields(specification, this.freefields);
        specification.setTags(tagLibrary.getSortedTags().stream().map(tag -> {
            if (tagLibrary.hasJavadocMap() && tag.getDescription() == null) {
                ClassDocumentation classDocumentation = tagLibrary.getJavadocMap().computeIfAbsent(tag.getClazz().getCanonicalName(), k -> new ClassDocumentation(tag.getClazz().getCanonicalName(), tag.getClazz().getSimpleName()));
                if (classDocumentation == null) {
                    classDocumentation = new ClassDocumentation(tag.getClazz().getCanonicalName(), tag.getClazz().getSimpleName());
                    tagLibrary.getJavadocMap().put(tag.getClazz().getCanonicalName(), classDocumentation);
                }
                this.logger.debug((CharSequence)("Class documentation found for tag " + tag.getClazz().getSimpleName() + " ? " + (classDocumentation != null)));
                classDocumentation.inheritanceEnhancement(tag.getClazz(), ClassDocumentation.EnhancementType.METHODS, tagLibrary.getJavadocMap());
                return new TagElement(tag.computeConfiguredName(this.apiConfiguration), classDocumentation.getDescription().orElse(null));
            }
            return new TagElement(tag.computeConfiguredName(this.apiConfiguration), tag.getDescription());
        }).collect(Collectors.toList()));
        specification.setPaths(this.createPaths(tagLibrary));
        Map<String, Object> schemaSection = this.createSchemaSection(tagLibrary);
        boolean schemaSectionCreated = false;
        if (!schemaSection.isEmpty()) {
            specification.getComponents().put("schemas", schemaSection);
            schemaSectionCreated = true;
        }
        if (this.freefields.isPresent() && this.freefields.get().get("components") != null) {
            JsonNode componentsNode = this.freefields.get().get("components");
            if (componentsNode.get("schemas") != null) {
                if (schemaSectionCreated) {
                    Map createdSchema = (Map)specification.getComponents().get("schemas");
                    Iterator iterator = componentsNode.get("schemas").fields();
                    iterator.forEachRemaining(entry -> createdSchema.put((String)entry.getKey(), entry.getValue()));
                } else {
                    specification.getComponents().put("schemas", componentsNode.get("schemas"));
                }
            }
            for (String section : OpenApiConstants.COMPONENTS_STRUCTURE) {
                if (componentsNode.get(section) == null) continue;
                specification.getComponents().put(section, componentsNode.get(section));
            }
        }
        this.om.writeValue(file, (Object)specification);
    }

    private Map<String, Map<String, Operation>> createPaths(TagLibrary tagLibrary) {
        LinkedHashMap<String, Map<String, Operation>> paths = new LinkedHashMap<String, Map<String, Operation>>();
        HashMap<String, Integer> operationIds = new HashMap<String, Integer>();
        for (Tag tag : tagLibrary.getSortedTags()) {
            ClassDocumentation classDocumentation = tagLibrary.hasJavadocMap() ? tagLibrary.getJavadocMap().get(tag.getClazz().getCanonicalName()) : null;
            this.logger.debug((CharSequence)("Class documentation found for tag paths section " + tag.getClazz().getSimpleName() + " ? " + (classDocumentation != null)));
            ArrayList<Operation> operations = new ArrayList<Operation>();
            for (Endpoint endpoint : tag.getSortedEndpoints()) {
                List<ParameterObject> bodyParts;
                Content requestBodyContent;
                Iterator<String> queryParamBindingClassDoc;
                String description;
                Optional<JavadocBlockTag> parameterDoc;
                Integer nbEncounteredOperationId;
                String enhancedPath = this.apiConfiguration.getPathPrefix() + endpoint.getPath();
                paths.computeIfAbsent(enhancedPath, k -> new LinkedHashMap());
                Operation operation = new Operation();
                operations.add(operation);
                operation.setName(endpoint.getType().name());
                operation.setPath(enhancedPath);
                String computedTagName = tag.computeConfiguredName(this.apiConfiguration);
                operation.getTags().add(computedTagName);
                operation.setOperationId(ObjectsUtils.nonNullElse(endpoint.getOperationAnnotationInfo().getOperationId(), this.apiConfiguration.getOperationIdHelper().toOperationId(tag.getName(), computedTagName, endpoint.getName())));
                if (this.apiConfiguration.isLoopbackOperationName()) {
                    operation.setLoopbackOperationName(endpoint.getName());
                }
                operation.setDeprecated(endpoint.isDeprecated());
                JavadocWrapper methodJavadoc = null;
                if (classDocumentation != null) {
                    methodJavadoc = classDocumentation.getMethodsJavadocByIdentifier().get(endpoint.getIdentifier());
                    if (methodJavadoc != null) {
                        methodJavadoc.sortTags();
                    }
                    this.logger.debug((CharSequence)("Method documentation found for endpoint method " + endpoint.getIdentifier() + " ? " + (methodJavadoc != null)));
                }
                if (endpoint.getOperationAnnotationInfo().getDescription() != null) {
                    operation.setDescription(endpoint.getOperationAnnotationInfo().getDescription());
                } else if (methodJavadoc != null) {
                    operation.setDescription(methodJavadoc.getDescription().orElse(null));
                }
                if (endpoint.getOperationAnnotationInfo().getSummary() != null) {
                    operation.setSummary(endpoint.getOperationAnnotationInfo().getSummary());
                } else if (methodJavadoc != null) {
                    operation.setSummary(methodJavadoc.getSummary().orElse(null));
                }
                if (!operation.getPath().startsWith("/")) {
                    Logger.INSTANCE.getLogger().warn((CharSequence)("Operation " + operation.getOperationId() + " path should start with a \"/\" (" + operation.getPath() + ")"));
                }
                if ((nbEncounteredOperationId = operationIds.compute(operation.getOperationId(), (operationId, oldValue) -> oldValue == null ? 1 : oldValue + 1)) > 1) {
                    operation.setOperationId(operation.getOperationId() + nbEncounteredOperationId);
                }
                for (ParameterObject parameter : endpoint.getParameters().stream().filter(x -> ParameterLocation.BODY != x.getLocation() && ParameterLocation.BODY_PART != x.getLocation()).collect(Collectors.toList())) {
                    ParameterElement parameterElement = new ParameterElement();
                    parameterElement.setName(parameter.getName());
                    parameterElement.setIn(parameter.getLocation().toString().toLowerCase(Locale.ENGLISH));
                    parameterElement.setRequired(parameter.isRequired());
                    parameterElement.setAllowEmptyValue(parameter.isAllowEmptyValue());
                    Property schema = new Property(Content.fromDataObject(parameter, tagLibrary).getSingleSchema());
                    if (OpenApiDataType.ARRAY == parameter.getOpenApiResolvedType().getType() && ParameterLocation.PATH == parameter.getLocation()) {
                        this.logger.warn((CharSequence)("Array types in path or query parameter are not allowed : " + endpoint.getPath() + " - " + (Object)((Object)endpoint.getType())));
                    }
                    parameterElement.setSchema(schema);
                    if (parameter.getJavaClass() == Object.class && parameter.isAllowEmptyValue() && parameter.getLocation() == ParameterLocation.QUERY) {
                        parameterElement.setSchema(null);
                    }
                    if (methodJavadoc != null) {
                        parameterDoc = methodJavadoc.getParamBlockTagByName(parameter.getJavadocFieldName());
                        if (parameterDoc.isPresent() && !(description = ((JavadocBlockTag)parameterDoc.get()).getContent().toText()).isEmpty()) {
                            parameterElement.setDescription(((JavadocBlockTag)parameterDoc.get()).getContent().toText());
                        }
                        this.logger.debug((CharSequence)("Parameter documentation found for endpoint parameter " + parameterElement.getName() + " ? " + parameterDoc.isPresent()));
                    }
                    if (parameter.getJavadocFieldClassName() != null) {
                        Iterator<String> iterator = queryParamBindingClassDoc = tagLibrary.hasJavadocMap() ? tagLibrary.getJavadocMap().get(parameter.getJavadocFieldClassName()) : null;
                        if (queryParamBindingClassDoc != null) {
                            ((ClassDocumentation)((Object)queryParamBindingClassDoc)).inheritanceEnhancement(parameter.getJavaClass(), ClassDocumentation.EnhancementType.BOTH, tagLibrary.getJavadocMap());
                            JavadocWrapper javadocParamWrapper = ((ClassDocumentation)((Object)queryParamBindingClassDoc)).getFieldsJavadoc().get(parameterElement.getName());
                            if (javadocParamWrapper != null) {
                                Optional<String> desc = javadocParamWrapper.getDescription();
                                parameterElement.setDescription(desc.get());
                                Optional<String> summary = javadocParamWrapper.getSummary();
                                parameterElement.setSummary(summary.orElse(null));
                            }
                        }
                    }
                    operation.getParameters().add(parameterElement);
                }
                List<ParameterObject> bodies = endpoint.getParameters().stream().filter(x -> ParameterLocation.BODY == x.getLocation()).collect(Collectors.toList());
                if (bodies.size() > 1 && !YamlWriter.isFormData(bodies)) {
                    this.logger.warn((CharSequence)("More than one body is not allowed : " + endpoint.getPath() + " - " + (Object)((Object)endpoint.getType())));
                }
                if (!bodies.isEmpty()) {
                    RequestBody requestBody = new RequestBody();
                    operation.setRequestBody(requestBody);
                    ParameterObject body = bodies.get(0);
                    Content content = requestBodyContent = YamlWriter.isFormData(bodies) ? Content.fromMultipartBodies(bodies, tagLibrary) : Content.fromDataObject(body, tagLibrary);
                    if (body.getFormats() != null) {
                        queryParamBindingClassDoc = body.getFormats().iterator();
                        while (queryParamBindingClassDoc.hasNext()) {
                            String format = queryParamBindingClassDoc.next();
                            requestBody.getContent().put(format, requestBodyContent);
                        }
                    } else if (this.apiConfiguration.isDefaultProduceConsumeGuessing()) {
                        requestBody.getContent().put(ProduceConsumeUtils.getDefaultValue(body), requestBodyContent);
                    } else {
                        requestBody.getContent().put("*/*", requestBodyContent);
                    }
                    if (methodJavadoc != null) {
                        parameterDoc = methodJavadoc.getParamBlockTagByName(body.getJavadocFieldName());
                        if (parameterDoc.isPresent() && !(description = ((JavadocBlockTag)parameterDoc.get()).getContent().toText()).isEmpty()) {
                            requestBody.setDescription(((JavadocBlockTag)parameterDoc.get()).getContent().toText());
                        }
                        this.logger.debug((CharSequence)("Parameter documentation found for endpoint body " + body.getName() + " ? " + parameterDoc.isPresent()));
                    }
                }
                if (!(bodyParts = endpoint.getParameters().stream().filter(p -> ParameterLocation.BODY_PART == p.getLocation()).collect(Collectors.toList())).isEmpty()) {
                    if (operation.getRequestBody() != null) {
                        this.logger.warn((CharSequence)("Cannot handle \"body\" + \"body parts\" : " + endpoint.getPath() + " - " + (Object)((Object)endpoint.getType())));
                    } else {
                        RequestBody requestBody = new RequestBody();
                        operation.setRequestBody(requestBody);
                        requestBodyContent = Content.fromMultipartFormData(bodyParts, methodJavadoc, tagLibrary);
                        requestBody.getContent().put("multipart/form-data", requestBodyContent);
                    }
                }
                Response response = new Response();
                response.setCode(endpoint.getResponseCode(), this.apiConfiguration.getDefaultSuccessfulOperationDescription());
                if (endpoint.getResponseObject() != null) {
                    Content responseContent = Content.fromDataObject(endpoint.getResponseObject(), tagLibrary);
                    if (endpoint.getResponseFormats() != null) {
                        for (String format : endpoint.getResponseFormats()) {
                            response.getContent().put(format, responseContent);
                        }
                    } else if (this.apiConfiguration.isDefaultProduceConsumeGuessing()) {
                        response.getContent().put(ProduceConsumeUtils.getDefaultValue(endpoint.getResponseObject()), responseContent);
                    } else {
                        response.getContent().put("*/*", responseContent);
                    }
                }
                if (methodJavadoc != null) {
                    String description2;
                    Optional<JavadocBlockTag> returnDoc = methodJavadoc.getReturnBlockTag();
                    if (returnDoc.isPresent() && !(description2 = returnDoc.get().getContent().toText()).isEmpty()) {
                        response.setDescription(returnDoc.get().getContent().toText());
                    }
                    this.logger.debug((CharSequence)("Return documentation found ? " + returnDoc.isPresent()));
                }
                operation.getResponses().put(response.getCode(), response);
                if (this.defaultErrors != null) {
                    this.defaultErrors.entrySet().forEach(entry -> operation.getResponses().put(entry.getKey(), entry.getValue()));
                }
                for (OperationResponse operationResponse : endpoint.getOperationAnnotationInfo().getResponses()) {
                    Response annotatedResponse = null;
                    Object additionalResponseObject = operation.getResponses().get(operationResponse.getCode());
                    annotatedResponse = additionalResponseObject != null && additionalResponseObject instanceof Response ? (Response)additionalResponseObject : new Response();
                    annotatedResponse.setCode(operationResponse.getCode(), this.apiConfiguration.getDefaultSuccessfulOperationDescription());
                    if (operationResponse.getDescription() != null) {
                        annotatedResponse.setDescription(operationResponse.getDescription());
                    }
                    if (operationResponse.getDataObject() != null) {
                        Content responseContent = Content.fromDataObject(operationResponse.getDataObject(), tagLibrary);
                        if (this.apiConfiguration.isDefaultProduceConsumeGuessing()) {
                            annotatedResponse.getContent().put(ProduceConsumeUtils.getDefaultValue(operationResponse.getDataObject()), responseContent);
                        } else {
                            annotatedResponse.getContent().put("*/*", responseContent);
                        }
                    }
                    operation.getResponses().put(annotatedResponse.getCode(), annotatedResponse);
                }
                this.mergeCommonOperations(tag, paths, operation, response);
            }
        }
        return paths;
    }

    private static boolean isFormData(List<ParameterObject> bodies) {
        return bodies.stream().allMatch(ParameterObject::isMultipartFile);
    }

    private void mergeCommonOperations(Tag tag, Map<String, Map<String, Operation>> paths, Operation operation, Response response) {
        Operation existingOperation = paths.get(operation.getPath()).get(operation.getName().toLowerCase());
        if (existingOperation == null) {
            paths.get(operation.getPath()).put(operation.getName().toLowerCase(), operation);
        } else {
            Object existingContent = existingOperation.getResponses().get(response.getCode());
            for (Map.Entry<String, Content> responseContent : response.getContent().entrySet()) {
                if (!(existingContent instanceof Response)) continue;
                Response existingResponse = (Response)existingContent;
                if (existingResponse.getContent().containsKey(responseContent.getKey())) {
                    this.logger.warn((CharSequence)("More than one operation with a common content type mapped on " + operation.getName() + " : " + operation.getPath() + " in tag " + tag.getName()));
                    if (!existingResponse.getContent().get(responseContent.getKey()).getSchemaList().stream().noneMatch(x -> this.writeValueAsString(x.getJsonObject()).equals(this.writeValueAsString(((Content)responseContent.getValue()).getSingleSchema())))) continue;
                    existingResponse.getContent().get(responseContent.getKey()).getSchemaList().add(responseContent.getValue().getSingleSchema());
                    continue;
                }
                existingResponse.getContent().put(responseContent.getKey(), responseContent.getValue());
            }
            Map existingParametersByNames = existingOperation.getParameters().stream().collect(Collectors.toMap(ParameterElement::getName, Function.identity()));
            for (ParameterElement parameter : operation.getParameters()) {
                ParameterElement existingParameter = (ParameterElement)existingParametersByNames.get(parameter.getName());
                if (existingParameter == null) {
                    existingOperation.getParameters().add(parameter);
                    continue;
                }
                if (existingParameter.getSchema().getType().getNode().toString().equals(parameter.getSchema().getType().getNode().toString())) continue;
                Logger.INSTANCE.getLogger().warn((CharSequence)("Parameters incoherences detected in path " + operation.getPath()));
            }
        }
    }

    private Map<String, Object> createSchemaSection(TagLibrary library) {
        Schema schema;
        HashSet<String> exploredSignatures;
        List ordered = library.getSchemaObjects().stream().sorted(Comparator.comparing(p -> p.getOpenApiResolvedType().isCompleteNode() ? p.getOpenApiResolvedType().getModelName() : p.getSchemaReferenceName())).collect(Collectors.toList());
        LinkedHashMap<String, Object> schemas = new LinkedHashMap<String, Object>();
        for (DataObject dataObject : ordered) {
            exploredSignatures = new HashSet<String>();
            schema = new Schema(dataObject, true, exploredSignatures, null, null, this.tagLibrary);
            schemas.put(dataObject.getOpenApiResolvedType().isCompleteNode() ? dataObject.getOpenApiResolvedType().getModelName() : dataObject.getSchemaReferenceName(), schema);
        }
        for (Map.Entry entry : AdditionnalSchemaLibrary.getMap().entrySet()) {
            exploredSignatures = new HashSet();
            schema = new Schema((DataObject)entry.getValue(), true, exploredSignatures, null, null, this.tagLibrary);
            schemas.put((String)entry.getKey(), schema);
        }
        return schemas;
    }

    private String writeValueAsString(Object object) {
        try {
            return object == null ? null : this.om.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new MojoRuntimeException("Cannot write schema as json string", e);
        }
    }
}

