/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.sarif4j;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.detekt.sarif4j.FinalState;
import io.github.detekt.sarif4j.Message;
import io.github.detekt.sarif4j.PropertyBag;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"edgeId", "message", "finalState", "stepOverEdgeCount", "properties"})
public class EdgeTraversal {
    @JsonProperty(value="edgeId")
    @JsonPropertyDescription(value="Identifies the edge being traversed.")
    private String edgeId;
    @JsonProperty(value="message")
    @JsonPropertyDescription(value="Encapsulates a message intended to be read by the end user.")
    private Message message;
    @JsonProperty(value="finalState")
    @JsonPropertyDescription(value="The values of relevant expressions after the edge has been traversed.")
    private FinalState finalState;
    @JsonProperty(value="stepOverEdgeCount")
    @JsonPropertyDescription(value="The number of edge traversals necessary to return from a nested graph.")
    private Integer stepOverEdgeCount;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="edgeId")
    public String getEdgeId() {
        return this.edgeId;
    }

    @JsonProperty(value="edgeId")
    public void setEdgeId(String edgeId) {
        this.edgeId = edgeId;
    }

    public EdgeTraversal withEdgeId(String edgeId) {
        this.edgeId = edgeId;
        return this;
    }

    @JsonProperty(value="message")
    public Message getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(Message message) {
        this.message = message;
    }

    public EdgeTraversal withMessage(Message message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="finalState")
    public FinalState getFinalState() {
        return this.finalState;
    }

    @JsonProperty(value="finalState")
    public void setFinalState(FinalState finalState) {
        this.finalState = finalState;
    }

    public EdgeTraversal withFinalState(FinalState finalState) {
        this.finalState = finalState;
        return this;
    }

    @JsonProperty(value="stepOverEdgeCount")
    public Integer getStepOverEdgeCount() {
        return this.stepOverEdgeCount;
    }

    @JsonProperty(value="stepOverEdgeCount")
    public void setStepOverEdgeCount(Integer stepOverEdgeCount) {
        this.stepOverEdgeCount = stepOverEdgeCount;
    }

    public EdgeTraversal withStepOverEdgeCount(Integer stepOverEdgeCount) {
        this.stepOverEdgeCount = stepOverEdgeCount;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public EdgeTraversal withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EdgeTraversal.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("edgeId");
        sb.append('=');
        sb.append(this.edgeId == null ? "<null>" : this.edgeId);
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(this.message == null ? "<null>" : this.message);
        sb.append(',');
        sb.append("finalState");
        sb.append('=');
        sb.append(this.finalState == null ? "<null>" : this.finalState);
        sb.append(',');
        sb.append("stepOverEdgeCount");
        sb.append('=');
        sb.append(this.stepOverEdgeCount == null ? "<null>" : this.stepOverEdgeCount);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.edgeId == null ? 0 : this.edgeId.hashCode());
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + (this.stepOverEdgeCount == null ? 0 : this.stepOverEdgeCount.hashCode());
        result = result * 31 + (this.finalState == null ? 0 : this.finalState.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EdgeTraversal)) {
            return false;
        }
        EdgeTraversal rhs = (EdgeTraversal)other;
        return (this.edgeId == rhs.edgeId || this.edgeId != null && this.edgeId.equals(rhs.edgeId)) && (this.message == rhs.message || this.message != null && this.message.equals(rhs.message)) && (this.stepOverEdgeCount == rhs.stepOverEdgeCount || this.stepOverEdgeCount != null && this.stepOverEdgeCount.equals(rhs.stepOverEdgeCount)) && (this.finalState == rhs.finalState || this.finalState != null && this.finalState.equals(rhs.finalState)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }
}

