/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.sarif4j;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.github.detekt.sarif4j.Edge;
import io.github.detekt.sarif4j.Message;
import io.github.detekt.sarif4j.Node;
import io.github.detekt.sarif4j.PropertyBag;
import java.util.LinkedHashSet;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"description", "nodes", "edges", "properties"})
public class Graph {
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Encapsulates a message intended to be read by the end user.")
    private Message description;
    @JsonProperty(value="nodes")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of node objects representing the nodes of the graph.")
    private Set<Node> nodes = null;
    @JsonProperty(value="edges")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of edge objects representing the edges of the graph.")
    private Set<Edge> edges = null;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="description")
    public Message getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(Message description) {
        this.description = description;
    }

    public Graph withDescription(Message description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="nodes")
    public Set<Node> getNodes() {
        return this.nodes;
    }

    @JsonProperty(value="nodes")
    public void setNodes(Set<Node> nodes) {
        this.nodes = nodes;
    }

    public Graph withNodes(Set<Node> nodes) {
        this.nodes = nodes;
        return this;
    }

    @JsonProperty(value="edges")
    public Set<Edge> getEdges() {
        return this.edges;
    }

    @JsonProperty(value="edges")
    public void setEdges(Set<Edge> edges) {
        this.edges = edges;
    }

    public Graph withEdges(Set<Edge> edges) {
        this.edges = edges;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public Graph withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Graph.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("nodes");
        sb.append('=');
        sb.append(this.nodes == null ? "<null>" : this.nodes);
        sb.append(',');
        sb.append("edges");
        sb.append('=');
        sb.append(this.edges == null ? "<null>" : this.edges);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.edges == null ? 0 : this.edges.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.nodes == null ? 0 : this.nodes.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Graph)) {
            return false;
        }
        Graph rhs = (Graph)other;
        return (this.edges == rhs.edges || this.edges != null && this.edges.equals(rhs.edges)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.nodes == rhs.nodes || this.nodes != null && this.nodes.equals(rhs.nodes)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }
}

