/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.sarif4j;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.github.detekt.sarif4j.ArtifactLocation;
import io.github.detekt.sarif4j.Content;
import io.github.detekt.sarif4j.GlobalMessageStrings;
import io.github.detekt.sarif4j.MultiformatMessageString;
import io.github.detekt.sarif4j.PropertyBag;
import io.github.detekt.sarif4j.ReportingDescriptor;
import io.github.detekt.sarif4j.ToolComponentReference;
import io.github.detekt.sarif4j.TranslationMetadata;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"guid", "name", "organization", "product", "productSuite", "shortDescription", "fullDescription", "fullName", "version", "semanticVersion", "dottedQuadFileVersion", "releaseDateUtc", "downloadUri", "informationUri", "globalMessageStrings", "notifications", "rules", "taxa", "locations", "language", "contents", "isComprehensive", "localizedDataSemanticVersion", "minimumRequiredLocalizedDataSemanticVersion", "associatedComponent", "translationMetadata", "supportedTaxonomies", "properties"})
public class ToolComponent {
    @JsonProperty(value="guid")
    @JsonPropertyDescription(value="A unique identifer for the tool component in the form of a GUID.")
    private String guid;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name of the tool component.")
    private String name;
    @JsonProperty(value="organization")
    @JsonPropertyDescription(value="The organization or company that produced the tool component.")
    private String organization;
    @JsonProperty(value="product")
    @JsonPropertyDescription(value="A product suite to which the tool component belongs.")
    private String product;
    @JsonProperty(value="productSuite")
    @JsonPropertyDescription(value="A localizable string containing the name of the suite of products to which the tool component belongs.")
    private String productSuite;
    @JsonProperty(value="shortDescription")
    @JsonPropertyDescription(value="A message string or message format string rendered in multiple formats.")
    private MultiformatMessageString shortDescription;
    @JsonProperty(value="fullDescription")
    @JsonPropertyDescription(value="A message string or message format string rendered in multiple formats.")
    private MultiformatMessageString fullDescription;
    @JsonProperty(value="fullName")
    @JsonPropertyDescription(value="The name of the tool component along with its version and any other useful identifying information, such as its locale.")
    private String fullName;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="The tool component version, in whatever format the component natively provides.")
    private String version;
    @JsonProperty(value="semanticVersion")
    @JsonPropertyDescription(value="The tool component version in the format specified by Semantic Versioning 2.0.")
    private String semanticVersion;
    @JsonProperty(value="dottedQuadFileVersion")
    @JsonPropertyDescription(value="The binary version of the tool component's primary executable file expressed as four non-negative integers separated by a period (for operating systems that express file versions in this way).")
    private String dottedQuadFileVersion;
    @JsonProperty(value="releaseDateUtc")
    @JsonPropertyDescription(value="A string specifying the UTC date (and optionally, the time) of the component's release.")
    private String releaseDateUtc;
    @JsonProperty(value="downloadUri")
    @JsonPropertyDescription(value="The absolute URI from which the tool component can be downloaded.")
    private URI downloadUri;
    @JsonProperty(value="informationUri")
    @JsonPropertyDescription(value="The absolute URI at which information about this version of the tool component can be found.")
    private URI informationUri;
    @JsonProperty(value="globalMessageStrings")
    @JsonPropertyDescription(value="A dictionary, each of whose keys is a resource identifier and each of whose values is a multiformatMessageString object, which holds message strings in plain text and (optionally) Markdown format. The strings can include placeholders, which can be used to construct a message in combination with an arbitrary number of additional string arguments.")
    private GlobalMessageStrings globalMessageStrings;
    @JsonProperty(value="notifications")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of reportingDescriptor objects relevant to the notifications related to the configuration and runtime execution of the tool component.")
    private Set<ReportingDescriptor> notifications = null;
    @JsonProperty(value="rules")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of reportingDescriptor objects relevant to the analysis performed by the tool component.")
    private Set<ReportingDescriptor> rules = null;
    @JsonProperty(value="taxa")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of reportingDescriptor objects relevant to the definitions of both standalone and tool-defined taxonomies.")
    private Set<ReportingDescriptor> taxa = null;
    @JsonProperty(value="locations")
    @JsonPropertyDescription(value="An array of the artifactLocation objects associated with the tool component.")
    private List<ArtifactLocation> locations = null;
    @JsonProperty(value="language")
    @JsonPropertyDescription(value="The language of the messages emitted into the log file during this run (expressed as an ISO 639-1 two-letter lowercase language code) and an optional region (expressed as an ISO 3166-1 two-letter uppercase subculture code associated with a country or region). The casing is recommended but not required (in order for this data to conform to RFC5646).")
    private String language = "en-US";
    @JsonProperty(value="contents")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="The kinds of data contained in this object.")
    private Set<Content> contents = new LinkedHashSet<Content>(Arrays.asList(Content.fromValue("localizedData"), Content.fromValue("nonLocalizedData")));
    @JsonProperty(value="isComprehensive")
    @JsonPropertyDescription(value="Specifies whether this object contains a complete definition of the localizable and/or non-localizable data for this component, as opposed to including only data that is relevant to the results persisted to this log file.")
    private Boolean isComprehensive = false;
    @JsonProperty(value="localizedDataSemanticVersion")
    @JsonPropertyDescription(value="The semantic version of the localized strings defined in this component; maintained by components that provide translations.")
    private String localizedDataSemanticVersion;
    @JsonProperty(value="minimumRequiredLocalizedDataSemanticVersion")
    @JsonPropertyDescription(value="The minimum value of localizedDataSemanticVersion required in translations consumed by this component; used by components that consume translations.")
    private String minimumRequiredLocalizedDataSemanticVersion;
    @JsonProperty(value="associatedComponent")
    @JsonPropertyDescription(value="Identifies a particular toolComponent object, either the driver or an extension.")
    private ToolComponentReference associatedComponent;
    @JsonProperty(value="translationMetadata")
    @JsonPropertyDescription(value="Provides additional metadata related to translation.")
    private TranslationMetadata translationMetadata;
    @JsonProperty(value="supportedTaxonomies")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of toolComponentReference objects to declare the taxonomies supported by the tool component.")
    private Set<ToolComponentReference> supportedTaxonomies = null;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="guid")
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public ToolComponent withGuid(String guid) {
        this.guid = guid;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public ToolComponent withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="organization")
    public String getOrganization() {
        return this.organization;
    }

    @JsonProperty(value="organization")
    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public ToolComponent withOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    @JsonProperty(value="product")
    public String getProduct() {
        return this.product;
    }

    @JsonProperty(value="product")
    public void setProduct(String product) {
        this.product = product;
    }

    public ToolComponent withProduct(String product) {
        this.product = product;
        return this;
    }

    @JsonProperty(value="productSuite")
    public String getProductSuite() {
        return this.productSuite;
    }

    @JsonProperty(value="productSuite")
    public void setProductSuite(String productSuite) {
        this.productSuite = productSuite;
    }

    public ToolComponent withProductSuite(String productSuite) {
        this.productSuite = productSuite;
        return this;
    }

    @JsonProperty(value="shortDescription")
    public MultiformatMessageString getShortDescription() {
        return this.shortDescription;
    }

    @JsonProperty(value="shortDescription")
    public void setShortDescription(MultiformatMessageString shortDescription) {
        this.shortDescription = shortDescription;
    }

    public ToolComponent withShortDescription(MultiformatMessageString shortDescription) {
        this.shortDescription = shortDescription;
        return this;
    }

    @JsonProperty(value="fullDescription")
    public MultiformatMessageString getFullDescription() {
        return this.fullDescription;
    }

    @JsonProperty(value="fullDescription")
    public void setFullDescription(MultiformatMessageString fullDescription) {
        this.fullDescription = fullDescription;
    }

    public ToolComponent withFullDescription(MultiformatMessageString fullDescription) {
        this.fullDescription = fullDescription;
        return this;
    }

    @JsonProperty(value="fullName")
    public String getFullName() {
        return this.fullName;
    }

    @JsonProperty(value="fullName")
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public ToolComponent withFullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    public ToolComponent withVersion(String version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="semanticVersion")
    public String getSemanticVersion() {
        return this.semanticVersion;
    }

    @JsonProperty(value="semanticVersion")
    public void setSemanticVersion(String semanticVersion) {
        this.semanticVersion = semanticVersion;
    }

    public ToolComponent withSemanticVersion(String semanticVersion) {
        this.semanticVersion = semanticVersion;
        return this;
    }

    @JsonProperty(value="dottedQuadFileVersion")
    public String getDottedQuadFileVersion() {
        return this.dottedQuadFileVersion;
    }

    @JsonProperty(value="dottedQuadFileVersion")
    public void setDottedQuadFileVersion(String dottedQuadFileVersion) {
        this.dottedQuadFileVersion = dottedQuadFileVersion;
    }

    public ToolComponent withDottedQuadFileVersion(String dottedQuadFileVersion) {
        this.dottedQuadFileVersion = dottedQuadFileVersion;
        return this;
    }

    @JsonProperty(value="releaseDateUtc")
    public String getReleaseDateUtc() {
        return this.releaseDateUtc;
    }

    @JsonProperty(value="releaseDateUtc")
    public void setReleaseDateUtc(String releaseDateUtc) {
        this.releaseDateUtc = releaseDateUtc;
    }

    public ToolComponent withReleaseDateUtc(String releaseDateUtc) {
        this.releaseDateUtc = releaseDateUtc;
        return this;
    }

    @JsonProperty(value="downloadUri")
    public URI getDownloadUri() {
        return this.downloadUri;
    }

    @JsonProperty(value="downloadUri")
    public void setDownloadUri(URI downloadUri) {
        this.downloadUri = downloadUri;
    }

    public ToolComponent withDownloadUri(URI downloadUri) {
        this.downloadUri = downloadUri;
        return this;
    }

    @JsonProperty(value="informationUri")
    public URI getInformationUri() {
        return this.informationUri;
    }

    @JsonProperty(value="informationUri")
    public void setInformationUri(URI informationUri) {
        this.informationUri = informationUri;
    }

    public ToolComponent withInformationUri(URI informationUri) {
        this.informationUri = informationUri;
        return this;
    }

    @JsonProperty(value="globalMessageStrings")
    public GlobalMessageStrings getGlobalMessageStrings() {
        return this.globalMessageStrings;
    }

    @JsonProperty(value="globalMessageStrings")
    public void setGlobalMessageStrings(GlobalMessageStrings globalMessageStrings) {
        this.globalMessageStrings = globalMessageStrings;
    }

    public ToolComponent withGlobalMessageStrings(GlobalMessageStrings globalMessageStrings) {
        this.globalMessageStrings = globalMessageStrings;
        return this;
    }

    @JsonProperty(value="notifications")
    public Set<ReportingDescriptor> getNotifications() {
        return this.notifications;
    }

    @JsonProperty(value="notifications")
    public void setNotifications(Set<ReportingDescriptor> notifications) {
        this.notifications = notifications;
    }

    public ToolComponent withNotifications(Set<ReportingDescriptor> notifications) {
        this.notifications = notifications;
        return this;
    }

    @JsonProperty(value="rules")
    public Set<ReportingDescriptor> getRules() {
        return this.rules;
    }

    @JsonProperty(value="rules")
    public void setRules(Set<ReportingDescriptor> rules) {
        this.rules = rules;
    }

    public ToolComponent withRules(Set<ReportingDescriptor> rules) {
        this.rules = rules;
        return this;
    }

    @JsonProperty(value="taxa")
    public Set<ReportingDescriptor> getTaxa() {
        return this.taxa;
    }

    @JsonProperty(value="taxa")
    public void setTaxa(Set<ReportingDescriptor> taxa) {
        this.taxa = taxa;
    }

    public ToolComponent withTaxa(Set<ReportingDescriptor> taxa) {
        this.taxa = taxa;
        return this;
    }

    @JsonProperty(value="locations")
    public List<ArtifactLocation> getLocations() {
        return this.locations;
    }

    @JsonProperty(value="locations")
    public void setLocations(List<ArtifactLocation> locations) {
        this.locations = locations;
    }

    public ToolComponent withLocations(List<ArtifactLocation> locations) {
        this.locations = locations;
        return this;
    }

    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    public ToolComponent withLanguage(String language) {
        this.language = language;
        return this;
    }

    @JsonProperty(value="contents")
    public Set<Content> getContents() {
        return this.contents;
    }

    @JsonProperty(value="contents")
    public void setContents(Set<Content> contents) {
        this.contents = contents;
    }

    public ToolComponent withContents(Set<Content> contents) {
        this.contents = contents;
        return this;
    }

    @JsonProperty(value="isComprehensive")
    public Boolean getIsComprehensive() {
        return this.isComprehensive;
    }

    @JsonProperty(value="isComprehensive")
    public void setIsComprehensive(Boolean isComprehensive) {
        this.isComprehensive = isComprehensive;
    }

    public ToolComponent withIsComprehensive(Boolean isComprehensive) {
        this.isComprehensive = isComprehensive;
        return this;
    }

    @JsonProperty(value="localizedDataSemanticVersion")
    public String getLocalizedDataSemanticVersion() {
        return this.localizedDataSemanticVersion;
    }

    @JsonProperty(value="localizedDataSemanticVersion")
    public void setLocalizedDataSemanticVersion(String localizedDataSemanticVersion) {
        this.localizedDataSemanticVersion = localizedDataSemanticVersion;
    }

    public ToolComponent withLocalizedDataSemanticVersion(String localizedDataSemanticVersion) {
        this.localizedDataSemanticVersion = localizedDataSemanticVersion;
        return this;
    }

    @JsonProperty(value="minimumRequiredLocalizedDataSemanticVersion")
    public String getMinimumRequiredLocalizedDataSemanticVersion() {
        return this.minimumRequiredLocalizedDataSemanticVersion;
    }

    @JsonProperty(value="minimumRequiredLocalizedDataSemanticVersion")
    public void setMinimumRequiredLocalizedDataSemanticVersion(String minimumRequiredLocalizedDataSemanticVersion) {
        this.minimumRequiredLocalizedDataSemanticVersion = minimumRequiredLocalizedDataSemanticVersion;
    }

    public ToolComponent withMinimumRequiredLocalizedDataSemanticVersion(String minimumRequiredLocalizedDataSemanticVersion) {
        this.minimumRequiredLocalizedDataSemanticVersion = minimumRequiredLocalizedDataSemanticVersion;
        return this;
    }

    @JsonProperty(value="associatedComponent")
    public ToolComponentReference getAssociatedComponent() {
        return this.associatedComponent;
    }

    @JsonProperty(value="associatedComponent")
    public void setAssociatedComponent(ToolComponentReference associatedComponent) {
        this.associatedComponent = associatedComponent;
    }

    public ToolComponent withAssociatedComponent(ToolComponentReference associatedComponent) {
        this.associatedComponent = associatedComponent;
        return this;
    }

    @JsonProperty(value="translationMetadata")
    public TranslationMetadata getTranslationMetadata() {
        return this.translationMetadata;
    }

    @JsonProperty(value="translationMetadata")
    public void setTranslationMetadata(TranslationMetadata translationMetadata) {
        this.translationMetadata = translationMetadata;
    }

    public ToolComponent withTranslationMetadata(TranslationMetadata translationMetadata) {
        this.translationMetadata = translationMetadata;
        return this;
    }

    @JsonProperty(value="supportedTaxonomies")
    public Set<ToolComponentReference> getSupportedTaxonomies() {
        return this.supportedTaxonomies;
    }

    @JsonProperty(value="supportedTaxonomies")
    public void setSupportedTaxonomies(Set<ToolComponentReference> supportedTaxonomies) {
        this.supportedTaxonomies = supportedTaxonomies;
    }

    public ToolComponent withSupportedTaxonomies(Set<ToolComponentReference> supportedTaxonomies) {
        this.supportedTaxonomies = supportedTaxonomies;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public ToolComponent withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ToolComponent.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("guid");
        sb.append('=');
        sb.append(this.guid == null ? "<null>" : this.guid);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("organization");
        sb.append('=');
        sb.append(this.organization == null ? "<null>" : this.organization);
        sb.append(',');
        sb.append("product");
        sb.append('=');
        sb.append(this.product == null ? "<null>" : this.product);
        sb.append(',');
        sb.append("productSuite");
        sb.append('=');
        sb.append(this.productSuite == null ? "<null>" : this.productSuite);
        sb.append(',');
        sb.append("shortDescription");
        sb.append('=');
        sb.append(this.shortDescription == null ? "<null>" : this.shortDescription);
        sb.append(',');
        sb.append("fullDescription");
        sb.append('=');
        sb.append(this.fullDescription == null ? "<null>" : this.fullDescription);
        sb.append(',');
        sb.append("fullName");
        sb.append('=');
        sb.append(this.fullName == null ? "<null>" : this.fullName);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("semanticVersion");
        sb.append('=');
        sb.append(this.semanticVersion == null ? "<null>" : this.semanticVersion);
        sb.append(',');
        sb.append("dottedQuadFileVersion");
        sb.append('=');
        sb.append(this.dottedQuadFileVersion == null ? "<null>" : this.dottedQuadFileVersion);
        sb.append(',');
        sb.append("releaseDateUtc");
        sb.append('=');
        sb.append(this.releaseDateUtc == null ? "<null>" : this.releaseDateUtc);
        sb.append(',');
        sb.append("downloadUri");
        sb.append('=');
        sb.append(this.downloadUri == null ? "<null>" : this.downloadUri);
        sb.append(',');
        sb.append("informationUri");
        sb.append('=');
        sb.append(this.informationUri == null ? "<null>" : this.informationUri);
        sb.append(',');
        sb.append("globalMessageStrings");
        sb.append('=');
        sb.append(this.globalMessageStrings == null ? "<null>" : this.globalMessageStrings);
        sb.append(',');
        sb.append("notifications");
        sb.append('=');
        sb.append(this.notifications == null ? "<null>" : this.notifications);
        sb.append(',');
        sb.append("rules");
        sb.append('=');
        sb.append(this.rules == null ? "<null>" : this.rules);
        sb.append(',');
        sb.append("taxa");
        sb.append('=');
        sb.append(this.taxa == null ? "<null>" : this.taxa);
        sb.append(',');
        sb.append("locations");
        sb.append('=');
        sb.append(this.locations == null ? "<null>" : this.locations);
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(this.language == null ? "<null>" : this.language);
        sb.append(',');
        sb.append("contents");
        sb.append('=');
        sb.append(this.contents == null ? "<null>" : this.contents);
        sb.append(',');
        sb.append("isComprehensive");
        sb.append('=');
        sb.append(this.isComprehensive == null ? "<null>" : this.isComprehensive);
        sb.append(',');
        sb.append("localizedDataSemanticVersion");
        sb.append('=');
        sb.append(this.localizedDataSemanticVersion == null ? "<null>" : this.localizedDataSemanticVersion);
        sb.append(',');
        sb.append("minimumRequiredLocalizedDataSemanticVersion");
        sb.append('=');
        sb.append(this.minimumRequiredLocalizedDataSemanticVersion == null ? "<null>" : this.minimumRequiredLocalizedDataSemanticVersion);
        sb.append(',');
        sb.append("associatedComponent");
        sb.append('=');
        sb.append(this.associatedComponent == null ? "<null>" : this.associatedComponent);
        sb.append(',');
        sb.append("translationMetadata");
        sb.append('=');
        sb.append(this.translationMetadata == null ? "<null>" : this.translationMetadata);
        sb.append(',');
        sb.append("supportedTaxonomies");
        sb.append('=');
        sb.append(this.supportedTaxonomies == null ? "<null>" : this.supportedTaxonomies);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.releaseDateUtc == null ? 0 : this.releaseDateUtc.hashCode());
        result = result * 31 + (this.rules == null ? 0 : this.rules.hashCode());
        result = result * 31 + (this.language == null ? 0 : this.language.hashCode());
        result = result * 31 + (this.downloadUri == null ? 0 : this.downloadUri.hashCode());
        result = result * 31 + (this.supportedTaxonomies == null ? 0 : this.supportedTaxonomies.hashCode());
        result = result * 31 + (this.fullDescription == null ? 0 : this.fullDescription.hashCode());
        result = result * 31 + (this.informationUri == null ? 0 : this.informationUri.hashCode());
        result = result * 31 + (this.associatedComponent == null ? 0 : this.associatedComponent.hashCode());
        result = result * 31 + (this.translationMetadata == null ? 0 : this.translationMetadata.hashCode());
        result = result * 31 + (this.productSuite == null ? 0 : this.productSuite.hashCode());
        result = result * 31 + (this.taxa == null ? 0 : this.taxa.hashCode());
        result = result * 31 + (this.product == null ? 0 : this.product.hashCode());
        result = result * 31 + (this.isComprehensive == null ? 0 : this.isComprehensive.hashCode());
        result = result * 31 + (this.minimumRequiredLocalizedDataSemanticVersion == null ? 0 : this.minimumRequiredLocalizedDataSemanticVersion.hashCode());
        result = result * 31 + (this.fullName == null ? 0 : this.fullName.hashCode());
        result = result * 31 + (this.shortDescription == null ? 0 : this.shortDescription.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.globalMessageStrings == null ? 0 : this.globalMessageStrings.hashCode());
        result = result * 31 + (this.localizedDataSemanticVersion == null ? 0 : this.localizedDataSemanticVersion.hashCode());
        result = result * 31 + (this.dottedQuadFileVersion == null ? 0 : this.dottedQuadFileVersion.hashCode());
        result = result * 31 + (this.contents == null ? 0 : this.contents.hashCode());
        result = result * 31 + (this.organization == null ? 0 : this.organization.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.semanticVersion == null ? 0 : this.semanticVersion.hashCode());
        result = result * 31 + (this.guid == null ? 0 : this.guid.hashCode());
        result = result * 31 + (this.locations == null ? 0 : this.locations.hashCode());
        result = result * 31 + (this.notifications == null ? 0 : this.notifications.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ToolComponent)) {
            return false;
        }
        ToolComponent rhs = (ToolComponent)other;
        return (this.releaseDateUtc == rhs.releaseDateUtc || this.releaseDateUtc != null && this.releaseDateUtc.equals(rhs.releaseDateUtc)) && (this.rules == rhs.rules || this.rules != null && this.rules.equals(rhs.rules)) && (this.language == rhs.language || this.language != null && this.language.equals(rhs.language)) && (this.downloadUri == rhs.downloadUri || this.downloadUri != null && this.downloadUri.equals(rhs.downloadUri)) && (this.supportedTaxonomies == rhs.supportedTaxonomies || this.supportedTaxonomies != null && this.supportedTaxonomies.equals(rhs.supportedTaxonomies)) && (this.fullDescription == rhs.fullDescription || this.fullDescription != null && this.fullDescription.equals(rhs.fullDescription)) && (this.informationUri == rhs.informationUri || this.informationUri != null && this.informationUri.equals(rhs.informationUri)) && (this.associatedComponent == rhs.associatedComponent || this.associatedComponent != null && this.associatedComponent.equals(rhs.associatedComponent)) && (this.translationMetadata == rhs.translationMetadata || this.translationMetadata != null && this.translationMetadata.equals(rhs.translationMetadata)) && (this.productSuite == rhs.productSuite || this.productSuite != null && this.productSuite.equals(rhs.productSuite)) && (this.taxa == rhs.taxa || this.taxa != null && this.taxa.equals(rhs.taxa)) && (this.product == rhs.product || this.product != null && this.product.equals(rhs.product)) && (this.isComprehensive == rhs.isComprehensive || this.isComprehensive != null && this.isComprehensive.equals(rhs.isComprehensive)) && (this.minimumRequiredLocalizedDataSemanticVersion == rhs.minimumRequiredLocalizedDataSemanticVersion || this.minimumRequiredLocalizedDataSemanticVersion != null && this.minimumRequiredLocalizedDataSemanticVersion.equals(rhs.minimumRequiredLocalizedDataSemanticVersion)) && (this.fullName == rhs.fullName || this.fullName != null && this.fullName.equals(rhs.fullName)) && (this.shortDescription == rhs.shortDescription || this.shortDescription != null && this.shortDescription.equals(rhs.shortDescription)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.globalMessageStrings == rhs.globalMessageStrings || this.globalMessageStrings != null && this.globalMessageStrings.equals(rhs.globalMessageStrings)) && (this.localizedDataSemanticVersion == rhs.localizedDataSemanticVersion || this.localizedDataSemanticVersion != null && this.localizedDataSemanticVersion.equals(rhs.localizedDataSemanticVersion)) && (this.dottedQuadFileVersion == rhs.dottedQuadFileVersion || this.dottedQuadFileVersion != null && this.dottedQuadFileVersion.equals(rhs.dottedQuadFileVersion)) && (this.contents == rhs.contents || this.contents != null && this.contents.equals(rhs.contents)) && (this.organization == rhs.organization || this.organization != null && this.organization.equals(rhs.organization)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.semanticVersion == rhs.semanticVersion || this.semanticVersion != null && this.semanticVersion.equals(rhs.semanticVersion)) && (this.guid == rhs.guid || this.guid != null && this.guid.equals(rhs.guid)) && (this.locations == rhs.locations || this.locations != null && this.locations.equals(rhs.locations)) && (this.notifications == rhs.notifications || this.notifications != null && this.notifications.equals(rhs.notifications)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }
}

