/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.sarif4j;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.github.detekt.sarif4j.Message;
import io.github.detekt.sarif4j.PropertyBag;
import io.github.detekt.sarif4j.ReportingDescriptorReference;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"target", "kinds", "description", "properties"})
public class ReportingDescriptorRelationship {
    @JsonProperty(value="target")
    @JsonPropertyDescription(value="Information about how to locate a relevant reporting descriptor.")
    private ReportingDescriptorReference target;
    @JsonProperty(value="kinds")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="A set of distinct strings that categorize the relationship. Well-known kinds include 'canPrecede', 'canFollow', 'willPrecede', 'willFollow', 'superset', 'subset', 'equal', 'disjoint', 'relevant', and 'incomparable'.")
    private Set<String> kinds = new LinkedHashSet<String>(Arrays.asList("relevant"));
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Encapsulates a message intended to be read by the end user.")
    private Message description;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="target")
    public ReportingDescriptorReference getTarget() {
        return this.target;
    }

    @JsonProperty(value="target")
    public void setTarget(ReportingDescriptorReference target) {
        this.target = target;
    }

    public ReportingDescriptorRelationship withTarget(ReportingDescriptorReference target) {
        this.target = target;
        return this;
    }

    @JsonProperty(value="kinds")
    public Set<String> getKinds() {
        return this.kinds;
    }

    @JsonProperty(value="kinds")
    public void setKinds(Set<String> kinds) {
        this.kinds = kinds;
    }

    public ReportingDescriptorRelationship withKinds(Set<String> kinds) {
        this.kinds = kinds;
        return this;
    }

    @JsonProperty(value="description")
    public Message getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(Message description) {
        this.description = description;
    }

    public ReportingDescriptorRelationship withDescription(Message description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public ReportingDescriptorRelationship withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ReportingDescriptorRelationship.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("target");
        sb.append('=');
        sb.append(this.target == null ? "<null>" : this.target);
        sb.append(',');
        sb.append("kinds");
        sb.append('=');
        sb.append(this.kinds == null ? "<null>" : this.kinds);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.kinds == null ? 0 : this.kinds.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        result = result * 31 + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ReportingDescriptorRelationship)) {
            return false;
        }
        ReportingDescriptorRelationship rhs = (ReportingDescriptorRelationship)other;
        return (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.kinds == rhs.kinds || this.kinds != null && this.kinds.equals(rhs.kinds)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties)) && (this.target == rhs.target || this.target != null && this.target.equals(rhs.target));
    }
}

