/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.ValueArgument;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\f\u0010\f\u001a\u00020\r*\u00020\u0001H\u0002\u001a\u0014\u0010\u000e\u001a\u00020\r*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\f\u0010\u0012\u001a\u00020\n*\u00020\u0013H\u0002\u001a\f\u0010\u0014\u001a\u00020\n*\u00020\u0002H\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"firstLambdaArg", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getFirstLambdaArg", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "firstParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getFirstParameter", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;)Lorg/jetbrains/kotlin/psi/KtParameter;", "canBeReplacedWithCall", "", "lambdaExpr", "countReferences", "", "countVarRefs", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "varName", "", "hasOnlyOneStatement", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "isLetExpr", "detekt-rules-style"})
public final class UnnecessaryLetKt {
    private static final boolean canBeReplacedWithCall(KtLambdaExpression lambdaExpr) {
        boolean bl;
        block10: {
            KtBlockExpression lambdaBody;
            KtLambdaExpression ktLambdaExpression = lambdaExpr;
            KtParameter lambdaParameter = ktLambdaExpression != null ? UnnecessaryLetKt.getFirstParameter(ktLambdaExpression) : null;
            KtLambdaExpression ktLambdaExpression2 = lambdaExpr;
            KtBlockExpression ktBlockExpression = lambdaBody = ktLambdaExpression2 != null ? ktLambdaExpression2.getBodyExpression() : null;
            if (ktBlockExpression == null || !UnnecessaryLetKt.hasOnlyOneStatement(ktBlockExpression)) {
                return false;
            }
            PsiElement firstExpr = lambdaBody.getFirstChild();
            KtExpression exprReceiver = firstExpr instanceof KtDotQualifiedExpression ? ((KtDotQualifiedExpression)firstExpr).getReceiverExpression() : (firstExpr instanceof KtSafeQualifiedExpression ? ((KtSafeQualifiedExpression)firstExpr).getReceiverExpression() : null);
            if (exprReceiver == null) {
                bl = false;
            } else if (lambdaParameter == null) {
                bl = exprReceiver.textMatches((CharSequence)"it");
            } else {
                KtDestructuringDeclaration destructuringDeclaration = lambdaParameter.getDestructuringDeclaration();
                Object object = destructuringDeclaration;
                if (object != null && (object = object.getEntries()) != null) {
                    Iterable $this$any$iv = (Iterable)object;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KtDestructuringDeclarationEntry it = (KtDestructuringDeclarationEntry)element$iv;
                            boolean bl2 = false;
                            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = it;
                            Intrinsics.checkNotNullExpressionValue((Object)ktDestructuringDeclarationEntry, (String)"it");
                            if (!exprReceiver.textMatches((CharSequence)ktDestructuringDeclarationEntry.getNameAsSafeName().asString())) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                } else {
                    bl = exprReceiver.textMatches((CharSequence)lambdaParameter.getNameAsSafeName().asString());
                }
            }
        }
        return bl;
    }

    private static final boolean isLetExpr(KtCallExpression $this$isLetExpr) {
        KtExpression ktExpression = $this$isLetExpr.getCalleeExpression();
        return ktExpression != null && ktExpression.textMatches((CharSequence)"let");
    }

    private static final KtLambdaExpression getFirstLambdaArg(KtCallExpression $this$firstLambdaArg) {
        List list = $this$firstLambdaArg.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)list);
        return ktLambdaArgument != null ? ktLambdaArgument.getLambdaExpression() : null;
    }

    private static final KtParameter getFirstParameter(KtLambdaExpression $this$firstParameter) {
        List list = $this$firstParameter.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"valueParameters");
        return (KtParameter)CollectionsKt.firstOrNull((List)list);
    }

    private static final boolean hasOnlyOneStatement(KtBlockExpression $this$hasOnlyOneStatement) {
        return $this$hasOnlyOneStatement.getChildren().length == 1;
    }

    /*
     * WARNING - void declaration
     */
    private static final int countVarRefs(PsiElement $this$countVarRefs, String varName) {
        PsiElement[] psiElementArray = $this$countVarRefs.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"children");
        PsiElement[] $this$sumBy$iv = psiElementArray;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        PsiElement[] psiElementArray2 = $this$sumBy$iv;
        int n = psiElementArray2.length;
        for (int i = 0; i < n; ++i) {
            void it;
            PsiElement element$iv;
            PsiElement psiElement = element$iv = psiElementArray2[i];
            int n2 = sum$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            int n3 = UnnecessaryLetKt.countVarRefs((PsiElement)v1, varName) + (it.textMatches((CharSequence)varName) && !(it instanceof ValueArgument) ? 1 : 0);
            sum$iv = n2 + n3;
        }
        return sum$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final int countReferences(KtLambdaExpression $this$countReferences) {
        int n;
        KtDestructuringDeclaration destructuringDeclaration;
        KtBlockExpression ktBlockExpression = $this$countReferences.getBodyExpression();
        if (ktBlockExpression == null) {
            return 0;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"bodyExpression ?: return 0");
        KtBlockExpression bodyExpression = ktBlockExpression;
        KtParameter ktParameter = UnnecessaryLetKt.getFirstParameter($this$countReferences);
        Object object = destructuringDeclaration = ktParameter != null ? ktParameter.getDestructuringDeclaration() : null;
        if (destructuringDeclaration != null) {
            List list = destructuringDeclaration.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"destructuringDeclaration.entries");
            Iterable $this$sumBy$iv = list;
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv) {
                void it;
                KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = (KtDestructuringDeclarationEntry)element$iv;
                int n2 = sum$iv;
                boolean bl = false;
                PsiElement psiElement = (PsiElement)bodyExpression;
                void v5 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it");
                String string = v5.getNameAsSafeName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.nameAsSafeName.asString()");
                int n3 = UnnecessaryLetKt.countVarRefs(psiElement, string);
                sum$iv = n2 + n3;
            }
            n = sum$iv;
        } else {
            Object object2 = UnnecessaryLetKt.getFirstParameter($this$countReferences);
            if (object2 == null || (object2 = object2.getNameAsSafeName()) == null || (object2 = object2.asString()) == null) {
                object2 = "it";
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"firstParameter?.nameAsSa\u2026.asString() ?: IT_LITERAL");
            Object parameterName = object2;
            n = UnnecessaryLetKt.countVarRefs((PsiElement)bodyExpression, (String)parameterName);
        }
        return n;
    }

    public static final /* synthetic */ boolean access$isLetExpr(KtCallExpression $this$access_u24isLetExpr) {
        return UnnecessaryLetKt.isLetExpr($this$access_u24isLetExpr);
    }

    public static final /* synthetic */ KtLambdaExpression access$getFirstLambdaArg$p(KtCallExpression $this$access_u24firstLambdaArg_u24p) {
        return UnnecessaryLetKt.getFirstLambdaArg($this$access_u24firstLambdaArg_u24p);
    }

    public static final /* synthetic */ int access$countReferences(KtLambdaExpression $this$access_u24countReferences) {
        return UnnecessaryLetKt.countReferences($this$access_u24countReferences);
    }

    public static final /* synthetic */ boolean access$canBeReplacedWithCall(KtLambdaExpression lambdaExpr) {
        return UnnecessaryLetKt.canBeReplacedWithCall(lambdaExpr);
    }
}

