/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style.optional;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.optional.MandatoryBracesIfStatements;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\n*\u00020\u0010H\u0002J\f\u0010\u0012\u001a\u00020\n*\u00020\u0010H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/MandatoryBracesIfStatements;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "hasNewLine", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "visitIfExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "isNotBlockExpression", "isNotBlockOrIfExpression", "detekt-rules-style"})
public final class MandatoryBracesIfStatements
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitIfExpression(@NotNull KtIfExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.isNotBlockExpression(expression) && this.hasNewLine(expression.getRightParenthesis())) {
            Issue issue = this.getIssue();
            KtExpression ktExpression = expression.getThen();
            if (ktExpression == null) {
                ktExpression = (KtExpression)expression;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"expression.then ?: expression");
            this.report((Finding)new CodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)ktExpression), (int)0, (int)2, null), "Multi-line if statement was found that does not have braces. These should be added to improve readability.", null, null, 24, null));
        }
        if (this.isNotBlockOrIfExpression(expression) && this.hasNewLine(expression.getElseKeyword())) {
            Issue issue = this.getIssue();
            KtExpression ktExpression = expression.getElse();
            if (ktExpression == null) {
                ktExpression = (KtExpression)expression;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"expression.`else` ?: expression");
            this.report((Finding)new CodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)ktExpression), (int)0, (int)2, null), "Multi-line if statement was found that does not have braces. These should be added to improve readability.", null, null, 24, null));
        }
        super.visitIfExpression(expression);
    }

    private final boolean hasNewLine(PsiElement element) {
        PsiElement psiElement;
        PsiElement psiElement2 = element;
        if (psiElement2 != null && (psiElement2 = PsiUtilsKt.siblings((PsiElement)psiElement2, (boolean)true, (boolean)false)) != null && (psiElement2 = SequencesKt.takeWhile((Sequence)psiElement2, (Function1)hasNewLine.1.INSTANCE)) != null) {
            Object v1;
            block3: {
                PsiElement $this$firstOrNull$iv = psiElement2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!it.textContains('\n')) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            psiElement = v1;
        } else {
            psiElement = null;
        }
        return psiElement != null;
    }

    private final boolean isNotBlockExpression(KtIfExpression $this$isNotBlockExpression) {
        return !($this$isNotBlockExpression.getThen() instanceof KtBlockExpression);
    }

    private final boolean isNotBlockOrIfExpression(KtIfExpression $this$isNotBlockOrIfExpression) {
        return $this$isNotBlockOrIfExpression.getElse() != null && !($this$isNotBlockOrIfExpression.getElse() instanceof KtIfExpression) && !($this$isNotBlockOrIfExpression.getElse() instanceof KtBlockExpression);
    }

    public MandatoryBracesIfStatements(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("MandatoryBracesIfStatements", Severity.Style, "Multi-line if statement was found that does not have braces. These should be added to improve readability.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ MandatoryBracesIfStatements(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public MandatoryBracesIfStatements() {
        this(null, 1, null);
    }
}

