/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class ConcatPublisher<T>
implements Flow.Publisher<T>,
Multi<T> {
    private final Flow.Publisher<T> firstPublisher;
    private final Flow.Publisher<T> secondPublisher;

    private ConcatPublisher(Flow.Publisher<T> firstPublisher, Flow.Publisher<T> secondPublisher) {
        this.firstPublisher = firstPublisher;
        this.secondPublisher = secondPublisher;
    }

    public static <T> ConcatPublisher<T> create(Flow.Publisher<T> firstPublisher, Flow.Publisher<T> secondPublisher) {
        return new ConcatPublisher<T>(firstPublisher, secondPublisher);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        ConcatCancelingSubscription<T> parent = new ConcatCancelingSubscription<T>(subscriber, this.firstPublisher, this.secondPublisher);
        subscriber.onSubscribe(parent);
        parent.drain();
    }

    static final class ConcatCancelingSubscription<T>
    extends AtomicInteger
    implements Flow.Subscription {
        private static final long serialVersionUID = -1593224722447706944L;
        private final InnerSubscriber<T> inner1;
        private final InnerSubscriber<T> inner2;
        private final AtomicBoolean canceled;
        private Flow.Publisher<T> source1;
        private Flow.Publisher<T> source2;
        private int index;

        ConcatCancelingSubscription(Flow.Subscriber<? super T> subscriber, Flow.Publisher<T> source1, Flow.Publisher<T> source2) {
            this.inner1 = new InnerSubscriber<T>(subscriber, this);
            this.inner2 = new InnerSubscriber<T>(subscriber, this);
            this.canceled = new AtomicBoolean();
            this.source1 = source1;
            this.source2 = source2;
        }

        @Override
        public void request(long n) {
            SubscriptionHelper.deferredRequest(this.inner2, this.inner2.requested, n);
            SubscriptionHelper.deferredRequest(this.inner1, this.inner1.requested, n);
        }

        @Override
        public void cancel() {
            if (this.canceled.compareAndSet(false, true)) {
                SubscriptionHelper.cancel(this.inner1);
                SubscriptionHelper.cancel(this.inner2);
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            do {
                Flow.Publisher<T> source;
                if (this.index == 0) {
                    this.index = 1;
                    source = this.source1;
                    this.source1 = null;
                    source.subscribe(this.inner1);
                    continue;
                }
                if (this.index == 1) {
                    this.index = 2;
                    source = this.source2;
                    this.source2 = null;
                    if (this.inner1.produced != 0L) {
                        SubscriptionHelper.produced(this.inner2.requested, this.inner1.produced);
                    }
                    source.subscribe(this.inner2);
                    continue;
                }
                if (this.index != 2) continue;
                this.index = 3;
                if (this.canceled.get()) continue;
                this.inner1.downstream.onComplete();
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
        }

        static final class InnerSubscriber<T>
        extends AtomicReference<Flow.Subscription>
        implements Flow.Subscriber<T> {
            private static final long serialVersionUID = 3029954591185720794L;
            private final Flow.Subscriber<? super T> downstream;
            private final ConcatCancelingSubscription<T> parent;
            private final AtomicLong requested;
            private long produced;

            InnerSubscriber(Flow.Subscriber<? super T> downstream, ConcatCancelingSubscription<T> parent) {
                this.downstream = downstream;
                this.parent = parent;
                this.requested = new AtomicLong();
            }

            @Override
            public void onSubscribe(Flow.Subscription s) {
                SubscriptionHelper.deferredSetOnce(this, this.requested, s);
            }

            @Override
            public void onNext(T t) {
                if (this.get() != SubscriptionHelper.CANCELED) {
                    ++this.produced;
                    this.downstream.onNext(t);
                }
            }

            @Override
            public void onError(Throwable t) {
                if (this.get() != SubscriptionHelper.CANCELED) {
                    this.lazySet(SubscriptionHelper.CANCELED);
                    this.downstream.onError(t);
                    this.parent.cancel();
                }
            }

            @Override
            public void onComplete() {
                if (this.get() != SubscriptionHelper.CANCELED) {
                    this.lazySet(SubscriptionHelper.CANCELED);
                    this.parent.drain();
                }
            }

            private void writeObject(ObjectOutputStream stream) throws IOException {
                stream.defaultWriteObject();
            }

            private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
                stream.defaultReadObject();
            }
        }
    }
}

