/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;

class DeferredScalarSubscription<T>
extends AtomicInteger
implements Flow.Subscription {
    private final Flow.Subscriber<? super T> downstream;
    private T value;
    static final int REQUEST_ARRIVED = 1;
    static final int VALUE_ARRIVED = 2;
    static final int DONE = 3;

    DeferredScalarSubscription(Flow.Subscriber<? super T> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void cancel() {
        if (this.getAndSet(3) != 3) {
            this.value = null;
        }
    }

    @Override
    public final void request(long n) {
        T v;
        int state;
        if (n <= 0L) {
            if (this.getAndSet(3) != 3) {
                this.value = null;
                this.downstream.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden"));
            }
            return;
        }
        do {
            state = this.get();
            v = this.value;
        } while (!this.compareAndSet(state, state | 1));
        if (state == 2) {
            this.value = null;
            this.downstream.onNext(v);
            this.downstream.onComplete();
        }
    }

    public final void complete(T item) {
        this.value = item;
        int state = this.getAndUpdate(n -> n | 2);
        if (state == 1) {
            this.value = null;
            this.downstream.onNext(item);
            this.downstream.onComplete();
        } else if (state == 3) {
            this.value = null;
        }
    }

    protected final void subscribeSelf() {
        this.downstream.onSubscribe(this);
    }

    protected final Flow.Subscriber<? super T> downstream() {
        return this.downstream;
    }

    public final void complete() {
        int state = this.get();
        if ((state & 2) != 2 && this.compareAndSet(state, 3)) {
            this.downstream.onComplete();
        }
    }

    public final void error(Throwable throwable) {
        if (this.getAndSet(3) != 3) {
            this.value = null;
            this.downstream.onError(throwable);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

