/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;

final class SingleSubscription<T>
extends AtomicInteger
implements Flow.Subscription {
    private final T value;
    private final Flow.Subscriber<? super T> subscriber;
    static final int FRESH = 0;
    static final int REQUESTED = 1;
    static final int COMPLETED = 2;
    static final int CANCELED = 3;

    SingleSubscription(T value, Flow.Subscriber<? super T> subscriber) {
        super(0);
        this.value = value;
        this.subscriber = subscriber;
    }

    @Override
    public void request(long n) {
        if (n <= 0L) {
            this.cancel();
            this.subscriber.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden."));
        } else if (this.compareAndSet(0, 1)) {
            this.subscriber.onNext(this.value);
            if (this.compareAndSet(1, 2)) {
                this.subscriber.onComplete();
            }
        }
    }

    @Override
    public void cancel() {
        this.set(3);
    }
}

