/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.jwt;

import io.helidon.common.Errors;
import io.helidon.common.configurable.Resource;
import io.helidon.config.Config;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Grant;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.Principal;
import io.helidon.security.ProviderRequest;
import io.helidon.security.Role;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityResponse;
import io.helidon.security.Subject;
import io.helidon.security.SubjectType;
import io.helidon.security.jwt.Jwt;
import io.helidon.security.jwt.JwtException;
import io.helidon.security.jwt.JwtUtil;
import io.helidon.security.jwt.SignedJwt;
import io.helidon.security.jwt.jwk.Jwk;
import io.helidon.security.jwt.jwk.JwkKeys;
import io.helidon.security.providers.common.OutboundConfig;
import io.helidon.security.providers.common.OutboundTarget;
import io.helidon.security.providers.common.TokenCredential;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.OutboundSecurityProvider;
import io.helidon.security.spi.SynchronousProvider;
import io.helidon.security.util.TokenHandler;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.json.JsonValue;

public final class JwtProvider
extends SynchronousProvider
implements AuthenticationProvider,
OutboundSecurityProvider {
    private static final Logger LOGGER = Logger.getLogger(JwtProvider.class.getName());
    public static final String EP_PROPERTY_OUTBOUND_USER = "io.helidon.security.outbound.user";
    private final boolean optional;
    private final boolean authenticate;
    private final boolean propagate;
    private final boolean allowImpersonation;
    private final boolean verifySignature;
    private final SubjectType subjectType;
    private final TokenHandler atnTokenHandler;
    private final TokenHandler defaultTokenHandler;
    private final JwkKeys verifyKeys;
    private final String expectedAudience;
    private final JwkKeys signKeys;
    private final OutboundConfig outboundConfig;
    private final String issuer;
    private final Map<OutboundTarget, JwtOutboundTarget> targetToJwtConfig = new IdentityHashMap<OutboundTarget, JwtOutboundTarget>();
    private final Jwk defaultJwk;
    private final boolean useJwtGroups;

    private JwtProvider(Builder builder) {
        this.optional = builder.optional;
        this.authenticate = builder.authenticate;
        this.propagate = builder.propagate;
        this.allowImpersonation = builder.allowImpersonation;
        this.subjectType = builder.subjectType;
        this.atnTokenHandler = builder.atnTokenHandler;
        this.outboundConfig = builder.outboundConfig;
        this.verifyKeys = builder.verifyKeys;
        this.signKeys = builder.signKeys;
        this.issuer = builder.issuer;
        this.expectedAudience = builder.expectedAudience;
        this.verifySignature = builder.verifySignature;
        this.useJwtGroups = builder.useJwtGroups;
        this.defaultTokenHandler = null == this.atnTokenHandler ? TokenHandler.builder().tokenHeader("Authorization").tokenPrefix("bearer ").build() : this.atnTokenHandler;
        this.defaultJwk = builder.allowUnsigned ? Jwk.NONE_JWK : null;
        if (!this.verifySignature) {
            LOGGER.info("JWT Signature validation is disabled. Any JWT will be accepted.");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static JwtProvider create(Config config) {
        return JwtProvider.builder().config(config).build();
    }

    protected AuthenticationResponse syncAuthenticate(ProviderRequest providerRequest) {
        Optional maybeToken;
        if (!this.authenticate) {
            return AuthenticationResponse.abstain();
        }
        try {
            maybeToken = this.atnTokenHandler.extractToken(providerRequest.env().headers());
        }
        catch (Exception e) {
            if (this.optional) {
                return AuthenticationResponse.abstain();
            }
            return AuthenticationResponse.failed((String)"JWT header not available or in a wrong format", (Throwable)e);
        }
        return maybeToken.map(this::authenticateToken).orElseGet(() -> {
            if (this.optional) {
                return AuthenticationResponse.abstain();
            }
            return AuthenticationResponse.failed((String)"JWT header not available or in a wrong format");
        });
    }

    private AuthenticationResponse authenticateToken(String token) {
        SignedJwt signedJwt;
        try {
            signedJwt = SignedJwt.parseToken((String)token);
        }
        catch (Exception e) {
            return AuthenticationResponse.failed((String)"Invalid token", (Throwable)e);
        }
        if (this.verifySignature) {
            Errors errors = signedJwt.verifySignature(this.verifyKeys, this.defaultJwk);
            if (errors.isValid()) {
                Jwt jwt = signedJwt.getJwt();
                Errors validate = jwt.validate(null, this.expectedAudience);
                if (validate.isValid()) {
                    return AuthenticationResponse.success((Subject)this.buildSubject(jwt, signedJwt));
                }
                return AuthenticationResponse.failed((String)("Audience is invalid or missing: " + this.expectedAudience));
            }
            return AuthenticationResponse.failed((String)errors.toString());
        }
        return AuthenticationResponse.success((Subject)this.buildSubject(signedJwt.getJwt(), signedJwt));
    }

    Subject buildSubject(Jwt jwt, SignedJwt signedJwt) {
        Principal principal = this.buildPrincipal(jwt);
        TokenCredential.Builder builder = TokenCredential.builder();
        jwt.issueTime().ifPresent(arg_0 -> ((TokenCredential.Builder)builder).issueTime(arg_0));
        jwt.expirationTime().ifPresent(arg_0 -> ((TokenCredential.Builder)builder).expTime(arg_0));
        jwt.issuer().ifPresent(arg_0 -> ((TokenCredential.Builder)builder).issuer(arg_0));
        builder.token(signedJwt.tokenContent());
        builder.addToken(Jwt.class, (Object)jwt);
        builder.addToken(SignedJwt.class, (Object)signedJwt);
        Subject.Builder subjectBuilder = Subject.builder().principal(principal).addPublicCredential(TokenCredential.class, (Object)builder.build());
        if (this.useJwtGroups) {
            Optional userGroups = jwt.userGroups();
            userGroups.ifPresent(groups -> groups.forEach(group -> subjectBuilder.addGrant((Grant)Role.create((String)group))));
        }
        Optional scopes = jwt.scopes();
        scopes.ifPresent(scopeList -> scopeList.forEach(scope -> subjectBuilder.addGrant(Grant.builder().name(scope).type("scope").build())));
        return subjectBuilder.build();
    }

    Principal buildPrincipal(Jwt jwt) {
        String subject = (String)jwt.subject().orElseThrow(() -> new JwtException("JWT does not contain subject claim, cannot create principal."));
        String name = jwt.preferredUsername().orElse(subject);
        Principal.Builder builder = Principal.builder();
        builder.name(name).id(subject);
        jwt.payloadClaims().forEach((key, jsonValue) -> builder.addAttribute(key, JwtUtil.toObject((JsonValue)jsonValue)));
        jwt.email().ifPresent(value -> builder.addAttribute("email", value));
        jwt.emailVerified().ifPresent(value -> builder.addAttribute("email_verified", value));
        jwt.locale().ifPresent(value -> builder.addAttribute("locale", value));
        jwt.familyName().ifPresent(value -> builder.addAttribute("family_name", value));
        jwt.givenName().ifPresent(value -> builder.addAttribute("given_name", value));
        jwt.fullName().ifPresent(value -> builder.addAttribute("full_name", value));
        return builder.build();
    }

    public boolean isOutboundSupported(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
        return this.propagate;
    }

    protected OutboundSecurityResponse syncOutbound(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundEndpointConfig) {
        Optional maybeUsername = outboundEndpointConfig.abacAttribute(EP_PROPERTY_OUTBOUND_USER);
        return maybeUsername.map(String::valueOf).flatMap(username -> this.attemptImpersonation(outboundEnv, (String)username)).orElseGet(() -> this.attemptPropagation(providerRequest, outboundEnv));
    }

    private OutboundSecurityResponse attemptPropagation(ProviderRequest providerRequest, SecurityEnvironment outboundEnv) {
        Optional maybeSubject = this.subjectType == SubjectType.USER ? providerRequest.securityContext().user() : providerRequest.securityContext().service();
        return maybeSubject.flatMap(subject -> {
            Optional maybeTarget = this.outboundConfig.findTarget(outboundEnv);
            return maybeTarget.flatMap(target -> {
                JwtOutboundTarget jwtOutboundTarget = this.targetToJwtConfig.computeIfAbsent((OutboundTarget)target, this::toOutboundTarget);
                if (null == jwtOutboundTarget.jwkKid) {
                    return subject.publicCredential(TokenCredential.class).map(tokenCredential -> this.propagate(jwtOutboundTarget, tokenCredential.token()));
                }
                return Optional.of(this.propagate(jwtOutboundTarget, (Subject)subject));
            });
        }).orElseGet(OutboundSecurityResponse::abstain);
    }

    private Optional<OutboundSecurityResponse> attemptImpersonation(SecurityEnvironment outboundEnv, String username) {
        if (this.allowImpersonation) {
            Optional maybeTarget = this.outboundConfig.findTarget(outboundEnv);
            return maybeTarget.flatMap(target -> {
                JwtOutboundTarget jwtOutboundTarget = this.targetToJwtConfig.computeIfAbsent((OutboundTarget)target, this::toOutboundTarget);
                if (null == jwtOutboundTarget.jwkKid) {
                    return Optional.of(((OutboundSecurityResponse.Builder)((OutboundSecurityResponse.Builder)OutboundSecurityResponse.builder().description("Cannot do explicit user propagation if no kid is defined.")).status(SecurityResponse.SecurityStatus.FAILURE)).build());
                }
                return Optional.of(this.impersonate(jwtOutboundTarget, username));
            });
        }
        return Optional.of(((OutboundSecurityResponse.Builder)((OutboundSecurityResponse.Builder)OutboundSecurityResponse.builder().description("Attempting to impersonate a user, when impersonation is not allowed for JWT provider")).status(SecurityResponse.SecurityStatus.FAILURE)).build());
    }

    private OutboundSecurityResponse propagate(JwtOutboundTarget outboundTarget, String token) {
        HashMap headers = new HashMap();
        outboundTarget.outboundHandler.header(headers, token);
        return OutboundSecurityResponse.withHeaders(headers);
    }

    private OutboundSecurityResponse propagate(JwtOutboundTarget ot, Subject subject) {
        HashMap headers = new HashMap();
        Jwk jwk = (Jwk)this.signKeys.forKeyId(ot.jwkKid).orElseThrow(() -> new JwtException("Signing JWK with kid: " + ot.jwkKid + " is not defined."));
        Principal principal = subject.principal();
        Jwt.Builder builder = Jwt.builder();
        principal.abacAttributeNames().forEach(name -> principal.abacAttribute(name).ifPresent(val -> builder.addPayloadClaim(name, val)));
        principal.abacAttribute("full_name").ifPresentOrElse(name -> builder.addPayloadClaim("name", name), () -> builder.removePayloadClaim("name"));
        builder.subject(principal.id()).preferredUsername(principal.getName()).issuer(this.issuer).algorithm(jwk.algorithm());
        ot.update(builder);
        Jwt jwt = builder.build();
        SignedJwt signed = SignedJwt.sign((Jwt)jwt, (Jwk)jwk);
        ot.outboundHandler.header(headers, signed.tokenContent());
        return OutboundSecurityResponse.withHeaders(headers);
    }

    private OutboundSecurityResponse impersonate(JwtOutboundTarget ot, String username) {
        HashMap headers = new HashMap();
        Jwk jwk = (Jwk)this.signKeys.forKeyId(ot.jwkKid).orElseThrow(() -> new JwtException("Signing JWK with kid: " + ot.jwkKid + " is not defined."));
        Jwt.Builder builder = Jwt.builder();
        builder.addPayloadClaim("name", (Object)username);
        builder.subject(username).preferredUsername(username).issuer(this.issuer).algorithm(jwk.algorithm());
        ot.update(builder);
        Jwt jwt = builder.build();
        SignedJwt signed = SignedJwt.sign((Jwt)jwt, (Jwk)jwk);
        ot.outboundHandler.header(headers, signed.tokenContent());
        return OutboundSecurityResponse.withHeaders(headers);
    }

    private JwtOutboundTarget toOutboundTarget(OutboundTarget outboundTarget) {
        Optional customObject = outboundTarget.customObject(JwtOutboundTarget.class);
        if (customObject.isPresent()) {
            return (JwtOutboundTarget)customObject.get();
        }
        return JwtOutboundTarget.create(outboundTarget.getConfig().orElse(Config.empty()), this.defaultTokenHandler);
    }

    public static final class Builder
    implements io.helidon.common.Builder<JwtProvider> {
        private boolean verifySignature = true;
        private boolean optional = false;
        private boolean authenticate = true;
        private boolean propagate = true;
        private boolean allowImpersonation = false;
        private boolean allowUnsigned = false;
        private SubjectType subjectType = SubjectType.USER;
        private TokenHandler atnTokenHandler = TokenHandler.builder().tokenHeader("Authorization").tokenPrefix("bearer ").build();
        private OutboundConfig outboundConfig;
        private JwkKeys verifyKeys;
        private JwkKeys signKeys;
        private String issuer;
        private String expectedAudience;
        private boolean useJwtGroups = true;

        private Builder() {
        }

        public JwtProvider build() {
            if (this.verifySignature && null == this.verifyKeys) {
                throw new JwtException("Failed to extract verify JWK from configuration");
            }
            return new JwtProvider(this);
        }

        public Builder propagate(boolean propagate) {
            this.propagate = propagate;
            return this;
        }

        public Builder authenticate(boolean authenticate) {
            this.authenticate = authenticate;
            return this;
        }

        public Builder allowImpersonation(boolean allowImpersonation) {
            this.allowImpersonation = allowImpersonation;
            return this;
        }

        public Builder allowUnsigned(boolean allowUnsigned) {
            this.allowUnsigned = allowUnsigned;
            return this;
        }

        public Builder verifySignature(boolean shouldValidate) {
            this.verifySignature = shouldValidate;
            return this;
        }

        public Builder subjectType(SubjectType subjectType) {
            this.subjectType = subjectType;
            switch (subjectType) {
                case USER: 
                case SERVICE: {
                    break;
                }
                default: {
                    throw new SecurityException("Invalid configuration. Principal type not supported: " + subjectType);
                }
            }
            return this;
        }

        public Builder atnTokenHandler(TokenHandler tokenHandler) {
            this.atnTokenHandler = tokenHandler;
            return this;
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder outboundConfig(OutboundConfig config) {
            this.outboundConfig = config;
            return this;
        }

        public Builder signJwk(Resource signJwkResource) {
            this.signKeys = JwkKeys.builder().resource(signJwkResource).build();
            return this;
        }

        public Builder verifyJwk(Resource verifyJwkResource) {
            this.verifyKeys = JwkKeys.builder().resource(verifyJwkResource).build();
            return this;
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder config(Config config) {
            config.get("optional").asBoolean().ifPresent(this::optional);
            config.get("authenticate").asBoolean().ifPresent(this::authenticate);
            config.get("propagate").asBoolean().ifPresent(this::propagate);
            config.get("allow-impersonation").asBoolean().ifPresent(this::allowImpersonation);
            config.get("principal-type").asString().map(SubjectType::valueOf).ifPresent(this::subjectType);
            config.get("atn-token.handler").as(TokenHandler::create).ifPresent(this::atnTokenHandler);
            config.get("atn-token").ifExists(this::verifyKeys);
            config.get("atn-token.jwt-audience").asString().ifPresent(this::expectedAudience);
            config.get("atn-token.verify-signature").asBoolean().ifPresent(this::verifySignature);
            config.get("sign-token").ifExists(outbound -> this.outboundConfig(OutboundConfig.create((Config)outbound)));
            config.get("sign-token").ifExists(this::outbound);
            config.get("allow-unsigned").asBoolean().ifPresent(this::allowUnsigned);
            config.get("use-jwt-groups").asBoolean().ifPresent(this::useJwtGroups);
            return this;
        }

        public void expectedAudience(String audience) {
            this.expectedAudience = audience;
        }

        public Builder useJwtGroups(boolean useJwtGroups) {
            this.useJwtGroups = useJwtGroups;
            return this;
        }

        private void verifyKeys(Config config) {
            config.get("jwk.resource").as(Resource::create).ifPresent(this::verifyJwk);
            Resource.create((Config)config, (String)"jwk").ifPresent(this::verifyJwk);
        }

        private void outbound(Config config) {
            config.get("jwt-issuer").asString().ifPresent(this::issuer);
            config.get("jwk.resource").as(Resource::create).ifPresent(this::signJwk);
            Resource.create((Config)config, (String)"jwk").ifPresent(this::signJwk);
        }
    }

    public static class JwtOutboundTarget {
        public static final long DEFAULT_VALIDITY_SECONDS = 86400L;
        public static final int DEFAULT_NOT_BEFORE_SECONDS = 5;
        private final TokenHandler outboundHandler;
        private final String jwtKid;
        private final String jwkKid;
        private final String jwtAudience;
        private final int notBeforeSeconds;
        private final long validitySeconds;

        private JwtOutboundTarget(Builder builder) {
            this.outboundHandler = builder.outboundHandler;
            this.jwtKid = builder.jwtKid;
            this.jwkKid = builder.jwkKid;
            this.jwtAudience = builder.jwtAudience;
            this.notBeforeSeconds = builder.notBeforeSeconds;
            this.validitySeconds = builder.validitySeconds;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static JwtOutboundTarget create(Config config, TokenHandler defaultHandler) {
            return JwtOutboundTarget.builder().tokenHandler(defaultHandler).config(config).build();
        }

        private void update(Jwt.Builder builder) {
            Instant now = Instant.now();
            Instant exp = now.plus(this.validitySeconds, ChronoUnit.SECONDS);
            Instant notBefore = now.minus(this.notBeforeSeconds, ChronoUnit.SECONDS);
            builder.issueTime(now).expirationTime(exp).notBefore(notBefore).keyId(this.jwtKid).audience(this.jwtAudience);
        }

        public static final class Builder
        implements io.helidon.common.Builder<JwtOutboundTarget> {
            private TokenHandler outboundHandler = TokenHandler.builder().tokenHeader("Authorization").tokenPrefix("bearer ").build();
            private String jwtKid;
            private String jwkKid;
            private String jwtAudience;
            private int notBeforeSeconds = 5;
            private long validitySeconds = 86400L;

            private Builder() {
            }

            public JwtOutboundTarget build() {
                return new JwtOutboundTarget(this);
            }

            public Builder config(Config config) {
                config.get("outbound-token").asNode().map(TokenHandler::create).ifPresent(this::tokenHandler);
                config.get("jwt-kid").asString().ifPresent(this::jwtKid);
                config.get("jwk-kid").asString().ifPresent(this::jwkKid);
                config.get("jwt-audience").asString().ifPresent(this::jwtAudience);
                config.get("jwt-not-before-seconds").asInt().ifPresent(this::notBeforeSeconds);
                config.get("jwt-validity-seconds").asLong().ifPresent(this::validitySeconds);
                return this;
            }

            public Builder tokenHandler(TokenHandler outboundHandler) {
                this.outboundHandler = outboundHandler;
                return this;
            }

            public Builder jwtKid(String jwtKid) {
                this.jwtKid = jwtKid;
                return this;
            }

            public Builder jwkKid(String jwkKid) {
                this.jwkKid = jwkKid;
                return this;
            }

            public Builder jwtAudience(String jwtAudience) {
                this.jwtAudience = jwtAudience;
                return this;
            }

            public Builder notBeforeSeconds(int notBeforeSeconds) {
                this.notBeforeSeconds = notBeforeSeconds;
                return this;
            }

            public Builder validitySeconds(long validitySeconds) {
                this.validitySeconds = validitySeconds;
                return this;
            }
        }
    }
}

