/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.jersey;

import io.helidon.jersey.common.InvokedResource;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerRequestContext;

public final class TracingHelper {
    private final Function<ContainerRequestContext, String> nameFunction;

    private TracingHelper(Function<ContainerRequestContext, String> nameFunction) {
        this.nameFunction = nameFunction;
    }

    public static TracingHelper create() {
        return new TracingHelper(TracingHelper::classMethodName);
    }

    public static TracingHelper create(Function<ContainerRequestContext, String> nameFunction) {
        return new TracingHelper(nameFunction);
    }

    public static String httpPathMethodName(ContainerRequestContext requestContext) {
        InvokedResource invokedResource = InvokedResource.create((ContainerRequestContext)requestContext);
        Optional method = invokedResource.definitionMethod();
        if (!method.isPresent()) {
            return requestContext.getMethod().toUpperCase() + ":" + requestContext.getUriInfo().getPath();
        }
        StringBuilder fullPath = new StringBuilder();
        fullPath.append(requestContext.getMethod().toUpperCase());
        fullPath.append(":");
        Optional classPathAnnotation = invokedResource.findClassAnnotation(Path.class);
        classPathAnnotation.map(Path::value).ifPresent(resourcePath -> {
            if (!resourcePath.startsWith("/")) {
                fullPath.append("/");
            }
            fullPath.append((String)resourcePath);
        });
        Optional methodPathAnnotation = invokedResource.findMethodAnnotation(Path.class);
        methodPathAnnotation.map(Path::value).ifPresent(methodPath -> {
            if (fullPath.length() != 0 && fullPath.charAt(fullPath.length() - 1) != '/' && !methodPath.startsWith("/")) {
                fullPath.append("/");
            }
            fullPath.append((String)methodPath);
        });
        return fullPath.toString();
    }

    public static String classMethodName(ContainerRequestContext requestContext) {
        return InvokedResource.create((ContainerRequestContext)requestContext).definitionMethod().map(m -> requestContext.getMethod().toUpperCase() + ":" + m.getDeclaringClass().getName() + "." + m.getName()).orElseGet(() -> requestContext.getMethod().toUpperCase() + ":404");
    }

    public String generateSpanName(ContainerRequestContext context) {
        return this.nameFunction.apply(context);
    }
}

