/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.jersey;

import io.helidon.common.configurable.ThreadPoolSupplier;
import io.helidon.config.Config;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.glassfish.jersey.server.ManagedAsyncExecutor;
import org.glassfish.jersey.spi.ExecutorServiceProvider;

@ManagedAsyncExecutor
class AsyncExecutorProvider
implements ExecutorServiceProvider {
    private final Supplier<ExecutorService> executorServiceSupplier;

    AsyncExecutorProvider(Supplier<ExecutorService> supplier) {
        this.executorServiceSupplier = Objects.requireNonNull(supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExecutorServiceProvider create(Config config) {
        Method m;
        Config asyncExecutorServiceConfig = config.get("async-executor-service");
        if (((Boolean)asyncExecutorServiceConfig.get("virtual-threads").asBoolean().orElse((Object)false)).booleanValue()) {
            Method temp = null;
            try {
                temp = Executors.class.getDeclaredMethod("newVirtualThreadExecutor", new Class[0]);
            }
            catch (ReflectiveOperationException notLoom) {
                temp = null;
            }
            finally {
                m = temp;
            }
        } else {
            m = null;
        }
        if (m != null) {
            return new AsyncExecutorProvider(() -> {
                try {
                    return (ExecutorService)m.invoke(null, new Object[0]);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new IllegalStateException(reflectiveOperationException.getMessage(), reflectiveOperationException);
                }
            });
        }
        return new AsyncExecutorProvider((Supplier<ExecutorService>)ThreadPoolSupplier.builder().corePoolSize(1).maxPoolSize(10).prestart(false).threadNamePrefix("helidon-jersey-async").config(asyncExecutorServiceConfig).build());
    }

    static ExecutorServiceProvider create(ExecutorService executor) {
        return new AsyncExecutorProvider(() -> executor);
    }

    static ExecutorServiceProvider create(Supplier<ExecutorService> executorServiceSupplier) {
        return new AsyncExecutorProvider(executorServiceSupplier);
    }

    public ExecutorService getExecutorService() {
        return this.executorServiceSupplier.get();
    }

    public void dispose(ExecutorService executorService) {
    }
}

