/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.listeners;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import io.jenkins.blueocean.listeners.NodeDownstreamBuildAction;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.LinkResolver;
import java.io.IOException;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildUpstreamCause;

@Extension
public class DownstreamJobListener
extends RunListener<Run<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(DownstreamJobListener.class.getName());

    public void onStarted(Run<?, ?> run, TaskListener listener) {
        for (Cause cause : run.getCauses()) {
            Link link;
            FlowNode node;
            BuildUpstreamCause buildUpstreamCause;
            Run triggerRun;
            if (!(cause instanceof BuildUpstreamCause) || !((triggerRun = (buildUpstreamCause = (BuildUpstreamCause)cause).getUpstreamRun()) instanceof WorkflowRun)) continue;
            FlowExecution execution = ((WorkflowRun)triggerRun).getExecution();
            if (execution == null) {
                LOGGER.warning("Could not retrieve upstream FlowExecution");
                continue;
            }
            try {
                node = execution.getNode(buildUpstreamCause.getNodeId());
            }
            catch (IOException e) {
                LOGGER.warning("Could not retrieve upstream node: " + String.valueOf(e));
                continue;
            }
            if (node == null) {
                LOGGER.warning("Could not retrieve upstream node (null)");
                continue;
            }
            String description = run.getDescription();
            if (description == null) {
                description = run.getFullDisplayName();
            }
            if ((link = LinkResolver.resolveLink(run)) == null) continue;
            try {
                node.addAction((Action)new NodeDownstreamBuildAction(link, description));
                node.save();
            }
            catch (IOException e) {
                LOGGER.severe("Could not persist node: " + String.valueOf(e));
            }
        }
    }
}

