/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.preload;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.blueocean.commons.PageStatePreloader;
import io.jenkins.blueocean.preload.BlueUrlTokenizer;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class RESTFetchPreloader
extends PageStatePreloader {
    public final String getStatePropertyPath() {
        return "prefetchdata." + ((Object)((Object)this)).getClass().getSimpleName();
    }

    public final String getStateJson() {
        BlueUrlTokenizer blueUrl = BlueUrlTokenizer.parseCurrentRequest();
        if (blueUrl == null) {
            return null;
        }
        FetchData fetchData = this.getFetchData(blueUrl);
        if (fetchData != null) {
            return fetchData.toJSON();
        }
        return null;
    }

    protected abstract FetchData getFetchData(@NonNull BlueUrlTokenizer var1);

    public static final class FetchData {
        private String restUrl;
        private String data;

        public FetchData(@NonNull String restUrl, @NonNull String data) {
            this.restUrl = restUrl;
            this.data = data;
        }

        public String getRestUrl() {
            return this.restUrl;
        }

        public String getData() {
            return this.data;
        }

        public String toJSON() {
            JSONObject json = new JSONObject();
            json.put("restUrl", (Object)this.restUrl);
            json.put("data", (Object)this.data);
            return json.toString();
        }
    }
}

