/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import java.util.Locale;

public enum DocumentLanguage {
    ARABIC("arabic", new Locale("ar")),
    ARMENIAN("armenian", new Locale("hy")),
    DANISH("danish", new Locale("da")),
    DUTCH("dutch", new Locale("nl")),
    ENGLISH("english", Locale.ENGLISH),
    FINNISH("finnish", new Locale("fi")),
    FRENCH("french", Locale.FRENCH),
    GERMAN("german", Locale.GERMAN),
    HUNGARIAN("hungarian", new Locale("hu")),
    ITALIAN("italian", Locale.ITALIAN),
    NORWEGIAN("norwegian", new Locale("no")),
    PORTUGUESE("portuguese", new Locale("pt")),
    ROMANIAN("romanian", new Locale("ro")),
    RUSSIAN("russian", new Locale("ru")),
    SERBIAN("serbian", new Locale("sr")),
    SPANISH("spanish", new Locale("es")),
    SWEDISH("swedish", new Locale("sv")),
    TAMIL("tamil", new Locale("ta")),
    TURKISH("turkish", new Locale("tr")),
    YIDDISH("yiddish", new Locale("yi")),
    CHINESE("chinese", Locale.CHINESE);

    private final String language;
    private final Locale locale;

    private DocumentLanguage(String language, Locale locale) {
        this.language = language;
        this.locale = locale;
    }

    public String toString() {
        return this.language;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static DocumentLanguage getLanguage(Locale locale) {
        for (DocumentLanguage language : DocumentLanguage.values()) {
            if (!language.getLocale().getLanguage().equals(locale.getLanguage())) continue;
            return language;
        }
        throw new UnsupportedOperationException("No language found for locale: " + locale);
    }
}

