/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.Option;
import io.micronaut.aot.core.codegen.AbstractSingleClassFileGenerator;
import io.micronaut.aot.core.codegen.MapGenerator;
import io.micronaut.context.env.MapPropertySource;
import io.micronaut.core.annotation.Generated;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import java.util.Map;
import javax.lang.model.element.Modifier;

@AOTModule(id="map.property", options={@Option(key="map.property.order", description="The order of the generated property source", sampleValue="1000")})
public class MapPropertySourceGenerator
extends AbstractSingleClassFileGenerator {
    public static final String BASE_ID = "map.property";
    public static final String BASE_ORDER_OPTION = "map.property.order";
    private final String namePrefix;
    private final String resourceName;
    private final Map<String, Object> values;
    private final Integer order;

    public MapPropertySourceGenerator(String namePrefix, String resourceName, Map<String, Object> values, Integer order) {
        this.namePrefix = namePrefix;
        this.resourceName = resourceName;
        this.values = values;
        this.order = order;
    }

    public MapPropertySourceGenerator(String resourceName, Map<String, Object> values) {
        this("", resourceName, values, null);
    }

    @NonNull
    protected JavaFile generate() {
        String typeName = this.computeTypeName();
        String orderKey = "map.property.order." + this.resourceName;
        int order = (Integer)this.getContext().getConfiguration().optionalValue(orderKey, value -> value.map(Integer::parseInt).orElse(this.order != null ? this.order : Integer.MIN_VALUE));
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)typeName).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(MapPropertySource.class);
        MapGenerator generator = new MapGenerator();
        typeBuilder.addMethod(MethodSpec.constructorBuilder().addStatement("super($S, $L)", new Object[]{this.resourceName, generator.generateMap(typeBuilder, this.values)}).build()).addMethod(MethodSpec.methodBuilder((String)"getOrder").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return $L", new Object[]{order}).build()).addAnnotation(Generated.class);
        return this.javaFile(typeBuilder.build());
    }

    private String computeTypeName() {
        return StringUtils.capitalize((String)(this.resourceName.replaceAll("[^A-Za-z0-9]", "_") + this.namePrefix + "StaticPropertySource"));
    }
}

