/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.jaxrs.AwsProxySecurityContext;
import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import com.amazonaws.serverless.proxy.model.AlbContext;
import com.amazonaws.serverless.proxy.model.ApiGatewayAuthorizerContext;
import com.amazonaws.serverless.proxy.model.ApiGatewayRequestIdentity;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyRequestContext;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.model.CognitoAuthorizerClaims;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.serverless.proxy.model.ErrorModel;
import com.amazonaws.serverless.proxy.model.Headers;
import com.amazonaws.serverless.proxy.model.MultiValuedTreeMap;
import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.TypeVariableResolver;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.function.aws.LambdaApplicationContextBuilder;
import io.micronaut.function.aws.proxy.AbstractLambdaContainerHandler;
import io.micronaut.function.aws.proxy.MicronautAwsProxyExceptionHandler;
import io.micronaut.function.aws.proxy.MicronautAwsProxyRequest;
import io.micronaut.function.aws.proxy.MicronautAwsProxyResponse;
import io.micronaut.function.aws.proxy.MicronautLambdaContainerContext;
import io.micronaut.function.aws.proxy.MicronautRequestReader;
import io.micronaut.function.aws.proxy.MicronautResponseWriter;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.filter.FilterChain;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.types.files.StreamedFile;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.jackson.codec.JsonMediaTypeCodec;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.web.router.resource.StaticResourceResolver;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.reactivestreams.Publisher;

@TypeHint(accessType={TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS, TypeHint.AccessType.ALL_PUBLIC}, value={AlbContext.class, ApiGatewayAuthorizerContext.class, ApiGatewayRequestIdentity.class, AwsProxyRequest.class, AwsProxyRequestContext.class, AwsProxyResponse.class, CognitoAuthorizerClaims.class, ContainerConfig.class, ErrorModel.class, Headers.class, MultiValuedTreeMap.class, AwsProxySecurityContext.class})
public final class MicronautLambdaContainerHandler
extends AbstractLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse, MicronautAwsProxyRequest<?>, MicronautAwsProxyResponse<?>>
implements ApplicationContextProvider,
Closeable,
AutoCloseable {
    private static final String TIMER_INIT = "MICRONAUT_COLD_START";
    private static final String TIMER_REQUEST = "MICRONAUT_HANDLE_REQUEST";
    private final ApplicationContextBuilder applicationContextBuilder;
    private final LambdaContainerState lambdaContainerEnvironment;
    private ApplicationContext applicationContext;
    private RequestArgumentSatisfier requestArgumentSatisfier;
    private StaticResourceResolver resourceResolver;

    public MicronautLambdaContainerHandler(ApplicationContextBuilder applicationContextBuilder) throws ContainerInitializationException {
        this(new LambdaContainerState(), applicationContextBuilder, null);
    }

    public MicronautLambdaContainerHandler() throws ContainerInitializationException {
        this(new LambdaContainerState(), ApplicationContext.build(), null);
    }

    public MicronautLambdaContainerHandler(ApplicationContext applicationContext) throws ContainerInitializationException {
        this(new LambdaContainerState(), ApplicationContext.build(), applicationContext);
    }

    private MicronautLambdaContainerHandler(LambdaContainerState lambdaContainerEnvironment, ApplicationContextBuilder applicationContextBuilder, ApplicationContext applicationContext) throws ContainerInitializationException {
        super(AwsProxyRequest.class, AwsProxyResponse.class, new MicronautRequestReader(lambdaContainerEnvironment), new MicronautResponseWriter(lambdaContainerEnvironment), new AwsProxySecurityContextWriter(), new MicronautAwsProxyExceptionHandler(lambdaContainerEnvironment));
        ArgumentUtils.requireNonNull((String)"applicationContextBuilder", (Object)applicationContextBuilder);
        this.lambdaContainerEnvironment = lambdaContainerEnvironment;
        this.applicationContextBuilder = applicationContextBuilder;
        if (applicationContext == null) {
            this.initialize();
        } else {
            this.applicationContext = applicationContext;
            this.initContainerState();
        }
    }

    private MicronautLambdaContainerHandler(LambdaContainerState lambdaContainerEnvironment) throws ContainerInitializationException {
        this(lambdaContainerEnvironment, ApplicationContext.build(), null);
    }

    @Deprecated
    public static MicronautLambdaContainerHandler getAwsProxyHandler() throws ContainerInitializationException {
        return new MicronautLambdaContainerHandler(new LambdaContainerState());
    }

    @Deprecated
    public static MicronautLambdaContainerHandler getAwsProxyHandler(ApplicationContextBuilder builder) throws ContainerInitializationException {
        ArgumentUtils.requireNonNull((String)"builder", (Object)builder);
        return new MicronautLambdaContainerHandler(new LambdaContainerState(), builder, null);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    protected ObjectMapper objectMapper() {
        return this.lambdaContainerEnvironment.getObjectMapper();
    }

    @Override
    protected ObjectWriter writerFor(Class<AwsProxyResponse> responseClass) {
        return this.objectMapper().writerFor(responseClass);
    }

    @Override
    protected ObjectReader readerFor(Class<AwsProxyRequest> requestClass) {
        return this.objectMapper().readerFor(requestClass);
    }

    @Override
    protected MicronautAwsProxyResponse<?> getContainerResponse(MicronautAwsProxyRequest<?> request, CountDownLatch latch) {
        MicronautAwsProxyResponse response = new MicronautAwsProxyResponse(request.getAwsProxyRequest(), latch, this.lambdaContainerEnvironment);
        Optional routeMatchAttr = request.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH);
        routeMatchAttr.ifPresent(o -> response.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, o));
        request.setResponse(response);
        return request.getResponse();
    }

    @Override
    public void initialize() throws ContainerInitializationException {
        Timer.start((String)TIMER_INIT);
        try {
            LambdaApplicationContextBuilder.setLambdaConfiguration((ApplicationContextBuilder)this.applicationContextBuilder);
            this.applicationContext = this.applicationContextBuilder.build().start();
            this.initContainerState();
        }
        catch (Exception e) {
            throw new ContainerInitializationException("Error starting Micronaut container: " + e.getMessage(), e);
        }
        Timer.stop((String)TIMER_INIT);
    }

    protected void initContainerState() {
        this.lambdaContainerEnvironment.setApplicationContext(this.applicationContext);
        this.lambdaContainerEnvironment.setJsonCodec((JsonMediaTypeCodec)this.applicationContext.getBean(JsonMediaTypeCodec.class));
        this.lambdaContainerEnvironment.setRouter((Router)this.applicationContext.getBean(Router.class));
        Optional objectMapper = this.applicationContext.findBean(ObjectMapper.class, Qualifiers.byName((String)"aws"));
        if (objectMapper.isPresent()) {
            this.lambdaContainerEnvironment.setObjectMapper((ObjectMapper)objectMapper.get());
        } else {
            this.lambdaContainerEnvironment.setObjectMapper((ObjectMapper)this.applicationContext.getBean(ObjectMapper.class));
        }
        this.requestArgumentSatisfier = new RequestArgumentSatisfier((RequestBinderRegistry)this.applicationContext.getBean(RequestBinderRegistry.class));
        this.resourceResolver = (StaticResourceResolver)this.applicationContext.getBean(StaticResourceResolver.class);
        this.addConverters();
    }

    protected void addConverters() {
        this.addByteArrayToStringConverter();
    }

    protected void addByteArrayToStringConverter() {
        this.applicationContext.getEnvironment().addConverter(byte[].class, String.class, bytes -> new String((byte[])bytes, StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleRequest(MicronautAwsProxyRequest<?> containerRequest, MicronautAwsProxyResponse<?> containerResponse, Context lambdaContext) {
        Timer.start((String)TIMER_REQUEST);
        try {
            ServerRequestContext.with(containerRequest, () -> {
                block26: {
                    Optional routeMatch = containerRequest.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, UriRouteMatch.class);
                    try {
                        Optional staticMatch;
                        if (routeMatch.isPresent()) {
                            UriRouteMatch finalRoute = (UriRouteMatch)routeMatch.get();
                            containerRequest.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, finalRoute);
                            AnnotationMetadata annotationMetadata = finalRoute.getAnnotationMetadata();
                            annotationMetadata.stringValue(Produces.class).map(MediaType::new).ifPresent(arg_0 -> ((MicronautAwsProxyResponse)containerResponse).contentType(arg_0));
                            Flowable responsePublisher = Flowable.defer(() -> this.executeRoute(containerRequest, containerResponse, (MethodBasedRouteMatch)finalRoute));
                            AtomicReference requestReference = new AtomicReference(containerRequest);
                            Flowable filterPublisher = Flowable.fromPublisher(this.filterPublisher(requestReference, (Publisher<? extends MutableHttpResponse<?>>)responsePublisher));
                            filterPublisher.onErrorResumeNext(mayBeWrapped -> {
                                Throwable throwable = mayBeWrapped instanceof UndeclaredThrowableException ? mayBeWrapped.getCause() : mayBeWrapped;
                                RouteMatch errorHandler = this.lambdaContainerEnvironment.getRouter().route(finalRoute.getDeclaringType(), throwable).orElseGet(() -> this.lambdaContainerEnvironment.getRouter().route(throwable).orElse(null));
                                if (errorHandler == null) {
                                    ApplicationContext ctx = this.lambdaContainerEnvironment.getApplicationContext();
                                    ExceptionHandler exceptionHandler = ctx.findBean(ExceptionHandler.class, Qualifiers.byTypeArgumentsClosest((Class[])new Class[]{throwable.getClass(), Object.class})).orElse(null);
                                    if (exceptionHandler != null) {
                                        Flowable<? extends MutableHttpResponse<?>> errorFlowable = this.handleException(containerRequest, containerResponse, throwable, exceptionHandler);
                                        return this.filterPublisher(requestReference, (Publisher<? extends MutableHttpResponse<?>>)errorFlowable);
                                    }
                                } else if (errorHandler instanceof MethodBasedRouteMatch) {
                                    return this.executeRoute(containerRequest, containerResponse, (MethodBasedRouteMatch)errorHandler);
                                }
                                return Flowable.error((Throwable)throwable);
                            }).blockingFirst();
                            break block26;
                        }
                        Optional finalRoute = this.lambdaContainerEnvironment.getRouter().route(containerRequest.getMethod(), (CharSequence)containerRequest.getPath());
                        if (finalRoute.isPresent()) {
                            AnnotationMetadata annotationMetadata = ((UriRouteMatch)finalRoute.get()).getAnnotationMetadata();
                            annotationMetadata.stringValue(Produces.class).map(MediaType::new).ifPresent(arg_0 -> ((MicronautAwsProxyResponse)containerResponse).contentType(arg_0));
                            MediaType[] expectedContentType = (MediaType[])Arrays.stream(annotationMetadata.stringValues(Consumes.class)).map(MediaType::new).toArray(MediaType[]::new);
                            MediaType requestContentType = containerRequest.getContentType().orElse(null);
                            if (expectedContentType.length > 0 && Arrays.stream(expectedContentType).noneMatch(ct -> ct.equals((Object)requestContentType)) && Arrays.stream(expectedContentType).noneMatch(ct -> ct.equals((Object)MediaType.ALL_TYPE))) {
                                containerResponse.status(HttpStatus.UNSUPPORTED_MEDIA_TYPE);
                                containerResponse.close();
                                return;
                            }
                        }
                        if ((staticMatch = this.resourceResolver.resolve(containerRequest.getPath())).isPresent()) {
                            StreamedFile streamedFile = new StreamedFile((URL)staticMatch.get());
                            long length = streamedFile.getLength();
                            if (length > -1L) {
                                containerResponse.header("Content-Length", String.valueOf(length));
                            }
                            containerResponse.header("Content-Type", streamedFile.getMediaType().toString());
                            try (InputStream inputStream = streamedFile.getInputStream();){
                                byte[] data = IOUtils.toByteArray((InputStream)inputStream);
                                containerResponse.body(data);
                                break block26;
                            }
                            catch (Throwable e) {
                                RouteMatch errorHandler = this.lambdaContainerEnvironment.getRouter().route(e).orElse(null);
                                AtomicReference requestReference = new AtomicReference(containerRequest);
                                ApplicationContext ctx = this.lambdaContainerEnvironment.getApplicationContext();
                                if (errorHandler instanceof MethodBasedRouteMatch) {
                                    Flowable.fromPublisher(this.executeRoute(containerRequest, containerResponse, (MethodBasedRouteMatch)errorHandler)).blockingFirst();
                                } else {
                                    ExceptionHandler exceptionHandler = ctx.findBean(ExceptionHandler.class, Qualifiers.byTypeArgumentsClosest((Class[])new Class[]{e.getClass(), Object.class})).orElse(null);
                                    if (exceptionHandler != null) {
                                        Flowable<? extends MutableHttpResponse<?>> errorFlowable = this.handleException(containerRequest, containerResponse, e, exceptionHandler);
                                        Flowable.fromPublisher(this.filterPublisher(requestReference, (Publisher<? extends MutableHttpResponse<?>>)errorFlowable)).blockingFirst();
                                    }
                                }
                                break block26;
                            }
                        }
                        AtomicReference requestReference = new AtomicReference(containerRequest);
                        Stream matches = this.lambdaContainerEnvironment.getRouter().findAny((CharSequence)containerRequest.getPath(), (HttpRequest)containerRequest);
                        Flowable statusFlowable = Flowable.fromCallable(() -> {
                            containerResponse.status(matches.findFirst().isPresent() ? HttpStatus.METHOD_NOT_ALLOWED : HttpStatus.NOT_FOUND);
                            return containerResponse;
                        });
                        Flowable.fromPublisher(this.filterPublisher(requestReference, (Publisher<? extends MutableHttpResponse<?>>)statusFlowable)).blockingFirst();
                    }
                    finally {
                        containerResponse.close();
                    }
                }
            });
        }
        finally {
            Timer.stop((String)TIMER_REQUEST);
        }
    }

    private void decodeRequestBody(MicronautAwsProxyRequest<?> containerRequest, MethodBasedRouteMatch<Object, Object> finalRoute) {
        Optional body;
        MediaType[] expectedContentType;
        MediaType requestContentType;
        boolean permitsRequestBody = HttpMethod.permitsRequestBody((HttpMethod)containerRequest.getMethod());
        if (permitsRequestBody && (requestContentType = (MediaType)containerRequest.getContentType().orElse(null)) != null && requestContentType.getExtension().equalsIgnoreCase("json") && ((expectedContentType = (MediaType[])finalRoute.getAnnotationMetadata().getValue(Consumes.class, MediaType[].class).orElse(null)) == null || Arrays.stream(expectedContentType).anyMatch(ct -> ct.getExtension().equalsIgnoreCase("json"))) && (body = containerRequest.getBody(String.class)).isPresent()) {
            Argument bodyArgument = finalRoute.getBodyArgument().orElse(null);
            if (bodyArgument == null) {
                bodyArgument = Arrays.stream(finalRoute.getArguments()).filter(arg -> HttpRequest.class.isAssignableFrom(arg.getType())).findFirst().flatMap(TypeVariableResolver::getFirstTypeVariable).orElse(null);
            }
            if (bodyArgument != null) {
                Class rawType = bodyArgument.getType();
                if (Publishers.isConvertibleToPublisher((Class)rawType) || HttpRequest.class.isAssignableFrom(rawType)) {
                    bodyArgument = bodyArgument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                }
                Object decoded = this.lambdaContainerEnvironment.getJsonCodec().decode(bodyArgument, (String)body.get());
                containerRequest.setDecodedBody(decoded);
            } else {
                JsonNode jsonNode = (JsonNode)this.lambdaContainerEnvironment.getJsonCodec().decode(JsonNode.class, (String)body.get());
                containerRequest.setDecodedBody(jsonNode);
            }
        }
    }

    private Flowable<? extends MutableHttpResponse<?>> handleException(MicronautAwsProxyRequest<?> containerRequest, MicronautAwsProxyResponse<?> containerResponse, Throwable throwable, ExceptionHandler exceptionHandler) {
        return Flowable.fromCallable(() -> {
            Object result = exceptionHandler.handle((HttpRequest)containerRequest, throwable);
            MutableHttpResponse<?> response = this.errorResultToResponse(result);
            containerResponse.status(response.getStatus());
            response.getContentType().ifPresent(arg_0 -> ((MicronautAwsProxyResponse)containerResponse).contentType(arg_0));
            response.getBody().ifPresent(arg_0 -> ((MutableHttpResponse)containerResponse).body(arg_0));
            return response;
        });
    }

    private Publisher<MutableHttpResponse<?>> executeRoute(MicronautAwsProxyRequest<?> containerRequest, MicronautAwsProxyResponse<?> containerResponse, MethodBasedRouteMatch finalRoute) {
        RouteMatch boundRoute = this.requestArgumentSatisfier.fulfillArgumentRequirements((RouteMatch)finalRoute, containerRequest, false);
        try {
            this.decodeRequestBody(containerRequest, (MethodBasedRouteMatch<Object, Object>)finalRoute);
        }
        catch (Exception e) {
            return Flowable.error((Throwable)e);
        }
        Object result = boundRoute.execute();
        if (result instanceof Optional) {
            Optional optional = (Optional)result;
            result = optional.orElse(null);
        }
        if (!Void.TYPE.isAssignableFrom(boundRoute.getReturnType().getType()) && result == null) {
            this.applyRouteConfig(containerResponse, finalRoute);
            containerResponse.status(HttpStatus.NOT_FOUND);
            return Flowable.just(containerResponse);
        }
        if (Publishers.isConvertibleToPublisher((Object)result)) {
            Single single = Publishers.isSingle(result.getClass()) || boundRoute.getReturnType().isSpecifiedSingle() ? (Single)Publishers.convertPublisher((Object)result, Single.class) : ((Flowable)Publishers.convertPublisher((Object)result, Flowable.class)).toList();
            return single.map(o -> {
                if (!(o instanceof MicronautAwsProxyResponse)) {
                    containerResponse.body(o);
                }
                this.applyRouteConfig(containerResponse, finalRoute);
                return containerResponse;
            }).toFlowable();
        }
        if (!(result instanceof MicronautAwsProxyResponse)) {
            this.applyRouteConfig(containerResponse, finalRoute);
            containerResponse.body(result);
        }
        return Flowable.just(containerResponse);
    }

    private MutableHttpResponse<?> errorResultToResponse(Object result) {
        MutableHttpResponse response;
        if (result == null) {
            response = HttpResponse.serverError();
        } else if (result instanceof HttpResponse) {
            response = (MutableHttpResponse)result;
        } else {
            response = HttpResponse.serverError().body(result);
            MediaType.fromType(result.getClass()).ifPresent(arg_0 -> ((MutableHttpResponse)response).contentType(arg_0));
        }
        return response;
    }

    private void applyRouteConfig(MicronautAwsProxyResponse<?> containerResponse, MethodBasedRouteMatch finalRoute) {
        if (!containerResponse.getContentType().isPresent()) {
            finalRoute.getValue(Produces.class, String.class).ifPresent(arg_0 -> containerResponse.contentType(arg_0));
        }
        finalRoute.getValue(Status.class, HttpStatus.class).ifPresent(httpStatus -> containerResponse.status((HttpStatus)httpStatus));
    }

    @Override
    public void close() {
        this.applicationContext.close();
    }

    private Publisher<MutableHttpResponse<?>> filterPublisher(AtomicReference<HttpRequest<?>> requestReference, Publisher<? extends MutableHttpResponse<?>> routePublisher) {
        Publisher finalPublisher;
        ArrayList<HttpFilter> filters = new ArrayList<HttpFilter>(this.lambdaContainerEnvironment.getRouter().findFilters(requestReference.get()));
        if (!filters.isEmpty()) {
            Publisher resultingPublisher;
            filters.add((HttpFilter)((HttpServerFilter)(req, chain) -> routePublisher));
            AtomicInteger integer = new AtomicInteger();
            int len = filters.size();
            LambdaFilterChain filterChain = new LambdaFilterChain(integer, len, filters, requestReference);
            HttpFilter httpFilter = (HttpFilter)filters.get(0);
            finalPublisher = resultingPublisher = httpFilter.doFilter(requestReference.get(), (FilterChain)filterChain);
        } else {
            finalPublisher = routePublisher;
        }
        return finalPublisher;
    }

    private static class LambdaFilterChain
    implements ServerFilterChain {
        private final AtomicInteger integer;
        private final int len;
        private final List<HttpFilter> filters;
        private final AtomicReference<HttpRequest<?>> requestReference;

        LambdaFilterChain(AtomicInteger integer, int len, List<HttpFilter> filters, AtomicReference<HttpRequest<?>> requestReference) {
            this.integer = integer;
            this.len = len;
            this.filters = filters;
            this.requestReference = requestReference;
        }

        public Publisher<MutableHttpResponse<?>> proceed(HttpRequest<?> request) {
            int pos = this.integer.incrementAndGet();
            if (pos > this.len) {
                throw new IllegalStateException("The FilterChain.proceed(..) method should be invoked exactly once per filter execution. The method has instead been invoked multiple times by an erroneous filter definition.");
            }
            HttpFilter httpFilter = this.filters.get(pos);
            return httpFilter.doFilter(this.requestReference.getAndSet(request), (FilterChain)this);
        }
    }

    private static class LambdaContainerState
    implements MicronautLambdaContainerContext {
        private Router router;
        private ApplicationContext applicationContext;
        private JsonMediaTypeCodec jsonCodec;
        private ObjectMapper objectMapper;

        private LambdaContainerState() {
        }

        @Override
        public Router getRouter() {
            return this.router;
        }

        @Override
        public JsonMediaTypeCodec getJsonCodec() {
            return this.jsonCodec;
        }

        public ApplicationContext getApplicationContext() {
            return this.applicationContext;
        }

        @Override
        public ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }

        void setJsonCodec(JsonMediaTypeCodec jsonCodec) {
            this.jsonCodec = jsonCodec;
        }

        void setRouter(Router router) {
            this.router = router;
        }

        void setApplicationContext(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        void setObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }
    }
}

