/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws.proxy.security;

import com.amazonaws.serverless.proxy.model.ApiGatewayAuthorizerContext;
import com.amazonaws.serverless.proxy.model.CognitoAuthorizerClaims;
import io.micronaut.context.annotation.Requires;
import io.micronaut.function.aws.proxy.MicronautAwsProxyRequest;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.DefaultAuthentication;
import io.micronaut.security.filters.AuthenticationFetcher;
import io.reactivex.Flowable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
@Requires(classes={AuthenticationFetcher.class})
public class MicronautLambdaAuthenticationFetcher
implements AuthenticationFetcher {
    public static final String HEADER_OIDC_IDENTITY = "x-amzn-oidc-identity";
    private static final List<String> REGISTERED_CLAIMS_NAMES = Arrays.asList("iss", "sub", "exp", "nbf", "iat", "jti", "aud");
    private static final List<String> ID_TOKEN_STANDARD_CLAIMS_NAMES = Arrays.asList("name", "given_name", "family_name", "middle_name", "nickname", "preferred_username", "profile", "picture", "website", "email", "email_verified", "gender", "birthdate", "zoneinfo", "locale", "phone_number", "phone_number_verified", "address", "updated_at", "auth_time", "nonce", "acr", "amr", "azp");

    public Publisher<Authentication> fetchAuthentication(HttpRequest<?> request) {
        if (request instanceof MicronautAwsProxyRequest) {
            MicronautAwsProxyRequest awsProxyRequest = (MicronautAwsProxyRequest)request;
            ApiGatewayAuthorizerContext authorizer = awsProxyRequest.getAwsProxyRequest().getRequestContext().getAuthorizer();
            if (authorizer != null) {
                CognitoAuthorizerClaims claims = authorizer.getClaims();
                return Flowable.just((Object)new DefaultAuthentication(authorizer.getPrincipalId(), this.attributesOfClaims(claims)));
            }
            String v = (String)request.getHeaders().get((CharSequence)HEADER_OIDC_IDENTITY);
            if (v != null) {
                return Flowable.just((Object)new DefaultAuthentication(v, Collections.emptyMap()));
            }
        }
        return Flowable.empty();
    }

    protected Map<String, Object> attributesOfClaims(CognitoAuthorizerClaims claims) {
        if (claims == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("sub", claims.getSubject());
        attributes.put("aud", claims.getAudience());
        attributes.put("iss", claims.getIssuer());
        attributes.put("token_use", claims.getTokenUse());
        attributes.put("cognito:username", claims.getUsername());
        attributes.put("preferred_username", claims.getUsername());
        attributes.put("email", claims.getEmail());
        attributes.put("email_verified", claims.isEmailVerified());
        attributes.put("auth_time", claims.getAuthTime());
        attributes.put("iat", claims.getIssuedAt());
        attributes.put("exp", claims.getExpiration());
        for (String claim : Stream.concat(ID_TOKEN_STANDARD_CLAIMS_NAMES.stream(), REGISTERED_CLAIMS_NAMES.stream()).collect(Collectors.toList())) {
            String value = claims.getClaim(claim);
            if (value == null) continue;
            attributes.putIfAbsent(claim, value);
        }
        return Collections.unmodifiableMap(attributes);
    }
}

