/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws;

import com.amazonaws.services.lambda.runtime.ClientContext;
import com.amazonaws.services.lambda.runtime.CognitoIdentity;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.function.aws.MicronautLambdaContext;
import io.micronaut.function.executor.AbstractFunctionExecutor;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.MDC;

public abstract class MicronautRequestHandler<I, O>
extends AbstractFunctionExecutor<I, O, Context>
implements RequestHandler<I, O>,
MicronautLambdaContext {
    public static final String ENV_X_AMZN_TRACE_ID = "_X_AMZN_TRACE_ID";
    public static final String MDC_DEFAULT_AWS_REQUEST_ID = "AWSRequestId";
    public static final String MDC_DEFAULT_FUNCTION_NAME = "AWSFunctionName";
    public static final String MDC_DEFAULT_FUNCTION_VERSION = "AWSFunctionVersion";
    public static final String MDC_DEFAULT_FUNCTION_ARN = "AWSFunctionArn";
    public static final String MDC_DEFAULT_FUNCTION_MEMORY_SIZE = "AWSFunctionMemoryLimit";
    public static final String MDC_DEFAULT_FUNCTION_REMAINING_TIME = "AWSFunctionRemainingTime";
    public static final String MDC_DEFAULT_XRAY_TRACE_ID = "AWS-XRAY-TRACE-ID";
    private final Class<I> inputType = this.initTypeArgument();

    public MicronautRequestHandler() {
        this.buildApplicationContext(null);
        this.applicationContext.inject((Object)this);
    }

    public final O handleRequest(I input, Context context) {
        if (context != null) {
            MicronautRequestHandler.registerContextBeans(context, this.applicationContext);
            this.populateMappingDiagnosticContextValues(context);
        }
        this.populateMappingDiagnosticContextWithXrayTraceId();
        if (!this.inputType.isInstance(input)) {
            input = this.convertInput(input);
        }
        return (O)this.execute(input);
    }

    protected void populateMappingDiagnosticContextValues(@NonNull Context context) {
        if (context.getAwsRequestId() != null) {
            this.mdcput(MDC_DEFAULT_AWS_REQUEST_ID, context.getAwsRequestId());
        }
        if (context.getFunctionName() != null) {
            this.mdcput(MDC_DEFAULT_FUNCTION_NAME, context.getFunctionName());
        }
        if (context.getFunctionVersion() != null) {
            this.mdcput(MDC_DEFAULT_FUNCTION_VERSION, context.getFunctionVersion());
        }
        if (context.getInvokedFunctionArn() != null) {
            this.mdcput(MDC_DEFAULT_FUNCTION_ARN, context.getInvokedFunctionArn());
        }
        this.mdcput(MDC_DEFAULT_FUNCTION_MEMORY_SIZE, String.valueOf(context.getMemoryLimitInMB()));
        this.mdcput(MDC_DEFAULT_FUNCTION_REMAINING_TIME, String.valueOf(context.getRemainingTimeInMillis()));
    }

    protected void mdcput(@NonNull String key, @NonNull String val) throws IllegalArgumentException {
        MDC.put((String)key, (String)val);
    }

    protected void populateMappingDiagnosticContextWithXrayTraceId() {
        MicronautRequestHandler.parseXrayTraceId().ifPresent(xrayTraceId -> this.mdcput(MDC_DEFAULT_XRAY_TRACE_ID, (String)xrayTraceId));
    }

    @NonNull
    protected static Optional<String> parseXrayTraceId() {
        String X_AMZN_TRACE_ID = System.getenv(ENV_X_AMZN_TRACE_ID);
        if (X_AMZN_TRACE_ID != null) {
            return Optional.of(X_AMZN_TRACE_ID.split(";")[0].replace("Root=", ""));
        }
        return Optional.empty();
    }

    protected I convertInput(Object input) {
        ArgumentConversionContext cc = ConversionContext.of(this.inputType);
        Optional converted = this.applicationContext.getConversionService().convert(input, cc);
        return (I)converted.orElseThrow(() -> new IllegalArgumentException("Unconvertible input: " + input, cc.getLastError().map(ConversionError::getCause).orElse(null)));
    }

    protected ApplicationContext buildApplicationContext(Context context) {
        this.applicationContext = super.buildApplicationContext((Object)context);
        this.startEnvironment(this.applicationContext);
        return this.applicationContext;
    }

    @Nonnull
    protected ApplicationContextBuilder newApplicationContextBuilder() {
        return super.newApplicationContextBuilder().environments(new String[]{"lambda"}).eagerInitSingletons(true).eagerInitConfiguration(true);
    }

    static void registerContextBeans(Context context, ApplicationContext applicationContext) {
        CognitoIdentity identity;
        ClientContext clientContext;
        applicationContext.registerSingleton((Object)context);
        LambdaLogger logger = context.getLogger();
        if (logger != null) {
            applicationContext.registerSingleton((Object)logger);
        }
        if ((clientContext = context.getClientContext()) != null) {
            applicationContext.registerSingleton((Object)clientContext);
        }
        if ((identity = context.getIdentity()) != null) {
            applicationContext.registerSingleton((Object)identity);
        }
    }

    private Class initTypeArgument() {
        Object[] args = GenericTypeUtils.resolveSuperTypeGenericArguments(this.getClass(), MicronautRequestHandler.class);
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            return args[0];
        }
        return Object.class;
    }
}

