/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.generator;

import io.micronaut.core.annotation.Internal;
import io.micronaut.jsonschema.generator.SourceGenerator;
import io.micronaut.jsonschema.generator.loaders.UrlLoader;
import io.micronaut.jsonschema.generator.utils.SourceGeneratorConfig;
import io.micronaut.jsonschema.generator.utils.SourceGeneratorConfigBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

@Internal
public class GeneratorMain {
    public static void main(String[] args) throws IOException {
        if (args.length != 8) {
            throw new IllegalStateException("Invalid number of arguments.");
        }
        String jsonURL = args[0];
        File jsonFile = null;
        if (!args[1].isBlank()) {
            jsonFile = new File(args[1].substring(5));
        }
        Path inputFolder = null;
        if (!args[2].isBlank()) {
            inputFolder = Paths.get(args[2], new String[0]);
        }
        String lang = args[3].toUpperCase();
        Path outputPath = Paths.get(args[4], new String[0]);
        String outputPackageName = args[5];
        String outputFileName = args[6];
        SourceGeneratorConfig config = new SourceGeneratorConfigBuilder().withJsonUrl(jsonURL).withJsonFile(jsonFile).withInputFolder(inputFolder).withOutputFolder(outputPath).withOutputPackageName(outputPackageName).withOutputFileName(outputFileName).build();
        List<String> allowedUrlPatterns = GeneratorMain.parseListOfAllowedUrlPatterns(args[7]);
        if (!allowedUrlPatterns.isEmpty()) {
            UrlLoader.addAllowedUrlPatterns(allowedUrlPatterns);
        }
        SourceGenerator generator = new SourceGenerator(lang);
        generator.generate(config);
    }

    private static List<String> parseListOfAllowedUrlPatterns(String input) {
        if ((input = input.trim()).startsWith("[") && input.endsWith("]")) {
            input = input.substring(1, input.length() - 1).trim();
        }
        if (input.isEmpty()) {
            return List.of();
        }
        String[] elements = input.split("\\s*,\\s*");
        return List.of(elements);
    }
}

