/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.chain;

import io.micronaut.aop.Adapter;
import io.micronaut.aop.Around;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.InterceptorRegistry;
import io.micronaut.aop.Introduction;
import io.micronaut.aop.InvocationContext;
import io.micronaut.aop.chain.AbstractInterceptorChain;
import io.micronaut.aop.chain.AdapterIntroduction;
import io.micronaut.aop.exceptions.UnimplementedAdviceException;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.annotation.EvaluatedAnnotationMetadata;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

@Internal
public class InterceptorChain<B, R>
extends AbstractInterceptorChain<B, R>
implements InvocationContext<B, R> {
    protected final B target;
    protected final ExecutableMethod<B, R> executionHandle;
    private final AnnotationMetadata annotationMetadata;

    public InterceptorChain(Interceptor<B, R>[] interceptors, B target, ExecutableMethod<B, R> method, Object ... originalParameters) {
        super(interceptors, originalParameters);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Intercepted method [{}] invocation on target: {}", method, target);
        }
        this.target = target;
        this.executionHandle = method;
        AnnotationMetadata metadata = this.executionHandle.getAnnotationMetadata();
        if (metadata instanceof EvaluatedAnnotationMetadata) {
            EvaluatedAnnotationMetadata eam = (EvaluatedAnnotationMetadata)metadata;
            this.annotationMetadata = eam.withArguments(target, originalParameters);
        } else {
            this.annotationMetadata = metadata;
        }
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    public Argument[] getArguments() {
        return this.executionHandle.getArguments();
    }

    public R invoke(B instance, Object ... arguments) {
        return this.proceed();
    }

    @Override
    public B getTarget() {
        return this.target;
    }

    @Override
    public R proceed() throws RuntimeException {
        if (this.interceptorCount == 0 || this.index == this.interceptorCount) {
            try {
                return (R)this.executionHandle.invoke(this.target, this.getParameterValues());
            }
            catch (AbstractMethodError e) {
                throw new UnimplementedAdviceException(this.executionHandle);
            }
        }
        Interceptor interceptor = this.interceptors[this.index++];
        if (LOG.isTraceEnabled()) {
            LOG.trace("Proceeded to next interceptor [{}] in chain for method invocation: {}", (Object)interceptor, this.executionHandle);
        }
        return interceptor.intercept(this);
    }

    @Internal
    public static <T> Interceptor<T, ?>[] resolveAroundInterceptors(BeanContext beanContext, ExecutableMethod<T, ?> method, List<BeanRegistration<Interceptor<T, ?>>> interceptors) {
        return InterceptorChain.resolveInterceptors(beanContext, method, interceptors, InterceptorKind.AROUND);
    }

    @Internal
    public static <T> Interceptor<T, ?>[] resolveAroundInterceptors(InterceptorRegistry interceptorRegistry, ExecutableMethod<T, ?> method, List<BeanRegistration<Interceptor<T, ?>>> interceptors) {
        return InterceptorChain.resolveInterceptors(interceptorRegistry, method, interceptors, InterceptorKind.AROUND);
    }

    @Internal
    public static <T> Interceptor<T, ?>[] resolveIntroductionInterceptors(BeanContext beanContext, ExecutableMethod<T, ?> method, List<BeanRegistration<Interceptor<T, ?>>> interceptors) {
        Object[] introductionInterceptors = InterceptorChain.resolveInterceptors(beanContext, method, interceptors, InterceptorKind.INTRODUCTION);
        Object[] aroundInterceptors = InterceptorChain.resolveInterceptors(beanContext, method, interceptors, InterceptorKind.AROUND);
        return (Interceptor[])ArrayUtils.concat((Object[])aroundInterceptors, (Object[])introductionInterceptors);
    }

    @Internal
    public static <T> Interceptor<T, ?>[] resolveIntroductionInterceptors(InterceptorRegistry interceptorRegistry, ExecutableMethod<T, ?> method, List<BeanRegistration<Interceptor<T, ?>>> interceptors) {
        Object[] introductionInterceptors = InterceptorChain.resolveInterceptors(interceptorRegistry, method, interceptors, InterceptorKind.INTRODUCTION);
        Object[] aroundInterceptors = InterceptorChain.resolveInterceptors(interceptorRegistry, method, interceptors, InterceptorKind.AROUND);
        return (Interceptor[])ArrayUtils.concat((Object[])aroundInterceptors, (Object[])introductionInterceptors);
    }

    @Internal
    @Deprecated
    public static Interceptor[] resolveAroundInterceptors(@Nullable BeanContext beanContext, ExecutableMethod<?, ?> method, Interceptor ... interceptors) {
        InterceptorChain.instrumentAnnotationMetadata(beanContext, method);
        return InterceptorChain.resolveInterceptorsInternal(method, Around.class, interceptors, beanContext != null ? beanContext.getClassLoader() : InterceptorChain.class.getClassLoader());
    }

    @Internal
    @Deprecated
    public static Interceptor[] resolveIntroductionInterceptors(@Nullable BeanContext beanContext, ExecutableMethod<?, ?> method, Interceptor ... interceptors) {
        InterceptorChain.instrumentAnnotationMetadata(beanContext, method);
        Object[] introductionInterceptors = InterceptorChain.resolveInterceptorsInternal(method, Introduction.class, interceptors, beanContext != null ? beanContext.getClassLoader() : InterceptorChain.class.getClassLoader());
        if (introductionInterceptors.length == 0) {
            if (method.hasStereotype(Adapter.class)) {
                introductionInterceptors = new Interceptor[]{new AdapterIntroduction(beanContext, method)};
            } else {
                throw new IllegalStateException("At least one @Introduction method interceptor required, but missing. Check if your @Introduction stereotype annotation is marked with @Retention(RUNTIME) and @Type(..) with the interceptor type. Otherwise do not load @Introduction beans if their interceptor definitions are missing!");
            }
        }
        Object[] aroundInterceptors = InterceptorChain.resolveAroundInterceptors(beanContext, method, interceptors);
        return (Interceptor[])ArrayUtils.concat((Object[])aroundInterceptors, (Object[])introductionInterceptors);
    }

    @NonNull
    private static <T> Interceptor<T, ?>[] resolveInterceptors(BeanContext beanContext, ExecutableMethod<T, ?> method, List<BeanRegistration<Interceptor<T, ?>>> interceptors, InterceptorKind interceptorKind) {
        return InterceptorChain.resolveInterceptors((InterceptorRegistry)beanContext.getBean(InterceptorRegistry.class), method, interceptors, interceptorKind);
    }

    @NonNull
    private static <T> Interceptor<T, ?>[] resolveInterceptors(InterceptorRegistry interceptorRegistry, ExecutableMethod<T, ?> method, List<BeanRegistration<Interceptor<T, ?>>> interceptors, InterceptorKind interceptorKind) {
        return interceptorRegistry.resolveInterceptors(method, interceptors, interceptorKind);
    }

    private static void instrumentAnnotationMetadata(BeanContext beanContext, ExecutableMethod<?, ?> method) {
        if (beanContext instanceof ApplicationContext) {
            EnvironmentConfigurable m;
            ApplicationContext context = (ApplicationContext)beanContext;
            if (method instanceof EnvironmentConfigurable && (m = (EnvironmentConfigurable)method).hasPropertyExpressions()) {
                m.configure(context.getEnvironment());
            }
        }
    }

    private static <T> Interceptor<T, ?>[] resolveInterceptorsInternal(ExecutableMethod<?, ?> method, Class<? extends Annotation> annotationType, Interceptor<T, ?>[] interceptors, @NonNull ClassLoader classLoader) {
        List annotations = method.getAnnotationTypesByStereotype(annotationType, classLoader);
        HashSet<Class> applicableClasses = new HashSet<Class>();
        for (Class aClass : annotations) {
            Type typeAnn;
            if (annotationType == Around.class && aClass.getAnnotation(Around.class) == null && aClass.getAnnotation(Introduction.class) != null || annotationType == Introduction.class && aClass.getAnnotation(Introduction.class) == null && aClass.getAnnotation(Around.class) != null || (typeAnn = aClass.getAnnotation(Type.class)) == null) continue;
            applicableClasses.addAll(Arrays.asList(typeAnn.value()));
        }
        Ordered[] interceptorArray = (Interceptor[])Arrays.stream(interceptors).filter(i -> applicableClasses.stream().anyMatch(t -> t.isInstance(i))).toArray(Interceptor[]::new);
        OrderUtil.sort((Ordered[])interceptorArray);
        return interceptorArray;
    }
}

