/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind.binders;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.AbstractArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.format.Format;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.http.BasicHttpAttributes;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.uri.UriMatchVariable;
import java.util.Collections;
import java.util.Optional;

public class QueryValueArgumentBinder<T>
extends AbstractArgumentBinder<T>
implements AnnotatedRequestArgumentBinder<QueryValue, T> {
    public QueryValueArgumentBinder(ConversionService conversionService) {
        super(conversionService);
    }

    public QueryValueArgumentBinder(ConversionService conversionService, Argument<T> argument) {
        super(conversionService, argument);
    }

    @Override
    public RequestArgumentBinder<T> createSpecific(Argument<T> argument) {
        return new QueryValueArgumentBinder<T>(this.conversionService, argument);
    }

    public Class<QueryValue> getAnnotationType() {
        return QueryValue.class;
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        HttpParameters parameters = source.getParameters();
        Argument argument = context.getArgument();
        AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
        if (source.getMethod().permitsRequestBody() && !annotationMetadata.hasAnnotation(QueryValue.class)) {
            return ArgumentBinder.BindingResult.unsatisfied();
        }
        Optional multiValueConversion = annotationMetadata.hasAnnotation(Format.class) ? this.conversionService.convert((Object)parameters, context) : Optional.empty();
        if (multiValueConversion.isPresent()) {
            return () -> multiValueConversion;
        }
        String parameterName = this.resolvedParameterName(argument);
        boolean bindAll = BasicHttpAttributes.getRouteMatchInfo(source).map(umi -> {
            UriMatchVariable uriMatchVariable = umi.getVariableMap().get(parameterName);
            return uriMatchVariable != null && uriMatchVariable.isExploded();
        }).orElse(false);
        if (bindAll) {
            Object value;
            if (Iterable.class.isAssignableFrom(argument.getType())) {
                value = this.doResolve(context, (ConvertibleValues)parameters);
                if (value == null) {
                    value = Collections.emptyList();
                }
            } else {
                value = parameters.asMap();
            }
            return this.doConvert(value, context);
        }
        return this.doBind(context, (ConvertibleValues)parameters, ArgumentBinder.BindingResult.unsatisfied());
    }

    protected String getParameterName(Argument<T> argument) {
        return argument.getAnnotationMetadata().stringValue(QueryValue.class).orElse(argument.getName());
    }
}

