/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import java.util.Objects;

@Internal
record FilterContext(@NonNull HttpRequest<?> request, @Nullable HttpResponse<?> response, @NonNull PropagatedContext propagatedContext) {
    FilterContext(HttpRequest<?> request, PropagatedContext propagatedContext) {
        this(request, null, propagatedContext);
    }

    FilterContext withRequest(@NonNull HttpRequest<?> request) {
        if (this.request == request) {
            return this;
        }
        if (this.response != null) {
            throw new IllegalStateException("Cannot modify the request after response is set!");
        }
        Objects.requireNonNull(request);
        return new FilterContext(request, this.response, this.propagatedContext);
    }

    FilterContext withResponse(@NonNull HttpResponse<?> response) {
        if (this.response == response) {
            return this;
        }
        Objects.requireNonNull(response);
        return new FilterContext(this.request, response, this.propagatedContext);
    }

    FilterContext withPropagatedContext(@NonNull PropagatedContext propagatedContext) {
        if (this.propagatedContext == propagatedContext) {
            return this;
        }
        Objects.requireNonNull(propagatedContext);
        return new FilterContext(this.request, this.response, propagatedContext);
    }
}

