/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.DefaultConditionContext;
import io.micronaut.context.RequiresCondition;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.Failure;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.BeanConfiguration;
import io.micronaut.inject.BeanContextConditional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
abstract class AbstractBeanContextConditional
implements BeanContextConditional,
AnnotationMetadataProvider {
    AbstractBeanContextConditional() {
    }

    @Override
    public boolean isEnabled(@NonNull BeanContext context, @Nullable BeanResolutionContext resolutionContext) {
        boolean enabled;
        AnnotationMetadata annotationMetadata = this.getAnnotationMetadata();
        RequiresCondition condition = annotationMetadata.hasStereotype(Requires.class) ? new RequiresCondition(annotationMetadata) : null;
        DefaultBeanContext defaultBeanContext = (DefaultBeanContext)context;
        DefaultConditionContext<AbstractBeanContextConditional> conditionContext = new DefaultConditionContext<AbstractBeanContextConditional>(defaultBeanContext, this, resolutionContext);
        boolean bl = enabled = condition == null || condition.matches(conditionContext);
        if (!enabled) {
            this.onFail(conditionContext, defaultBeanContext);
        }
        return enabled;
    }

    protected final void onFail(DefaultConditionContext<AbstractBeanContextConditional> conditionContext, DefaultBeanContext defaultBeanContext) {
        if (ConditionLog.LOG.isDebugEnabled()) {
            if (this instanceof BeanConfiguration) {
                ConditionLog.LOG.debug("{} will not be loaded due to failing conditions:", (Object)this);
            } else {
                ConditionLog.LOG.debug("Bean [{}] will not be loaded due to failing conditions:", (Object)this);
            }
            for (Failure failure : conditionContext.getFailures()) {
                ConditionLog.LOG.debug("* {}", (Object)failure.getMessage());
            }
        }
        defaultBeanContext.trackDisabledComponent(conditionContext);
    }

    static final class ConditionLog {
        static final Logger LOG = LoggerFactory.getLogger(Condition.class);

        private ConditionLog() {
        }
    }
}

