/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.inject.BeanConfiguration;
import java.util.Objects;
import java.util.function.Predicate;

record ConditionalBeanConfiguration(String packageName, Predicate<BeanContext> condition) implements BeanConfiguration
{
    ConditionalBeanConfiguration {
        Objects.requireNonNull(packageName, "Package cannot be null");
        Objects.requireNonNull(condition, "Condition cannot be null");
        if (packageName.startsWith("io.micronaut.")) {
            throw new ConfigurationException("Custom bean configurations cannot be added for internal Micronaut packages: " + packageName);
        }
    }

    @Override
    public Package getPackage() {
        throw new UnsupportedOperationException("Package not retrievable");
    }

    @Override
    public String getName() {
        return this.packageName;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean isEnabled(BeanContext context, BeanResolutionContext resolutionContext) {
        return this.condition.test(context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionalBeanConfiguration that = (ConditionalBeanConfiguration)o;
        return Objects.equals(this.packageName, that.packageName);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.packageName);
    }
}

