/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.FilteringQualifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@Internal
public class TypeAnnotationQualifier<T>
extends FilteringQualifier<T> {
    private final List<Class<?>> types;

    TypeAnnotationQualifier(Class<?> ... types) {
        if (types != null) {
            this.types = new ArrayList(types.length);
            for (Class<?> type : types) {
                Type typeAnn = type.getAnnotation(Type.class);
                if (typeAnn != null) {
                    this.types.addAll(Arrays.asList(typeAnn.value()));
                    continue;
                }
                this.types.add(type);
            }
        } else {
            this.types = Collections.emptyList();
        }
    }

    @Override
    public boolean doesQualify(Class<T> beanType, BeanType<T> candidate) {
        return this.areTypesCompatible(candidate.getBeanType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeAnnotationQualifier that = (TypeAnnotationQualifier)o;
        return this.types.equals(that.types);
    }

    public int hashCode() {
        return this.types.hashCode();
    }

    public String toString() {
        return "<" + this.types.stream().map(Class::getSimpleName).collect(Collectors.joining("|")) + ">";
    }

    private boolean areTypesCompatible(Class type) {
        return this.types.stream().anyMatch(c -> c.isAssignableFrom(type));
    }
}

