/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import io.micronaut.openapi.generator.UserParameterMode;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenModelFactory;
import org.openapitools.codegen.CodegenModelType;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    public static final List<String> DATE_TIME_TYPES = List.of("date", "Date", "DateTime", "LocalDateTime", "OffsetDateTime", "ZonedDateTime", "LocalDate", "LocalTime");
    public static final String DIVIDE_OPERATIONS_BY_CONTENT_TYPE = "divideOperationsByContentType";
    public static final String DEFAULT_BODY_PARAM_NAME = "requestBody";
    public static final String EXT_ANNOTATIONS_OPERATION = "x-operation-extra-annotation";
    public static final String EXT_ANNOTATIONS_CLASS = "x-class-extra-annotation";
    public static final String EXT_ANNOTATIONS_FIELD = "x-field-extra-annotation";
    public static final String EXT_ANNOTATIONS_SETTER = "x-setter-extra-annotation";
    public static final String NULL_STRING = "null";
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static Pair<CodegenParameter, Set<String>> processMultipartBody(CodegenOperation op, Collection<CodegenParameter> params, boolean isKotlin) {
        HashSet<String> removedParams = new HashSet<String>();
        CodegenParameter multipartBodyParam = null;
        Iterator<CodegenParameter> i = params.iterator();
        while (i.hasNext()) {
            CodegenParameter param = i.next();
            if (!param.isBodyParam || !param.vendorExtensions.containsKey("isPart")) continue;
            if (multipartBodyParam == null) {
                multipartBodyParam = (CodegenParameter)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.PARAMETER);
                multipartBodyParam.isBodyParam = true;
                multipartBodyParam.baseName = "multipartBody";
                multipartBodyParam.paramName = "multipartBody";
                multipartBodyParam.dataType = "MultipartBody";
                multipartBodyParam.baseType = "MultipartBody";
                multipartBodyParam.nameInCamelCase = "multipartBody";
                multipartBodyParam.nameInLowerCase = "multipartbody";
                multipartBodyParam.nameInPascalCase = "MultipartBody";
                multipartBodyParam.nameInSnakeCase = "MULTIPART_BODY";
                multipartBodyParam.vendorExtensions.put("typeWithGenericAnnotations", "MultipartBody" + (isKotlin ? "?" : ""));
                multipartBodyParam.vendorExtensions.put("typeWithEnumWithGenericAnnotations", "MultipartBody" + (isKotlin ? "?" : ""));
                op.imports.add("MultipartBody");
            }
            removedParams.add(param.paramName);
            i.remove();
        }
        if (multipartBodyParam != null) {
            params.add(multipartBodyParam);
        }
        return Pair.of(multipartBodyParam, removedParams);
    }

    public static void processGenericAnnotations(CodegenParameter parameter, boolean useBeanValidation, boolean isGenerateHardNullable, boolean isNullable, boolean isRequired, boolean isReadonly, boolean withNullablePostfix, boolean isKotlin, boolean ksp) {
        Map ext = parameter.vendorExtensions;
        if (!ext.containsKey("isPrimitiveArray")) {
            ext.put("isPrimitiveArray", Utils.isJavaPrimitiveArray(parameter.dataType) || Utils.isKotlinPrimitiveArray(parameter.dataType));
        }
        CodegenProperty items = parameter.isMap ? parameter.additionalProperties : parameter.items;
        String datatypeWithEnum = parameter.datatypeWithEnum == null ? parameter.dataType : parameter.datatypeWithEnum;
        Utils.processGenericAnnotations(parameter.dataType, datatypeWithEnum, parameter.isMap, parameter.containerTypeMapped, items, parameter.vendorExtensions, useBeanValidation, isGenerateHardNullable, isNullable, isRequired, isReadonly, withNullablePostfix, isKotlin, ksp);
        if (parameter.items != null) {
            Utils.processGenericAnnotations(parameter.items, useBeanValidation, isGenerateHardNullable, isNullable, isRequired, isReadonly, withNullablePostfix, isKotlin, ksp);
        }
    }

    public static void processGenericAnnotations(CodegenProperty property, boolean useBeanValidation, boolean isGenerateHardNullable, boolean isNullable, boolean isRequired, boolean isReadonly, boolean withNullablePostfix, boolean isKotlin, boolean ksp) {
        Map ext = property.vendorExtensions;
        if (!ext.containsKey("isPrimitiveArray")) {
            ext.put("isPrimitiveArray", Utils.isJavaPrimitiveArray(property.dataType) || Utils.isKotlinPrimitiveArray(property.dataType));
        }
        CodegenProperty items = property.isMap ? property.additionalProperties : property.items;
        String datatypeWithEnum = property.datatypeWithEnum == null ? property.dataType : property.datatypeWithEnum;
        Utils.processGenericAnnotations(property.dataType, datatypeWithEnum, property.isMap, property.containerTypeMapped, items, ext, useBeanValidation, isGenerateHardNullable, isNullable, isRequired, isReadonly, withNullablePostfix, isKotlin, ksp);
        if (property.items != null) {
            Utils.processGenericAnnotations(property.items, useBeanValidation, isGenerateHardNullable, isNullable, isRequired, isReadonly, withNullablePostfix, isKotlin, ksp);
        }
    }

    public static void processGenericAnnotations(String dataType, String dataTypeWithEnum, boolean isMap, String containerType, CodegenProperty itemsProp, Map<String, Object> ext, boolean useBeanValidation, boolean isGenerateHardNullable, boolean isNullable, boolean isRequired, boolean isReadonly, boolean withNullablePostfix, boolean isKotlin, boolean ksp) {
        boolean isNullableType;
        String genericAnnotations = null;
        dataType = Utils.addAnnotationsToPrimitiveArray(dataType, isNullable, isRequired, isReadonly, isGenerateHardNullable);
        dataTypeWithEnum = Utils.addAnnotationsToPrimitiveArray(dataTypeWithEnum, isNullable, isRequired, isReadonly, isGenerateHardNullable);
        Object typeWithGenericAnnotations = dataType;
        Object typeWithEnumWithGenericAnnotations = dataTypeWithEnum;
        if (useBeanValidation && itemsProp != null && dataType.contains("<")) {
            genericAnnotations = Utils.genericAnnotations(itemsProp, isGenerateHardNullable, isKotlin, ksp);
            Utils.processGenericAnnotations(itemsProp, useBeanValidation, isGenerateHardNullable, itemsProp.isNullable, itemsProp.required, itemsProp.isReadOnly, withNullablePostfix, isKotlin, ksp);
            if (isMap) {
                typeWithGenericAnnotations = "Map<String, " + genericAnnotations + String.valueOf(itemsProp.vendorExtensions.get("typeWithGenericAnnotations")) + ">";
                typeWithEnumWithGenericAnnotations = "Map<String, " + genericAnnotations + String.valueOf(itemsProp.vendorExtensions.get("typeWithEnumWithGenericAnnotations")) + ">";
            } else if (containerType != null) {
                typeWithGenericAnnotations = containerType + "<" + genericAnnotations + String.valueOf(itemsProp.vendorExtensions.get("typeWithGenericAnnotations")) + ">";
                typeWithEnumWithGenericAnnotations = containerType + "<" + genericAnnotations + String.valueOf(itemsProp.vendorExtensions.get("typeWithEnumWithGenericAnnotations")) + ">";
            }
        }
        boolean bl = isNullableType = withNullablePostfix && (isNullable || isRequired && isReadonly || genericAnnotations != null && !genericAnnotations.contains("NotNull") && !isRequired);
        if (ksp) {
            Boolean hasDefaultValue = (Boolean)ext.get("defaultValueIsNotNull");
            isNullableType = isNullableType && (hasDefaultValue == null || hasDefaultValue == false);
        }
        ext.put("typeWithGenericAnnotations", (String)typeWithGenericAnnotations + (isNullableType ? "?" : ""));
        ext.put("typeWithEnumWithGenericAnnotations", (String)typeWithEnumWithGenericAnnotations + (isNullableType ? "?" : ""));
    }

    private static String addAnnotationsToPrimitiveArray(String dataType, boolean isNullable, boolean isRequired, boolean isReadOnly, boolean isGenerateHardNullable) {
        if (!Utils.isJavaPrimitiveArray(dataType)) {
            return dataType;
        }
        String type = dataType.substring(0, dataType.indexOf(91));
        if (isNullable || !isRequired || isReadOnly) {
            if (isGenerateHardNullable) {
                return type + " @Nullable(inherited = true) []";
            }
            return type + " @Nullable []";
        }
        return type + " @NotNull []";
    }

    private static boolean isJavaPrimitiveArray(String dataType) {
        if (dataType == null) {
            return false;
        }
        return switch (dataType) {
            case "byte[]", "short[]", "int[]", "long[]", "boolean[]", "char[]", "float[]", "double[]" -> true;
            default -> false;
        };
    }

    private static boolean isKotlinPrimitiveArray(String dataType) {
        if (dataType == null) {
            return false;
        }
        return switch (dataType) {
            case "ByteArray", "ShortArray", "IntArray", "LongArray", "BooleanArray", "CharArray", "FloatArray", "DoubleArray" -> true;
            default -> false;
        };
    }

    private static String genericAnnotations(CodegenProperty prop, boolean isGenerateHardNullable, boolean isKotlin, boolean ksp) {
        String type = prop.openApiType == null ? null : prop.openApiType.toLowerCase();
        boolean isPrimitiveArray = Utils.isJavaPrimitiveArray(prop.dataType) || Utils.isKotlinPrimitiveArray(prop.dataType);
        StringBuilder result = new StringBuilder();
        if (prop.isModel) {
            result.append("@Valid ");
        }
        if (!Utils.isPrimitive(type)) {
            return result.toString();
        }
        String patternMsg = (String)prop.vendorExtensions.get("x-pattern-message");
        String sizeMsg = (String)prop.vendorExtensions.get("x-size-message");
        String notNullMsg = (String)prop.vendorExtensions.get("x-not-null-message");
        String minMsg = (String)prop.vendorExtensions.get("x-minimum-message");
        String maxMsg = (String)prop.vendorExtensions.get("x-maximum-message");
        if (isKotlin) {
            patternMsg = Utils.normalizeStr(patternMsg);
            sizeMsg = Utils.normalizeStr(sizeMsg);
            notNullMsg = Utils.normalizeStr(notNullMsg);
            minMsg = Utils.normalizeStr(minMsg);
            maxMsg = Utils.normalizeStr(maxMsg);
        }
        if (StringUtils.isNotEmpty((CharSequence)prop.pattern) && !prop.isDate && !prop.isDateTime) {
            if ("email".equals(type) || "email".equalsIgnoreCase(prop.dataFormat) || prop.isEmail) {
                result.append("@Email(regexp = \"");
            } else {
                result.append("@Pattern(regexp = \"");
            }
            result.append(prop.pattern).append("\"");
            if (patternMsg != null) {
                result.append(", message = \"").append(patternMsg).append("\"");
            }
            result.append(") ");
        }
        boolean containsNotEmpty = false;
        if (prop.minLength != null || prop.maxLength != null) {
            if (prop.minLength != null && prop.minLength == 1 && prop.maxLength == null && !prop.isNullable) {
                result.append("@NotEmpty");
                if (sizeMsg != null) {
                    result.append("(message = \"").append(sizeMsg).append("\")");
                }
                result.append(' ');
                containsNotEmpty = true;
            } else {
                result.append("@Size(");
                if (prop.minLength != null) {
                    result.append("min = ").append(prop.minLength);
                }
                if (prop.maxLength != null) {
                    if (prop.minLength != null) {
                        result.append(", ");
                    }
                    result.append("max = ").append(prop.maxLength);
                }
                if (sizeMsg != null) {
                    result.append(", message = \"").append(sizeMsg).append('\"');
                }
                result.append(") ");
            }
        }
        if (prop.minItems != null || prop.maxItems != null) {
            if (prop.minItems != null && prop.minItems == 1 && prop.maxItems == null && !prop.isNullable) {
                result.append("@NotEmpty ");
                containsNotEmpty = true;
            } else {
                result.append("@Size(");
                if (prop.minItems != null) {
                    result.append("min = ").append(prop.minItems);
                }
                if (prop.maxItems != null) {
                    if (prop.minItems != null) {
                        result.append(", ");
                    }
                    result.append("max = ").append(prop.maxItems);
                }
                if (sizeMsg != null) {
                    result.append(", message = \"").append(sizeMsg).append('\"');
                }
                result.append(") ");
            }
        }
        if (!isPrimitiveArray && !((Boolean)prop.vendorExtensions.get("isPrimitive")).booleanValue()) {
            if (prop.isNullable) {
                Boolean hasDefaultValue = (Boolean)prop.vendorExtensions.get("defaultValueIsNotNull");
                if (!ksp || hasDefaultValue == null || !hasDefaultValue.booleanValue()) {
                    if (isGenerateHardNullable) {
                        result.append("@Nullable(inherited = true) ");
                    } else {
                        result.append("@Nullable ");
                    }
                }
            } else if (!containsNotEmpty) {
                result.append("@NotNull");
                if (notNullMsg != null) {
                    result.append("(message = \"").append(notNullMsg).append("\")");
                }
                result.append(" ");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)prop.minimum)) {
            try {
                long longNumber = Long.parseLong(prop.minimum);
                if (prop.exclusiveMinimum) {
                    ++longNumber;
                }
                if (longNumber == 0L && StringUtils.isEmpty((CharSequence)prop.maximum)) {
                    result.append("@PositiveOrZero");
                    if (minMsg != null) {
                        result.append("(message = \"").append(minMsg).append("\")");
                    }
                    result.append(" ");
                } else if (longNumber == 1L && StringUtils.isEmpty((CharSequence)prop.maximum)) {
                    result.append("@Positive");
                    if (minMsg != null) {
                        result.append("(message = \"").append(minMsg).append("\")");
                    }
                    result.append(" ");
                } else {
                    result.append("@Min(");
                    if (!isKotlin && minMsg != null) {
                        result.append("value = ");
                    }
                    result.append(longNumber);
                    if (prop.isLong) {
                        result.append("L");
                    }
                    if (minMsg != null) {
                        result.append(", message = \"").append(minMsg).append("\"");
                    }
                    result.append(") ");
                }
            }
            catch (Exception e) {
                result.append("@DecimalMin(");
                if (!isKotlin && (prop.exclusiveMinimum || minMsg != null)) {
                    result.append("value = ");
                }
                result.append('\"').append(prop.minimum).append('\"');
                if (prop.exclusiveMinimum) {
                    result.append(", inclusive = false");
                }
                if (minMsg != null) {
                    result.append(", message = \"").append(minMsg).append("\"");
                }
                result.append(") ");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)prop.maximum)) {
            try {
                long longNumber = Long.parseLong(prop.maximum);
                if (prop.exclusiveMaximum) {
                    --longNumber;
                }
                if (longNumber == 0L && StringUtils.isEmpty((CharSequence)prop.minimum)) {
                    result.append("@NegativeOrZero");
                    if (maxMsg != null) {
                        result.append("(message = \"").append(maxMsg).append("\")");
                    }
                    result.append(" ");
                } else if (longNumber == -1L && StringUtils.isEmpty((CharSequence)prop.minimum)) {
                    result.append("@Negative");
                    if (maxMsg != null) {
                        result.append("(message = \"").append(maxMsg).append("\")");
                    }
                    result.append(" ");
                } else {
                    result.append("@Max(");
                    if (!isKotlin && maxMsg != null) {
                        result.append("value = ");
                    }
                    result.append(longNumber);
                    if (prop.isLong) {
                        result.append("L");
                    }
                    if (maxMsg != null) {
                        result.append(", message = \"").append(maxMsg).append("\"");
                    }
                    result.append(") ");
                }
            }
            catch (Exception e) {
                result.append("@DecimalMax(");
                if (!isKotlin && (prop.exclusiveMaximum || maxMsg != null)) {
                    result.append("value = ");
                }
                result.append('\"').append(prop.maximum).append('\"');
                if (prop.exclusiveMaximum) {
                    result.append(", inclusive = false");
                }
                if (maxMsg != null) {
                    result.append(", message = \"").append(maxMsg).append("\"");
                }
                result.append(") ");
            }
        }
        return result.toString();
    }

    private static boolean isPrimitive(String type) {
        if (type == null) {
            return false;
        }
        return switch (type) {
            case "array", "char", "character", "string", "boolean", "byte", "short", "int", "integer", "long", "uri", "url", "uuid", "email", "float", "double", "number", "partial-time", "date", "date-time", "bigdecimal", "decimal", "biginteger" -> true;
            default -> false;
        };
    }

    public static void addStrValueToEnum(CodegenProperty property) {
        if (property == null || !property.isEnum || property.allowableValues == null) {
            return;
        }
        List enumVars = (List)property.allowableValues.get("enumVars");
        Utils.addStrValueToEnum(enumVars, property.isNumeric);
    }

    public static void addStrValueToEnum(CodegenModel model) {
        if (model == null || !model.isEnum || model.allowableValues == null) {
            return;
        }
        List enumVars = (List)model.allowableValues.get("enumVars");
        Utils.addStrValueToEnum(enumVars, model.isNumeric);
    }

    public static void addStrValueToEnum(List<Object> enumVars, boolean isNumeric) {
        for (Object enumVar : enumVars) {
            Map varMap = (Map)enumVar;
            Object value = varMap.get("value").toString();
            if (((String)value).startsWith("(short)")) {
                value = ((String)value).replace("(short) ", "");
            } else if (((String)value).startsWith("(byte)")) {
                value = ((String)value).replace("(byte) ", "");
            }
            value = ((String)value).replace("'", "");
            if (isNumeric) {
                String upperValue;
                int argPos = ((String)value).indexOf(40);
                if (argPos >= 0) {
                    value = ((String)value).substring(argPos + 1, ((String)value).indexOf(41));
                }
                if ((upperValue = ((String)value).toUpperCase(Locale.ENGLISH)).endsWith("F") || upperValue.endsWith("L") || upperValue.endsWith("D")) {
                    value = ((String)value).substring(0, ((String)value).length() - 1);
                }
            }
            if (!((String)value).contains("\"")) {
                value = "\"" + (String)value + "\"";
            }
            varMap.put("strValue", value);
            varMap.put("strValueNormalized", Utils.normalizeStr((String)value));
        }
    }

    public static void normalizeStrValue(String key, Map<String, Object> exts) {
        if (exts.containsKey(key + "-alreadyNormalized")) {
            return;
        }
        Object value = exts.get(key);
        if (value == null) {
            return;
        }
        exts.put(key, Utils.normalizeStr(value.toString()));
        exts.put(key + "-alreadyNormalized", true);
    }

    public static String normalizeStr(String str) {
        if (str == null) {
            return null;
        }
        return str.replace("$", "\\$");
    }

    public static String toApiName(String name, String prefix, String suffix) {
        if (name.isEmpty()) {
            return "DefaultApi";
        }
        return prefix + name + suffix;
    }

    public static void normalizeExtraAnnotations(String extName, boolean isKotlin, Map<String, Object> vendorExtensions) {
        List<String> ext = vendorExtensions.get(extName);
        if (ext == null) {
            return;
        }
        String prefix = "@";
        if (isKotlin) {
            if (extName.equals(EXT_ANNOTATIONS_FIELD)) {
                prefix = "@field:";
            } else if (extName.equals(EXT_ANNOTATIONS_SETTER)) {
                prefix = "@set:";
            }
        }
        if (ext instanceof Collection) {
            Collection annotations = ext;
            ext = Utils.normalizeExtraAnnotations(prefix, annotations);
        } else if (ext instanceof String) {
            String annotationStr = (String)((Object)ext);
            ext = Utils.normalizeExtraAnnotation(prefix, annotationStr);
        }
        vendorExtensions.put(extName, ext);
    }

    private static List<String> normalizeExtraAnnotations(String prefix, Collection<?> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(annotations.size());
        for (Object annotation : annotations) {
            result.add(Utils.normalizeExtraAnnotation(prefix, annotation.toString()));
        }
        return result;
    }

    private static String normalizeExtraAnnotation(String prefix, String annotationStr) {
        if (annotationStr.startsWith(prefix)) {
            return annotationStr;
        }
        return prefix + (annotationStr.startsWith("@") ? annotationStr.substring(1) : annotationStr);
    }

    public static boolean isDateType(String type) {
        if (type == null) {
            return false;
        }
        return DATE_TIME_TYPES.contains(type);
    }

    public static List<String> readListOfStringsProperty(String property, Map<String, Object> additionalProperties) {
        Object value = additionalProperties.get(property);
        if (value == null) {
            return Collections.emptyList();
        }
        return Utils.readListOfStringsProperty(value);
    }

    public static List<String> readListOfStringsProperty(Object value) {
        ArrayList<String> parsedValues;
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Collection) {
            Collection valueCol = (Collection)value;
            parsedValues = new ArrayList<String>(valueCol.size());
            for (Object el : valueCol) {
                String str = el.toString().strip();
                if (str.isEmpty()) continue;
                parsedValues.add(str);
            }
        } else {
            String[] elements = value.toString().trim().split("\\s*(;|\\r?\\n)\\s*");
            parsedValues = new ArrayList(elements.length);
            for (String el : elements) {
                String str = el.strip();
                if (str.isEmpty()) continue;
                parsedValues.add(str);
            }
        }
        return parsedValues;
    }

    public static boolean readBooleanProperty(String propertyKey, Map<String, Object> additionalProperties, boolean defaultValue) {
        Object value = additionalProperties.get(propertyKey);
        if (value instanceof Boolean) {
            Boolean boolValue = (Boolean)value;
            return boolValue;
        }
        if (value instanceof String) {
            String strValue = (String)value;
            try {
                return Boolean.parseBoolean(strValue);
            }
            catch (NumberFormatException e) {
                LOG.warn("Can't parse generator's option {}. Value: {}", (Object)propertyKey, value);
                return defaultValue;
            }
        }
        LOG.warn("The value (generator's option {}) must be either boolean or string. Default to `{}`.", (Object)propertyKey, (Object)defaultValue);
        return defaultValue;
    }

    public static String calcQueryValueFormat(CodegenParameter param) {
        if (!(param.isArray || param.isMap || param.isFreeFormObject)) {
            return null;
        }
        if (!param.isQueryParam) {
            return null;
        }
        if (param.style == null || Parameter.StyleEnum.FORM.toString().equalsIgnoreCase(param.style)) {
            return param.isExplode ? "FORMAT_MULTI" : null;
        }
        if (Parameter.StyleEnum.SPACEDELIMITED.toString().equalsIgnoreCase(param.style)) {
            return "FORMAT_SSV";
        }
        if (Parameter.StyleEnum.PIPEDELIMITED.toString().equalsIgnoreCase(param.style)) {
            return "FORMAT_PIPES";
        }
        if (Parameter.StyleEnum.DEEPOBJECT.toString().equalsIgnoreCase(param.style)) {
            return "FORMAT_DEEP_OBJECT";
        }
        return null;
    }

    public static void processDuplicateVars(List<CodegenProperty> vars) {
        HashMap<String, Integer> names = new HashMap<String, Integer>();
        for (CodegenProperty var : vars) {
            String varName = var.getName();
            if (names.containsKey(varName)) {
                names.put(varName, (Integer)names.get(varName) + 1);
                int index = (Integer)names.get(varName);
                var.setName(varName + index);
                var.nameInSnakeCase = var.nameInSnakeCase + "_" + index;
                continue;
            }
            names.put(varName, 1);
        }
    }

    public static void addEnumParamsForConverters(String modelPackage, CodegenParameter param, Map<String, Integer> converterCounters, List<CodegenParameter> enumParams, List<String> enumImports, boolean isKotlin) {
        String converterName = param.dataType;
        boolean alreadyAdded = false;
        for (CodegenParameter enumParam : enumParams) {
            if (!param.dataType.equals(enumParam.dataType)) continue;
            alreadyAdded = true;
            break;
        }
        if (alreadyAdded) {
            return;
        }
        String enumValueType = (String)param.vendorExtensions.get("enumValueType");
        if (enumValueType == null) {
            return;
        }
        boolean isNullable = param.vendorExtensions.containsKey("enumValueIsNullable");
        Integer counter = converterCounters.get(converterName);
        converterCounters.put(converterName, counter == null ? 0 : counter + 1);
        param.vendorExtensions.put("converterName", converterName + String.valueOf(counter != null ? counter : ""));
        String convertFun = (isNullable ? "Optional.ofNullable(" : "Optional.of(") + param.dataType + ".fromValue(" + (isKotlin ? Utils.getKotlinEnumConvertFun(enumValueType) : Utils.getJavaEnumConvertFun(enumValueType, enumImports)) + "))";
        param.vendorExtensions.put("convertFun", convertFun);
        param.vendorExtensions.put("convertToStrFun", isKotlin ? Utils.getKotlinEnumConvertToStrFun(enumValueType) : Utils.getJavaEnumConvertToStrFun(enumValueType));
        enumParams.add(param);
        enumImports.add(modelPackage + "." + param.dataType);
    }

    private static String getKotlinEnumConvertToStrFun(String type) {
        return "String".equals(type) ? "v.value" : "v.value.toString()";
    }

    private static String getJavaEnumConvertToStrFun(String type) {
        if ("String".equals(type)) {
            return "v.getValue()";
        }
        if ("char".equals(type) || "byte".equals(type) || "short".equals(type) || "int".equals(type) || "long".equals(type) || "float".equals(type) || "double".equals(type) || "boolean".equals(type)) {
            return "String.valueOf(v.getValue())";
        }
        return "v.getValue().toString()";
    }

    private static String getKotlinEnumConvertFun(String type) {
        if ("Char".equals(type)) {
            return "v[0]";
        }
        if ("Byte".equals(type)) {
            return "v.toByte()";
        }
        if ("Short".equals(type)) {
            return "v.toShort()";
        }
        if ("Int".equals(type)) {
            return "v.toInt()";
        }
        if ("Long".equals(type)) {
            return "v.toLong()";
        }
        if ("Float".equals(type)) {
            return "v.toFloat()";
        }
        if ("Double".equals(type)) {
            return "v.toDouble()";
        }
        if ("Boolean".equals(type)) {
            return "v.toBoolean()";
        }
        if ("BigDecimal".equals(type)) {
            return "v.toBigDecimal()";
        }
        if ("BigInteger".equals(type)) {
            return "v.toBigInteger()";
        }
        return "v";
    }

    private static String getJavaEnumConvertFun(String type, List<String> imports) {
        if ("Character".equals(type) || "char".equals(type)) {
            return "v.charAt(0)";
        }
        if ("Byte".equals(type) || "byte".equals(type)) {
            return "Byte.valueOf(v)";
        }
        if ("Short".equals(type) || "short".equals(type)) {
            return "Short.valueOf(v)";
        }
        if ("Integer".equals(type) || "int".equals(type)) {
            return "Integer.valueOf(v)";
        }
        if ("Long".equals(type) || "long".equals(type)) {
            return "Long.valueOf(v)";
        }
        if ("Float".equals(type) || "float".equals(type)) {
            return "Float.valueOf(v)";
        }
        if ("Double".equals(type) || "double".equals(type)) {
            return "Double.valueOf(v)";
        }
        if ("Boolean".equals(type) || "boolean".equals(type)) {
            return "Boolean.valueOf(v)";
        }
        if ("BigDecimal".equals(type)) {
            if (!imports.contains("java.math.BigDecimal")) {
                imports.add("java.math.BigDecimal");
            }
            return "new BigDecimal(v)";
        }
        if ("BigInteger".equals(type)) {
            if (!imports.contains("java.math.BigInteger")) {
                imports.add("java.math.BigInteger");
            }
            return "new BigInteger(v)";
        }
        return "v";
    }

    public static boolean addUserParameter(CodegenOperation op, UserParameterMode userParameterMode, boolean isAnonymous, boolean isDenyAll) {
        if (userParameterMode == UserParameterMode.NONE || isDenyAll) {
            return false;
        }
        CodegenParameter userParam = (CodegenParameter)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.PARAMETER);
        userParam.paramName = userParameterMode.getParamName();
        userParam.description = userParameterMode.getParamDescription();
        userParam.dataType = userParameterMode.getClassName();
        userParam.unescapedDescription = userParam.description;
        userParam.required = true;
        if (!isAnonymous) {
            userParam.vendorExtensions.put("withoutNullable", true);
        } else {
            userParam.isNullable = true;
            userParam.vendorExtensions.put("defaultValueInit", NULL_STRING);
        }
        op.allParams.add(userParam);
        return true;
    }
}

