/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DemuxingObjectDecoder;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.DeserBeanSubtypeInfo;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

@Internal
final class SubtypedDeductionDeserializer
implements Deserializer<Object> {
    private final DeserBean<? super Object> deserBean;
    private final Map<String, Deserializer<Object>> deserializers;

    SubtypedDeductionDeserializer(DeserBean<? super Object> deserBean, Map<String, Deserializer<Object>> deserializers) {
        this.deserBean = deserBean;
        this.deserializers = deserializers;
        SerdeConfig.SerSubtyped.DiscriminatorType discriminatorType = deserBean.subtypeInfo.info().discriminatorType();
        if (discriminatorType != SerdeConfig.SerSubtyped.DiscriminatorType.PROPERTY && discriminatorType != SerdeConfig.SerSubtyped.DiscriminatorType.EXISTING_PROPERTY) {
            throw new IllegalStateException("Unsupported discriminator type: " + String.valueOf(discriminatorType));
        }
    }

    public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws IOException {
        try (DemuxingObjectDecoder.PrimedDecoder primed = DemuxingObjectDecoder.prime(decoder);){
            DemuxingObjectDecoder typeFinder = primed.decodeObjectNonConsuming(type);
            Deserializer<Object> deserializer = this.findDeserializer((Decoder)typeFinder);
            typeFinder.finishStructure(true);
            Object object = deserializer.deserialize((Decoder)primed, decoderContext, type);
            return object;
        }
    }

    @NonNull
    private Deserializer<Object> findDeserializer(Decoder objectDecoder) throws IOException {
        LinkedHashMap subtypes = new LinkedHashMap(this.deserBean.subtypeInfo.subtypes());
        while (true) {
            String key;
            if (subtypes.size() == 1) {
                return this.deserializers.get(subtypes.keySet().iterator().next());
            }
            if (subtypes.isEmpty() || (key = objectDecoder.decodeKey()) == null) break;
            Iterator iterator = subtypes.entrySet().iterator();
            while (iterator.hasNext()) {
                DeserBean subtype = ((DeserBeanSubtypeInfo.SubtypeDef)iterator.next().getValue()).deserBean();
                if (subtype.injectProperties != null && subtype.injectProperties.propertyIndexOf(key) != -1 || subtype.creatorParams != null && subtype.creatorParams.propertyIndexOf(key) != -1) continue;
                iterator.remove();
            }
            objectDecoder.skipValue();
        }
        throw new SerdeException("Cannot deduct the subtype for bean " + this.deserBean.introspection.getBeanType().getName());
    }
}

