/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.bind;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.json.bind.JsonBeanPropertyBinderExceptionHandler;
import io.micronaut.serde.exceptions.InvalidFormatException;
import io.micronaut.serde.exceptions.InvalidPropertyFormatException;
import jakarta.inject.Singleton;
import java.util.Optional;

@Singleton
@Internal
public class SerdeJsonBeanPropertyBinderExceptionHandler
implements JsonBeanPropertyBinderExceptionHandler {
    public Optional<ConversionErrorException> toConversionError(Object object, Exception e) {
        if (e instanceof InvalidFormatException) {
            Argument argument;
            InvalidFormatException ife = (InvalidFormatException)((Object)e);
            if (ife instanceof InvalidPropertyFormatException) {
                argument = ((InvalidPropertyFormatException)ife).getArgument();
            } else {
                Class type = object != null ? object.getClass() : Object.class;
                argument = Argument.of(type);
            }
            return Optional.of(new ConversionErrorException(argument, ife.toConversionError()));
        }
        return Optional.empty();
    }
}

