/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.UpdatingDeserializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.InvalidFormatException;
import io.micronaut.serde.exceptions.InvalidPropertyFormatException;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.exceptions.path.ReferencePath;
import io.micronaut.serde.reference.PropertyReference;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.DeserBeanSubtypeInfo;
import io.micronaut.serde.support.deserializers.PropertiesBag;
import io.micronaut.serde.support.deserializers.SerdeDeserializationPreInstantiateCallback;
import io.micronaut.serde.support.deserializers.SubtypedExternalPropertyObjectDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@Internal
final class SpecificObjectDeserializer
implements UpdatingDeserializer<Object> {
    private static final String PREFIX_UNABLE_TO_DESERIALIZE_TYPE = "Unable to deserialize type [";
    private final Conf conf;
    private final DeserBean<? super Object> deserBean;

    public SpecificObjectDeserializer(boolean strictNullable, DeserBean<? super Object> deserBean, @Nullable SerdeDeserializationPreInstantiateCallback preInstantiateCallback) {
        this(deserBean, new Conf(strictNullable, preInstantiateCallback));
    }

    SpecificObjectDeserializer(DeserBean<? super Object> deserBean, Conf conf) {
        this.deserBean = deserBean;
        this.conf = conf;
    }

    public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws IOException {
        BeanDeserializer deserializer = SpecificObjectDeserializer.newBeanDeserializer(null, this.deserBean, this.conf, false);
        deserializer.init(decoderContext);
        if (this.deserBean.externalProperties == null) {
            return this.deserialize(decoder, decoderContext, type, deserializer);
        }
        return this.deserializeAwaitForExternalProperties(decoder, decoderContext, type, deserializer);
    }

    public Object deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Object> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type);
    }

    public void deserializeInto(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type, Object value) throws IOException {
        BeanDeserializer deserializer = SpecificObjectDeserializer.newBeanDeserializer(value, this.deserBean, this.conf, false);
        deserializer.init(decoderContext);
        if (this.deserBean.externalProperties == null) {
            this.deserialize(decoder, decoderContext, type, deserializer);
        } else {
            this.deserializeAwaitForExternalProperties(decoder, decoderContext, type, deserializer);
        }
    }

    private Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type, BeanDeserializer beanDeserializer) throws IOException {
        String propertyName;
        boolean completed;
        Object instance;
        Decoder objectDecoder;
        block9: {
            objectDecoder = decoder.decodeObject(type);
            instance = null;
            completed = false;
            while (true) {
                if ((propertyName = objectDecoder.decodeKey()) == null) {
                    completed = true;
                    break block9;
                }
                if (this.deserBean.ignoredProperties != null && this.deserBean.ignoredProperties.contains(propertyName)) {
                    objectDecoder.skipValue();
                    continue;
                }
                boolean consumed = beanDeserializer.tryConsume(propertyName, objectDecoder, decoderContext, type);
                if (!consumed) {
                    SpecificObjectDeserializer.handleUnexpectedProperty(objectDecoder, propertyName, this.deserBean);
                }
                if (beanDeserializer.isAllConsumed()) break;
            }
            instance = beanDeserializer.provideInstance(type, decoderContext, false);
        }
        if (instance == null) {
            instance = beanDeserializer.provideInstance(type, decoderContext, false);
        }
        if (this.deserBean.ignoreUnknown) {
            objectDecoder.finishStructure(true);
        } else {
            if (!completed) {
                propertyName = objectDecoder.decodeKey();
                while (propertyName != null) {
                    SpecificObjectDeserializer.handleUnexpectedProperty(objectDecoder, propertyName, this.deserBean);
                    propertyName = objectDecoder.decodeKey();
                }
            }
            objectDecoder.finishStructure();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    private Object deserializeAwaitForExternalProperties(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type, BeanDeserializer beanDeserializer) throws IOException {
        HashSet<String> missingExternalProperties = this.deserBean.externalProperties == null ? Set.of() : new HashSet<String>(this.deserBean.externalProperties);
        ArrayList<PropertyReference<Object, String>> references = new ArrayList<PropertyReference<Object, String>>(missingExternalProperties.size());
        HashMap<String, Decoder> cache = new HashMap<String, Decoder>();
        Decoder rootObjectDecoder = decoder.decodeObject(type);
        try {
            boolean completed;
            Object instance;
            block19: {
                instance = null;
                completed = false;
                Iterator cacheIterator = null;
                while (true) {
                    boolean consumed;
                    String propertyName;
                    Decoder objectDecoder = rootObjectDecoder;
                    if (cacheIterator == null || !cacheIterator.hasNext()) {
                        propertyName = objectDecoder.decodeKey();
                        if (propertyName == null) {
                            completed = true;
                            break block19;
                        }
                        if (this.deserBean.ignoredProperties != null && this.deserBean.ignoredProperties.contains(propertyName)) {
                            objectDecoder.skipValue();
                            continue;
                        }
                        if (!missingExternalProperties.isEmpty()) {
                            if (missingExternalProperties.remove(propertyName)) {
                                String externalPropertyValue;
                                if (this.deserBean.subtypeInfo != null && this.deserBean.subtypeInfo.info().discriminatorVisible()) {
                                    Decoder cachedBuffer = decoder.decodeBuffer();
                                    cache.put(propertyName, cachedBuffer);
                                    externalPropertyValue = cachedBuffer.decodeString();
                                } else {
                                    externalPropertyValue = objectDecoder.decodeString();
                                }
                                PropertyReference<Object, String> reference = SubtypedExternalPropertyObjectDeserializer.createExternalPropertyReference(decoderContext, propertyName, externalPropertyValue);
                                decoderContext.pushManagedRef(reference);
                                references.add(reference);
                                if (!missingExternalProperties.isEmpty()) continue;
                                cacheIterator = cache.entrySet().iterator();
                                continue;
                            }
                            cache.put(propertyName, decoder.decodeBuffer());
                            continue;
                        }
                    } else {
                        Map.Entry entry = (Map.Entry)cacheIterator.next();
                        propertyName = (String)entry.getKey();
                        objectDecoder = (Decoder)entry.getValue();
                    }
                    if (!(consumed = beanDeserializer.tryConsume(propertyName, objectDecoder, decoderContext, type))) {
                        SpecificObjectDeserializer.handleUnexpectedProperty(objectDecoder, propertyName, this.deserBean);
                    }
                    if (beanDeserializer.isAllConsumed()) break;
                }
                instance = beanDeserializer.provideInstance(type, decoderContext, false);
            }
            if (instance == null) {
                instance = beanDeserializer.provideInstance(type, decoderContext, false);
            }
            if (this.deserBean.ignoreUnknown) {
                rootObjectDecoder.finishStructure(true);
            } else {
                if (this.deserBean.ignoredProperties != null && !completed) {
                    String key = rootObjectDecoder.decodeKey();
                    while (key != null) {
                        SpecificObjectDeserializer.handleUnexpectedProperty(rootObjectDecoder, key, this.deserBean);
                        key = rootObjectDecoder.decodeKey();
                    }
                }
                rootObjectDecoder.finishStructure();
            }
            Object object = instance;
            return object;
        }
        finally {
            for (PropertyReference reference : references) {
                decoderContext.pushManagedRef(reference);
            }
        }
    }

    private static void handleUnexpectedProperty(Decoder objectDecoder, String propertyName, DeserBean<?> deserBean) throws IOException {
        if (!(deserBean.ignoreUnknown || deserBean.ignoredProperties != null && deserBean.ignoredProperties.contains(propertyName))) {
            Class beanType = deserBean.introspection.getBeanType();
            if (deserBean.injectProperties != null && deserBean.injectProperties.newConsumer().contains(propertyName) || deserBean.creatorParams != null && deserBean.creatorParams.newConsumer().contains(propertyName)) {
                throw SpecificObjectDeserializer.duplicateProperty(propertyName, beanType);
            }
            throw SpecificObjectDeserializer.unknownProperty(propertyName, deserBean.introspection.asArgument());
        }
        objectDecoder.skipValue();
    }

    private static SerdeException duplicateProperty(String propertyName, Class<?> beanType) {
        SerdeException serdeException = new SerdeException("Duplicate property [" + propertyName + "] encountered during deserialization of type: " + String.valueOf(beanType));
        serdeException.getPath().add(ReferencePath.ofProperty(beanType, (Argument)Argument.OBJECT_ARGUMENT.withName(propertyName)));
        return serdeException;
    }

    private static SerdeException unknownProperty(String propertyName, Argument<?> beanType) {
        SerdeException serdeException = new SerdeException("Unknown property [" + propertyName + "] encountered during deserialization of type: " + String.valueOf(beanType));
        serdeException.getPath().add(ReferencePath.ofProperty((Class)beanType.getType(), (Argument)Argument.OBJECT_ARGUMENT.withName(propertyName)));
        return serdeException;
    }

    private static BeanDeserializer newBeanDeserializer(Object instance, DeserBean<? super Object> db, Conf conf, boolean allowSubtype) {
        if (db.hasBuilder) {
            return new BuilderDeserializer(db, conf);
        }
        if (allowSubtype && db.subtypeInfo != null) {
            if (db.subtypeInfo.info().deduct()) {
                return new SubtypedDeductionBeanDeserializer(db.subtypeInfo, conf);
            }
            SerdeConfig.SerSubtyped.DiscriminatorType discriminatorType = db.subtypeInfo.info().discriminatorType();
            return switch (discriminatorType) {
                case SerdeConfig.SerSubtyped.DiscriminatorType.PROPERTY, SerdeConfig.SerSubtyped.DiscriminatorType.EXISTING_PROPERTY -> new SubtypedPropertyBeanDeserializer(db.subtypeInfo, conf);
                case SerdeConfig.SerSubtyped.DiscriminatorType.WRAPPER_OBJECT -> new SubtypedWrapperBeanDeserializer(db, conf);
                default -> throw new IllegalStateException(String.valueOf(discriminatorType) + " not supported in this scenario!");
            };
        }
        if (db.creatorParams != null) {
            return new ArgsConstructorBeanDeserializer(db, conf);
        }
        return new NoArgsConstructorDeserializer(instance, db, conf);
    }

    private static void deserializeAndSetPropertyValue(Deserializer.DecoderContext decoderContext, Decoder objectDecoder, DeserBean.DerProperty<Object, Object> derProperty, Argument<? super Object> objectArgument, @NonNull Object instance) throws IOException {
        boolean hasRef = derProperty.managedRef != null;
        try {
            if (hasRef) {
                decoderContext.pushManagedRef(new PropertyReference(derProperty.managedRef, derProperty.introspection, derProperty.argument, instance));
            }
            Object deserializer = derProperty.deserializer;
            if (derProperty.unresolvedTypeVariableName != null) {
                deserializer = SpecificObjectDeserializer.findTypeVariableDeserializer(decoderContext, objectArgument, derProperty, deserializer);
            }
            derProperty.deserializeAndSetPropertyValue((Deserializer<Object>)deserializer, objectDecoder, decoderContext, instance);
        }
        catch (InvalidFormatException e) {
            throw new InvalidPropertyFormatException(e, derProperty.argument);
        }
        finally {
            if (hasRef) {
                decoderContext.popManagedRef();
            }
        }
    }

    private static Deserializer<Object> findTypeVariableDeserializer(Deserializer.DecoderContext decoderContext, Argument<? super Object> objectArgument, DeserBean.DerProperty<Object, Object> property, Deserializer<Object> deserializer) throws SerdeException {
        Argument typeArgument = (Argument)objectArgument.getTypeVariables().get(property.unresolvedTypeVariableName);
        if (typeArgument != null) {
            Deserializer genericDeserializer;
            deserializer = genericDeserializer = decoderContext.findDeserializer(typeArgument).createSpecific(decoderContext, typeArgument);
        }
        return deserializer;
    }

    private record Conf(boolean strictNullable, @Nullable SerdeDeserializationPreInstantiateCallback preInstantiateCallback) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class BeanDeserializer {
        private BeanDeserializer() {
        }

        abstract boolean tryConsume(String var1, Decoder var2, Deserializer.DecoderContext var3, Argument<? super Object> var4) throws IOException;

        abstract boolean isAllConsumed();

        abstract void init(Deserializer.DecoderContext var1) throws SerdeException;

        @Nullable
        abstract Object provideInstance(Argument<? super Object> var1, Deserializer.DecoderContext var2, boolean var3) throws IOException;
    }

    private static final class BuilderDeserializer
    extends BeanDeserializer {
        private final Conf conf;
        private final BeanIntrospection<Object> introspection;
        private final PropertiesBag.Consumer propertiesConsumer;
        private BeanIntrospection.Builder<? super Object> builder;

        BuilderDeserializer(DeserBean<? super Object> db, Conf conf) {
            this.introspection = db.introspection;
            this.conf = conf;
            this.propertiesConsumer = db.injectProperties.newConsumer();
        }

        @Override
        boolean tryConsume(String propertyName, Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> objectArgument) throws IOException {
            DeserBean.DerProperty property = this.propertiesConsumer.consume(propertyName);
            if (property != null) {
                property.deserializeAndCallBuilder(decoder, decoderContext, this.builder);
                return true;
            }
            return false;
        }

        @Override
        boolean isAllConsumed() {
            return this.propertiesConsumer.isAllConsumed();
        }

        @Override
        void init(Deserializer.DecoderContext decoderContext) throws SerdeException {
            try {
                if (this.conf.preInstantiateCallback != null) {
                    this.conf.preInstantiateCallback.preInstantiate(this.introspection, new Object[0]);
                }
                this.builder = this.introspection.builder();
            }
            catch (InstantiationException e) {
                throw new SerdeException(SpecificObjectDeserializer.PREFIX_UNABLE_TO_DESERIALIZE_TYPE + String.valueOf(this.introspection.getBeanType()) + "]: " + e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public Object provideInstance(Argument<? super Object> objectArgument, Deserializer.DecoderContext decoderContext, boolean isWrapped) throws IOException {
            try {
                return this.builder.build();
            }
            catch (InstantiationException e) {
                throw new SerdeException(SpecificObjectDeserializer.PREFIX_UNABLE_TO_DESERIALIZE_TYPE + String.valueOf(this.introspection.getBeanType()) + "]: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static final class SubtypedDeductionBeanDeserializer
    extends BeanDeserializer {
        private final Conf conf;
        private final Map<String, DeserBeanSubtypeInfo.SubtypeDef<?>> subtypes;
        private Map<String, Decoder> buffer;
        private BeanDeserializer beanDeserializer;

        SubtypedDeductionBeanDeserializer(DeserBeanSubtypeInfo<? super Object> subtypeInfo, Conf conf) {
            this.conf = conf;
            this.subtypes = new LinkedHashMap<String, DeserBeanSubtypeInfo.SubtypeDef<? super Object>>(subtypeInfo.subtypes());
        }

        @Override
        boolean tryConsume(String propertyName, Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> objectArgument) throws IOException {
            if (this.beanDeserializer != null) {
                return this.beanDeserializer.tryConsume(propertyName, decoder, decoderContext, objectArgument);
            }
            Iterator<Map.Entry<String, DeserBeanSubtypeInfo.SubtypeDef<?>>> iterator = this.subtypes.entrySet().iterator();
            while (iterator.hasNext()) {
                DeserBean<?> subtype = iterator.next().getValue().deserBean();
                if (subtype.injectProperties != null && subtype.injectProperties.propertyIndexOf(propertyName) != -1 || subtype.creatorParams != null && subtype.creatorParams.propertyIndexOf(propertyName) != -1) continue;
                iterator.remove();
            }
            if (this.subtypes.size() == 1) {
                DeserBean<?> subtypeDeserBean = this.subtypes.values().iterator().next().deserBean();
                this.createBeanDeserializerAndConsumeBuffer(decoder, decoderContext, objectArgument, subtypeDeserBean);
                return this.beanDeserializer.tryConsume(propertyName, decoder, decoderContext, objectArgument);
            }
            if (this.buffer == null) {
                this.buffer = new LinkedHashMap<String, Decoder>();
            }
            this.buffer.put(propertyName, decoder.decodeBuffer());
            return true;
        }

        private void createBeanDeserializerAndConsumeBuffer(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> argument, DeserBean<?> deserBean) throws IOException {
            this.beanDeserializer = SpecificObjectDeserializer.newBeanDeserializer(null, deserBean, this.conf, false);
            this.beanDeserializer.init(decoderContext);
            if (this.buffer != null) {
                for (Map.Entry<String, Decoder> e : this.buffer.entrySet()) {
                    boolean consumed = this.beanDeserializer.tryConsume(e.getKey(), e.getValue(), decoderContext, argument);
                    if (consumed) continue;
                    SpecificObjectDeserializer.handleUnexpectedProperty(decoder, e.getKey(), deserBean);
                }
                this.buffer = null;
            }
        }

        @Override
        boolean isAllConsumed() {
            if (this.beanDeserializer != null) {
                return this.beanDeserializer.isAllConsumed();
            }
            return false;
        }

        @Override
        void init(Deserializer.DecoderContext decoderContext) {
        }

        @Override
        public Object provideInstance(Argument<? super Object> objectArgument, Deserializer.DecoderContext decoderContext, boolean isWrapped) throws IOException {
            if (this.beanDeserializer == null) {
                if (this.buffer != null) {
                    throw new SerdeException("Cannot deduct the subtype for bean " + objectArgument.getType().getName());
                }
                return null;
            }
            return this.beanDeserializer.provideInstance(objectArgument, decoderContext, false);
        }
    }

    private static final class SubtypedPropertyBeanDeserializer
    extends BeanDeserializer {
        private final DeserBeanSubtypeInfo<? super Object> subtypeInfo;
        private final Conf conf;
        private Map<String, Decoder> buffer;
        private BeanDeserializer beanDeserializer;

        SubtypedPropertyBeanDeserializer(DeserBeanSubtypeInfo<? super Object> subtypeInfo, Conf conf) {
            this.subtypeInfo = subtypeInfo;
            this.conf = conf;
        }

        @Override
        boolean tryConsume(String propertyName, Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> objectArgument) throws IOException {
            if (this.beanDeserializer != null) {
                return this.beanDeserializer.tryConsume(propertyName, decoder, decoderContext, objectArgument);
            }
            if (this.subtypeInfo.info().discriminatorName().equals(propertyName)) {
                boolean consumed;
                String discriminatorValue;
                Decoder bufferedDiscriminatorValue = null;
                if (this.subtypeInfo.info().discriminatorVisible()) {
                    bufferedDiscriminatorValue = decoder.decodeBuffer();
                    discriminatorValue = bufferedDiscriminatorValue.decodeString();
                } else {
                    discriminatorValue = decoder.decodeString();
                }
                DeserBean<? super Object> deserBean = this.subtypeInfo.findDeserBean(discriminatorValue);
                this.createBeanDeserializerAndConsumeBuffer(decoder, decoderContext, objectArgument, deserBean);
                if (bufferedDiscriminatorValue != null && !(consumed = this.beanDeserializer.tryConsume(propertyName, bufferedDiscriminatorValue, decoderContext, objectArgument))) {
                    SpecificObjectDeserializer.handleUnexpectedProperty(decoder, propertyName, deserBean);
                }
            } else {
                if (this.buffer == null) {
                    this.buffer = new LinkedHashMap<String, Decoder>();
                }
                this.buffer.put(propertyName, decoder.decodeBuffer());
            }
            return true;
        }

        private void createBeanDeserializerAndConsumeBuffer(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> objectArgument, DeserBean<?> deserBean) throws IOException {
            this.beanDeserializer = SpecificObjectDeserializer.newBeanDeserializer(null, deserBean, this.conf, false);
            this.beanDeserializer.init(decoderContext);
            if (this.buffer != null) {
                for (Map.Entry<String, Decoder> e : this.buffer.entrySet()) {
                    boolean consumed = this.beanDeserializer.tryConsume(e.getKey(), e.getValue(), decoderContext, objectArgument);
                    if (consumed) continue;
                    SpecificObjectDeserializer.handleUnexpectedProperty(decoder, e.getKey(), deserBean);
                }
                this.buffer = null;
            }
        }

        @Override
        boolean isAllConsumed() {
            if (this.beanDeserializer != null) {
                return this.beanDeserializer.isAllConsumed();
            }
            return false;
        }

        @Override
        void init(Deserializer.DecoderContext decoderContext) {
        }

        @Override
        public Object provideInstance(Argument<? super Object> objectArgument, Deserializer.DecoderContext decoderContext, boolean isWrapped) throws IOException {
            if (this.beanDeserializer == null) {
                return null;
            }
            return this.beanDeserializer.provideInstance(objectArgument, decoderContext, isWrapped);
        }
    }

    private static final class SubtypedWrapperBeanDeserializer
    extends BeanDeserializer {
        @Nullable
        private final DeserBean<? super Object> db;
        private final DeserBeanSubtypeInfo<? super Object> subtypeInfo;
        private final Conf conf;
        private boolean consumed;
        private Object instance;

        SubtypedWrapperBeanDeserializer(DeserBean<? super Object> db, Conf conf) {
            this.db = db;
            this.subtypeInfo = db.subtypeInfo;
            this.conf = conf;
        }

        @Override
        boolean tryConsume(String propertyName, Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> objectArgument) throws IOException {
            DeserBeanSubtypeInfo.SubtypeDef<? super Object> subtype = this.subtypeInfo.subtypes().get(propertyName);
            DeserBean<? super Object> subDeserBean = null;
            if (subtype == null) {
                if (this.subtypeInfo.defaultType() != null) {
                    subDeserBean = this.subtypeInfo.defaultType().deserBean();
                }
            } else {
                subDeserBean = subtype.deserBean();
            }
            if (subDeserBean == null) {
                subDeserBean = this.db;
            }
            SpecificObjectDeserializer deserializer = new SpecificObjectDeserializer(subDeserBean, this.conf);
            this.instance = deserializer.deserialize(decoder, decoderContext, objectArgument);
            this.consumed = true;
            return true;
        }

        @Override
        boolean isAllConsumed() {
            return this.consumed;
        }

        @Override
        void init(Deserializer.DecoderContext decoderContext) {
        }

        @Override
        public Object provideInstance(Argument<? super Object> objectArgument, Deserializer.DecoderContext decoderContext, boolean isWrapped) {
            return this.instance;
        }
    }

    private static final class ArgsConstructorBeanDeserializer
    extends BeanDeserializer {
        private final Conf conf;
        private final BeanIntrospection<Object> introspection;
        private final ConstructorValuesDeserializer constructorValuesDeserializer;
        @Nullable
        private final CachedPropertiesValuesDeserializer propertiesConsumer;
        @Nullable
        private final AnyValuesDeserializer anyValuesDeserializer;

        ArgsConstructorBeanDeserializer(DeserBean<? super Object> db, Conf conf) {
            this.conf = conf;
            this.introspection = db.introspection;
            this.constructorValuesDeserializer = new ConstructorValuesDeserializer(db, conf);
            this.propertiesConsumer = db.injectProperties == null ? null : new CachedPropertiesValuesDeserializer(db, conf);
            this.anyValuesDeserializer = db.anySetter == null ? null : new AnyValuesDeserializer(db);
        }

        @Override
        boolean tryConsume(String propertyName, Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> objectArgument) throws IOException {
            if (this.constructorValuesDeserializer.tryConsume(propertyName, decoder, decoderContext, objectArgument)) {
                return true;
            }
            if (this.propertiesConsumer != null && this.propertiesConsumer.tryConsume(propertyName, decoder, decoderContext, objectArgument)) {
                return true;
            }
            return this.anyValuesDeserializer != null && this.anyValuesDeserializer.tryConsume(propertyName, decoder, decoderContext);
        }

        @Override
        boolean isAllConsumed() {
            return this.anyValuesDeserializer == null && this.constructorValuesDeserializer.isAllConsumed() && (this.propertiesConsumer == null || this.propertiesConsumer.isAllConsumed());
        }

        @Override
        void init(Deserializer.DecoderContext decoderContext) throws SerdeException {
            this.constructorValuesDeserializer.init(decoderContext);
            if (this.propertiesConsumer != null) {
                this.propertiesConsumer.init(decoderContext);
            }
        }

        @Override
        public Object provideInstance(Argument<? super Object> objectArgument, Deserializer.DecoderContext decoderContext, boolean isWrapped) throws IOException {
            Object instance;
            try {
                Object[] values = this.constructorValuesDeserializer.getValues(decoderContext);
                if (this.anyValuesDeserializer != null && this.anyValuesDeserializer.anySetter.constructorArgument) {
                    this.anyValuesDeserializer.bind(values);
                }
                if (this.conf.preInstantiateCallback != null) {
                    this.conf.preInstantiateCallback.preInstantiate(this.introspection, values);
                }
                if (isWrapped && objectArgument.isNullable() && this.allNull(values) && this.propertiesConsumer == null && this.anyValuesDeserializer == null) {
                    return null;
                }
                instance = this.introspection.instantiate(this.conf.strictNullable, values);
            }
            catch (InstantiationException e) {
                throw new SerdeException(SpecificObjectDeserializer.PREFIX_UNABLE_TO_DESERIALIZE_TYPE + String.valueOf(this.introspection.getBeanType()) + "]: " + e.getMessage(), (Throwable)e);
            }
            if (this.propertiesConsumer != null) {
                this.propertiesConsumer.injectProperties(objectArgument, instance, decoderContext);
            }
            if (this.anyValuesDeserializer != null && !this.anyValuesDeserializer.anySetter.constructorArgument) {
                this.anyValuesDeserializer.bind(instance);
            }
            return instance;
        }

        private boolean allNull(Object[] values) {
            for (Object value : values) {
                if (value == null) continue;
                return false;
            }
            return true;
        }
    }

    private static final class NoArgsConstructorDeserializer
    extends BeanDeserializer {
        private final Conf conf;
        private final BeanIntrospection<Object> introspection;
        @Nullable
        private final PropertiesValuesDeserializer propertiesConsumer;
        @Nullable
        private final AnyValuesDeserializer anyValuesDeserializer;
        private Object instance;

        NoArgsConstructorDeserializer(Object instance, DeserBean<? super Object> db, Conf conf) {
            this.instance = instance;
            this.introspection = db.introspection;
            this.conf = conf;
            this.propertiesConsumer = db.injectProperties != null ? new PropertiesValuesDeserializer(db, conf) : null;
            this.anyValuesDeserializer = db.anySetter == null ? null : new AnyValuesDeserializer(db);
        }

        @Override
        boolean tryConsume(String propertyName, Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> objectArgument) throws IOException {
            if (this.propertiesConsumer != null && this.propertiesConsumer.tryConsumeAndSet(propertyName, decoder, decoderContext, objectArgument, this.instance)) {
                return true;
            }
            return this.anyValuesDeserializer != null && this.anyValuesDeserializer.tryConsume(propertyName, decoder, decoderContext);
        }

        @Override
        boolean isAllConsumed() {
            return this.anyValuesDeserializer == null && (this.propertiesConsumer == null || this.propertiesConsumer.isAllConsumed());
        }

        @Override
        void init(Deserializer.DecoderContext decoderContext) throws SerdeException {
            if (this.propertiesConsumer != null) {
                this.propertiesConsumer.init(decoderContext);
            }
            if (this.instance == null) {
                try {
                    if (this.conf.preInstantiateCallback != null) {
                        this.conf.preInstantiateCallback.preInstantiate(this.introspection, ArrayUtils.EMPTY_OBJECT_ARRAY);
                    }
                    this.instance = this.introspection.instantiate(ArrayUtils.EMPTY_OBJECT_ARRAY);
                }
                catch (InstantiationException e) {
                    throw new SerdeException(SpecificObjectDeserializer.PREFIX_UNABLE_TO_DESERIALIZE_TYPE + String.valueOf(this.introspection.getBeanType()) + "]: " + e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public Object provideInstance(Argument<? super Object> objectArgument, Deserializer.DecoderContext decoderContext, boolean isWrapped) throws IOException {
            if (this.propertiesConsumer != null) {
                this.propertiesConsumer.finalizeProperties(decoderContext, objectArgument, this.instance);
            }
            if (this.anyValuesDeserializer != null) {
                this.anyValuesDeserializer.bind(this.instance);
            }
            return this.instance;
        }
    }

    private static final class UnwrappedPropertyDeserializer {
        private final DeserBean.DerProperty<Object, Object> wrappedProperty;
        private final BeanDeserializer beanDeserializer;

        private UnwrappedPropertyDeserializer(DeserBean.DerProperty<Object, Object> unwrappedProperty, Conf conf) {
            this.wrappedProperty = unwrappedProperty;
            this.beanDeserializer = SpecificObjectDeserializer.newBeanDeserializer(null, unwrappedProperty.unwrapped, conf, true);
        }

        boolean tryConsume(String propertyName, Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> objectArgument) throws IOException {
            if (this.wrappedProperty.views != null && !decoderContext.hasView((Class[])this.wrappedProperty.views)) {
                return false;
            }
            return this.beanDeserializer.tryConsume(propertyName, decoder, decoderContext, objectArgument);
        }

        boolean isAllConsumed() {
            return this.beanDeserializer.isAllConsumed();
        }
    }

    private static final class ConstructorValuesDeserializer {
        private final PropertiesBag<? super Object> parameters;
        private final PropertiesBag.Consumer creatorParameters;
        private final Object[] values;
        @Nullable
        private final UnwrappedPropertyDeserializer[] unwrappedProperties;
        @Nullable
        private final AnyValuesDeserializer anyValuesDeserializer;
        private boolean allConsumed;

        ConstructorValuesDeserializer(DeserBean<? super Object> db, Conf conf) {
            this.parameters = db.creatorParams;
            this.creatorParameters = db.creatorParams.newConsumer();
            int creatorSize = db.creatorSize;
            this.values = new Object[creatorSize];
            if (db.creatorUnwrapped == null) {
                this.unwrappedProperties = null;
            } else {
                this.unwrappedProperties = new UnwrappedPropertyDeserializer[db.creatorUnwrapped.length];
                for (int i = 0; i < db.creatorUnwrapped.length; ++i) {
                    this.unwrappedProperties[i] = new UnwrappedPropertyDeserializer(db.creatorUnwrapped[i], conf);
                }
            }
            this.anyValuesDeserializer = db.anySetter == null || !db.anySetter.constructorArgument ? null : new AnyValuesDeserializer(db);
        }

        void init(Deserializer.DecoderContext decoderContext) throws SerdeException {
            if (this.unwrappedProperties != null) {
                for (UnwrappedPropertyDeserializer unwrappedProperty : this.unwrappedProperties) {
                    unwrappedProperty.beanDeserializer.init(decoderContext);
                }
            }
        }

        boolean tryConsume(String propertyName, Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> objectArgument) throws IOException {
            Object value;
            if (this.allConsumed) {
                return false;
            }
            DeserBean.DerProperty<Object, Object> property = this.creatorParameters.consume(propertyName);
            if (property == null) {
                if (this.unwrappedProperties != null) {
                    for (UnwrappedPropertyDeserializer unwrappedProperty : this.unwrappedProperties) {
                        if (!unwrappedProperty.tryConsume(propertyName, decoder, decoderContext, objectArgument)) continue;
                        return true;
                    }
                }
                if (this.anyValuesDeserializer != null) {
                    return this.anyValuesDeserializer.tryConsume(propertyName, decoder, decoderContext);
                }
                return false;
            }
            if (property.views != null && !decoderContext.hasView((Class[])property.views)) {
                decoder.skipValue();
                return true;
            }
            if (property.backRef != null) {
                PropertyReference ref = decoderContext.resolveReference(new PropertyReference(property.backRef, property.introspection, property.argument, null));
                value = ref != null ? ref.getReference() : null;
            } else {
                Object deserializer = property.deserializer;
                if (property.unresolvedTypeVariableName != null) {
                    deserializer = SpecificObjectDeserializer.findTypeVariableDeserializer(decoderContext, objectArgument, property, deserializer);
                }
                value = property.deserializeConstructorValue((Deserializer<Object>)deserializer, decoder, decoderContext);
            }
            if (value == null) {
                property.setDefaultConstructorValue(decoderContext, this.values);
            } else {
                this.values[property.index] = value;
            }
            return true;
        }

        boolean isAllConsumed() {
            if (this.allConsumed) {
                return true;
            }
            if (!this.creatorParameters.isAllConsumed()) {
                return false;
            }
            if (this.unwrappedProperties != null) {
                for (UnwrappedPropertyDeserializer unwrappedProperty : this.unwrappedProperties) {
                    if (unwrappedProperty.isAllConsumed()) continue;
                    return false;
                }
            }
            this.allConsumed = true;
            return true;
        }

        Object[] getValues(Deserializer.DecoderContext decoderContext) throws IOException {
            if (this.anyValuesDeserializer != null) {
                this.anyValuesDeserializer.bind(this.values);
            }
            if (this.unwrappedProperties != null) {
                for (UnwrappedPropertyDeserializer unwrappedProperty : this.unwrappedProperties) {
                    DeserBean.DerProperty<Object, Object> wrappedProperty = unwrappedProperty.wrappedProperty;
                    Object value = unwrappedProperty.beanDeserializer.provideInstance(wrappedProperty.argument, decoderContext, true);
                    if (wrappedProperty.views != null && !decoderContext.hasView((Class[])wrappedProperty.views)) continue;
                    if (value == null) {
                        wrappedProperty.setDefaultConstructorValue(decoderContext, this.values);
                        continue;
                    }
                    this.values[wrappedProperty.index] = value;
                }
            }
            DeserBean.DerProperty<? super Object, Object>[] propertiesArray = this.parameters.getPropertiesArray();
            for (int i = 0; i < propertiesArray.length; ++i) {
                PropertyReference ref;
                if (this.creatorParameters.isConsumed(i)) continue;
                DeserBean.DerProperty<? super Object, Object> property = propertiesArray[i];
                if (property.unwrapped != null) continue;
                Object value = null;
                if (property.backRef != null && (ref = decoderContext.resolveReference(new PropertyReference(property.backRef, property.introspection, property.argument, null))) != null) {
                    value = ref.getReference();
                }
                if (value == null) {
                    property.setDefaultConstructorValue(decoderContext, this.values);
                    continue;
                }
                this.values[i] = value;
            }
            return this.values;
        }
    }

    private static final class PropertiesValuesDeserializer {
        private final PropertiesBag<? super Object> properties;
        @Nullable
        private final PropertiesBag.Consumer propertiesConsumer;
        @Nullable
        private final UnwrappedPropertyDeserializer[] unwrappedProperties;

        PropertiesValuesDeserializer(DeserBean<? super Object> db, Conf conf) {
            this.properties = db.injectProperties;
            this.propertiesConsumer = this.properties.newConsumer();
            if (db.unwrappedProperties == null) {
                this.unwrappedProperties = null;
            } else {
                this.unwrappedProperties = new UnwrappedPropertyDeserializer[db.unwrappedProperties.length];
                for (int i = 0; i < db.unwrappedProperties.length; ++i) {
                    this.unwrappedProperties[i] = new UnwrappedPropertyDeserializer(db.unwrappedProperties[i], conf);
                }
            }
        }

        void init(Deserializer.DecoderContext decoderContext) throws SerdeException {
            if (this.unwrappedProperties != null) {
                for (UnwrappedPropertyDeserializer unwrappedProperty : this.unwrappedProperties) {
                    unwrappedProperty.beanDeserializer.init(decoderContext);
                }
            }
        }

        boolean tryConsumeAndSet(String propertyName, Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> objectArgument, Object instance) throws IOException {
            DeserBean.DerProperty<Object, Object> property = this.propertiesConsumer.consume(propertyName);
            if (property != null) {
                if (property.views != null && !decoderContext.hasView((Class[])property.views)) {
                    decoder.skipValue();
                    return true;
                }
                if (property.backRef != null) {
                    PropertyReference ref = decoderContext.resolveReference(new PropertyReference(property.backRef, property.introspection, property.argument, instance));
                    Object value = null;
                    if (ref != null) {
                        value = ref.getReference();
                    }
                    property.set(decoderContext, instance, value);
                } else {
                    SpecificObjectDeserializer.deserializeAndSetPropertyValue(decoderContext, decoder, property, objectArgument, instance);
                }
                return true;
            }
            if (this.unwrappedProperties != null) {
                for (UnwrappedPropertyDeserializer up : this.unwrappedProperties) {
                    if (!up.tryConsume(propertyName, decoder, decoderContext, objectArgument)) continue;
                    if (up.isAllConsumed()) {
                        DeserBean.DerProperty<Object, Object> wrappedProperty = up.wrappedProperty;
                        if (wrappedProperty.views != null && !decoderContext.hasView((Class[])wrappedProperty.views)) continue;
                        this.propertiesConsumer.consume(wrappedProperty.index);
                        wrappedProperty.set(decoderContext, instance, up.beanDeserializer.provideInstance(objectArgument, decoderContext, true));
                    }
                    return true;
                }
            }
            return false;
        }

        void finalizeProperties(Deserializer.DecoderContext decoderContext, Argument<? super Object> objectArgument, Object instance) throws IOException {
            if (this.unwrappedProperties != null) {
                for (UnwrappedPropertyDeserializer unwrappedProperty : this.unwrappedProperties) {
                    DeserBean.DerProperty<Object, Object> wrappedProperty = unwrappedProperty.wrappedProperty;
                    if (this.propertiesConsumer.isConsumed(wrappedProperty.index) || wrappedProperty.views != null && !decoderContext.hasView((Class[])wrappedProperty.views)) continue;
                    wrappedProperty.set(decoderContext, instance, unwrappedProperty.beanDeserializer.provideInstance(objectArgument, decoderContext, true));
                }
            }
            DeserBean.DerProperty<? super Object, Object>[] propertiesArray = this.properties.getPropertiesArray();
            for (int i = 0; i < propertiesArray.length; ++i) {
                if (this.propertiesConsumer.isConsumed(i)) continue;
                DeserBean.DerProperty<? super Object, Object> property = propertiesArray[i];
                if (property.unwrapped != null) continue;
                property.setDefaultPropertyValue(decoderContext, instance);
            }
        }

        boolean isAllConsumed() {
            if (!this.propertiesConsumer.isAllConsumed()) {
                return false;
            }
            if (this.unwrappedProperties != null) {
                for (UnwrappedPropertyDeserializer unwrappedProperty : this.unwrappedProperties) {
                    if (unwrappedProperty.isAllConsumed()) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static final class CachedPropertiesValuesDeserializer {
        private final PropertiesBag<? super Object> properties;
        private final PropertiesBag.Consumer propertiesConsumer;
        private final Object[] values;
        private final Decoder[] buffered;
        @Nullable
        private final UnwrappedPropertyDeserializer[] unwrappedProperties;

        CachedPropertiesValuesDeserializer(DeserBean<? super Object> db, Conf conf) {
            this.properties = db.injectProperties;
            this.propertiesConsumer = this.properties.newConsumer();
            this.values = new Object[db.injectPropertiesSize];
            this.buffered = new Decoder[db.injectPropertiesSize];
            if (db.unwrappedProperties == null) {
                this.unwrappedProperties = null;
            } else {
                this.unwrappedProperties = new UnwrappedPropertyDeserializer[db.unwrappedProperties.length];
                for (int i = 0; i < db.unwrappedProperties.length; ++i) {
                    this.unwrappedProperties[i] = new UnwrappedPropertyDeserializer(db.unwrappedProperties[i], conf);
                }
            }
        }

        void init(Deserializer.DecoderContext decoderContext) throws SerdeException {
            if (this.unwrappedProperties != null) {
                for (UnwrappedPropertyDeserializer unwrappedProperty : this.unwrappedProperties) {
                    unwrappedProperty.beanDeserializer.init(decoderContext);
                }
            }
        }

        boolean tryConsume(String propertyName, Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> objectArgument) throws IOException {
            DeserBean.DerProperty property = this.propertiesConsumer.consume(propertyName);
            if (property != null && property.beanProperty != null) {
                if (property.views != null && !decoderContext.hasView((Class[])property.views)) {
                    decoder.skipValue();
                    return true;
                }
                if (property.managedRef == null) {
                    this.values[property.index] = property.deserializeValue(property.deserializer, decoder, decoderContext);
                } else {
                    this.buffered[property.index] = decoder.decodeBuffer();
                }
                return true;
            }
            if (this.unwrappedProperties != null) {
                for (UnwrappedPropertyDeserializer unwrappedProperty : this.unwrappedProperties) {
                    if (!unwrappedProperty.tryConsume(propertyName, decoder, decoderContext, objectArgument)) continue;
                    return true;
                }
            }
            return false;
        }

        void injectProperties(Argument<? super Object> objectArgument, Object instance, Deserializer.DecoderContext decoderContext) throws IOException {
            DeserBean.DerProperty<? super Object, Object>[] propertiesArray = this.properties.getPropertiesArray();
            for (int i = 0; i < propertiesArray.length; ++i) {
                DeserBean.DerProperty<Object, Object> property = propertiesArray[i];
                if (property.unwrapped != null || property.views != null && !decoderContext.hasView((Class[])property.views)) continue;
                if (property.backRef != null) {
                    PropertyReference ref = decoderContext.resolveReference(new PropertyReference(property.backRef, property.introspection, property.argument, null));
                    Object value = null;
                    if (ref != null) {
                        value = ref.getReference();
                    }
                    property.set(decoderContext, instance, value);
                    continue;
                }
                Decoder bufferedDecoder = this.buffered[i];
                if (bufferedDecoder != null) {
                    SpecificObjectDeserializer.deserializeAndSetPropertyValue(decoderContext, bufferedDecoder, property, objectArgument, instance);
                    continue;
                }
                property.set(decoderContext, instance, this.values[i]);
            }
            if (this.unwrappedProperties != null) {
                for (UnwrappedPropertyDeserializer unwrappedProperty : this.unwrappedProperties) {
                    DeserBean.DerProperty<Object, Object> wrappedProperty = unwrappedProperty.wrappedProperty;
                    if (wrappedProperty.views != null && !decoderContext.hasView((Class[])wrappedProperty.views)) continue;
                    wrappedProperty.set(decoderContext, instance, unwrappedProperty.beanDeserializer.provideInstance(objectArgument, decoderContext, true));
                }
            }
        }

        boolean isAllConsumed() {
            if (!this.propertiesConsumer.isAllConsumed()) {
                return false;
            }
            if (this.unwrappedProperties != null) {
                for (UnwrappedPropertyDeserializer unwrappedProperty : this.unwrappedProperties) {
                    if (unwrappedProperty.isAllConsumed()) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static final class AnyValuesDeserializer {
        private final DeserBean<?> deserBean;
        private final DeserBean.AnySetter anySetter;
        private Map<String, Object> values;

        AnyValuesDeserializer(DeserBean<?> deserBean) {
            this.deserBean = deserBean;
            this.anySetter = deserBean.anySetter;
        }

        void bind(Object instance) {
            if (this.values != null) {
                this.anySetter.bind(this.values, instance);
            }
        }

        boolean tryConsume(String propertyName, Decoder decoder, Deserializer.DecoderContext decoderContext) throws IOException {
            Object value;
            if (this.values == null) {
                this.values = new LinkedHashMap<String, Object>();
            }
            if (decoder.decodeNull()) {
                value = null;
            } else {
                Argument<Object> argument = Argument.OBJECT_ARGUMENT;
                try {
                    if (this.anySetter.deserializer != null) {
                        argument = this.anySetter.valueType;
                        value = this.anySetter.deserializer.deserializeNullable(decoder, decoderContext, this.anySetter.valueType);
                    } else {
                        value = decoder.decodeArbitrary();
                    }
                }
                catch (SerdeException e) {
                    e.getPath().add(ReferencePath.ofProperty((Class)this.deserBean.introspection.getBeanType(), (Argument)argument.withName(propertyName)));
                    throw e;
                }
            }
            this.values.put(propertyName, value);
            return true;
        }
    }
}

