/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.exceptions.path.ReferencePath;
import io.micronaut.serde.support.DeserializerRegistrar;
import io.micronaut.serde.support.util.JsonNodeDecoder;
import io.micronaut.serde.util.CustomizableDeserializer;
import java.io.IOException;
import java.util.EnumMap;

@Internal
final class EnumMapDeserializer<E extends Enum<E>, V>
implements CustomizableDeserializer<EnumMap<E, V>>,
DeserializerRegistrar<EnumMap<E, V>> {
    EnumMapDeserializer() {
    }

    public Deserializer<EnumMap<E, V>> createSpecific(Deserializer.DecoderContext context, Argument<? super EnumMap<E, V>> type) throws SerdeException {
        Object[] generics = type.getTypeParameters();
        if (ArrayUtils.isEmpty((Object[])generics) || generics.length != 2) {
            throw new SerdeException("Cannot deserialize raw EnumMap");
        }
        Object enumType = generics[0];
        Object valueType = generics[1];
        Deserializer valueDeser = valueType.equalsType(Argument.OBJECT_ARGUMENT) ? null : context.findDeserializer((Argument)valueType).createSpecific(context, (Argument)valueType);
        Deserializer enumDeser = context.findDeserializer((Argument)enumType).createSpecific(context, (Argument)enumType);
        return (arg_0, arg_1, arg_2) -> EnumMapDeserializer.lambda$createSpecific$0((Argument)enumType, enumDeser, valueDeser, (Argument)valueType, arg_0, arg_1, arg_2);
    }

    @Override
    public Argument<EnumMap<E, V>> getType() {
        return Argument.of(EnumMap.class, (Argument[])new Argument[]{Argument.ofTypeVariable(Enum.class, (String)"E"), Argument.ofTypeVariable(Object.class, (String)"V")});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static /* synthetic */ EnumMap lambda$createSpecific$0(Argument enumType, Deserializer enumDeser, Deserializer valueDeser, Argument valueType, Decoder decoder, Deserializer.DecoderContext decoderContext, Argument mapType) throws IOException {
        EnumMap<Enum, Object> map = new EnumMap<Enum, Object>(enumType.getType());
        LimitingStream.RemainingLimits remainingLimits = decoderContext.getSerdeConfiguration().map(LimitingStream::limitsFromConfiguration).orElse(LimitingStream.DEFAULT_LIMITS);
        try (Decoder objectDecoder = decoder.decodeObject(mapType);){
            String key = objectDecoder.decodeKey();
            while (key != null) {
                try {
                    JsonNodeDecoder keyDecoder = JsonNodeDecoder.create(JsonNode.createStringNode((String)key), remainingLimits);
                    Enum k = (Enum)enumDeser.deserialize((Decoder)keyDecoder, decoderContext, enumType);
                    if (valueDeser == null) {
                        map.put(k, objectDecoder.decodeArbitrary());
                    } else {
                        map.put(k, valueDeser.deserializeNullable(objectDecoder, decoderContext, valueType));
                    }
                    key = objectDecoder.decodeKey();
                }
                catch (SerdeException e) {
                    e.getPath().add(ReferencePath.ofMap(map.getClass(), (Argument)mapType, (String)key));
                    throw e;
                    return map;
                }
            }
        }
    }
}

