/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.extensions.junit5;

import io.micronaut.aop.InterceptedProxy;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.test.annotation.MicronautTest;
import io.micronaut.test.annotation.MockBean;
import io.micronaut.test.extensions.AbstractMicronautExtension;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.junit.platform.commons.support.AnnotationSupport;

public class MicronautJunit5Extension
extends AbstractMicronautExtension<ExtensionContext>
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ExecutionCondition,
BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    public void beforeAll(ExtensionContext extensionContext) {
        Class testClass = extensionContext.getRequiredTestClass();
        MicronautTest micronautTest = AnnotationSupport.findAnnotation((AnnotatedElement)testClass, MicronautTest.class).orElse(null);
        this.beforeClass(extensionContext, testClass, micronautTest);
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.afterClass(extensionContext);
    }

    public void beforeEach(ExtensionContext extensionContext) {
        Optional testInstance = extensionContext.getTestInstance();
        Optional testMethod = extensionContext.getTestMethod();
        this.beforeEach(extensionContext, testInstance.orElse(null), testMethod.orElse(null));
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext extensionContext) {
        Optional testInstance = extensionContext.getTestInstance();
        if (testInstance.isPresent()) {
            Class requiredTestClass = extensionContext.getRequiredTestClass();
            if (this.applicationContext.containsBean(requiredTestClass)) {
                return ConditionEvaluationResult.enabled((String)"Test bean active");
            }
            boolean hasBeanDefinition = this.isTestSuiteBeanPresent(requiredTestClass);
            if (!hasBeanDefinition) {
                throw new TestInstantiationException("@MicronautTest used on test but no bean definition for the test present. This error indicates a misconfigured build or IDE. Please add the 'micronaut-inject-java' annotation processor to your test processor path (for Java this is the testAnnotationProcessor scope, for Kotlin kaptTest and for Groovy testCompile). See the documentation for reference: https://micronaut-projects.github.io/micronaut-test/latest/guide/");
            }
            return ConditionEvaluationResult.disabled((String)"Test is not bean. Either the test does not satisfy requirements defined by @Requires or annotation processing is not enabled. If the latter ensure annotation processing is enabled in your IDE.");
        }
        Class testClass = extensionContext.getRequiredTestClass();
        if (AnnotationSupport.isAnnotated((AnnotatedElement)testClass, MicronautTest.class)) {
            return ConditionEvaluationResult.enabled((String)"Test bean active");
        }
        return ConditionEvaluationResult.disabled((String)"Test is not bean. Either the test does not satisfy requirements defined by @Requires or annotation processing is not enabled. If the latter ensure annotation processing is enabled in your IDE.");
    }

    protected void alignMocks(ExtensionContext context, Object instance) {
        if (this.specDefinition != null) {
            for (FieldInjectionPoint injectedField : this.specDefinition.getInjectedFields()) {
                boolean isMock = this.applicationContext.resolveMetadata(injectedField.getType()).isAnnotationPresent(MockBean.class);
                if (!isMock) continue;
                Field field = injectedField.getField();
                field.setAccessible(true);
                try {
                    Object mock = field.get(instance);
                    if (!(mock instanceof InterceptedProxy)) continue;
                    InterceptedProxy ip = (InterceptedProxy)mock;
                    Object target = ip.interceptedTarget();
                    field.set(instance, target);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        this.commit();
        this.rollback();
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        this.begin();
    }
}

