/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import jakarta.validation.metadata.ConstraintDescriptor;
import java.util.Arrays;
import java.util.Objects;

@Internal
record DefaultConstraintViolation<T>(@Nullable T rootBean, @Nullable Class<T> rootBeanClass, Object leafBean, Object invalidValue, String message, String messageTemplate, Path path, ConstraintDescriptor<?> constraintDescriptor, @Nullable Object[] executableParameterValues, @Nullable Object executableReturnValue) implements ConstraintViolation<T>
{
    public String getMessage() {
        return this.message;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public T getRootBean() {
        return this.rootBean;
    }

    public Class<T> getRootBeanClass() {
        return this.rootBeanClass;
    }

    public Object getLeafBean() {
        return this.leafBean;
    }

    public Object[] getExecutableParameters() {
        return this.executableParameterValues;
    }

    public Object getExecutableReturnValue() {
        return this.executableReturnValue;
    }

    public Path getPropertyPath() {
        return this.path;
    }

    public Object getInvalidValue() {
        return this.invalidValue;
    }

    public ConstraintDescriptor<?> getConstraintDescriptor() {
        return this.constraintDescriptor;
    }

    public <U> U unwrap(Class<U> type) {
        throw new UnsupportedOperationException("Unwrapping is unsupported by this implementation");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConstraintViolation that = (DefaultConstraintViolation)o;
        return Objects.equals(this.rootBean, that.rootBean) && Objects.equals(this.rootBeanClass, that.rootBeanClass) && Objects.equals(this.leafBean, that.leafBean) && Objects.equals(this.invalidValue, that.invalidValue) && Objects.equals(this.message, that.message) && Objects.equals(this.messageTemplate, that.messageTemplate) && Objects.equals(this.path, that.path) && Objects.equals(this.constraintDescriptor, that.constraintDescriptor) && Arrays.equals(this.executableParameterValues, that.executableParameterValues) && Objects.equals(this.executableReturnValue, that.executableReturnValue);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.rootBean, this.rootBeanClass, this.leafBean, this.invalidValue, this.message, this.messageTemplate, this.path, this.constraintDescriptor, this.executableReturnValue);
        result = 31 * result + Arrays.hashCode(this.executableParameterValues);
        return result;
    }

    @Override
    public String toString() {
        return "DefaultConstraintViolation{rootBean=" + String.valueOf(this.rootBeanClass) + ", invalidValue=" + String.valueOf(this.invalidValue) + ", path=" + String.valueOf(this.path) + "}";
    }
}

