/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.validation.validator.DefaultValidator;
import io.micronaut.validation.validator.DefaultValidatorConfiguration;
import io.micronaut.validation.validator.Validator;
import io.micronaut.validation.validator.ValidatorConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.ClockProvider;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.TraversableResolver;
import jakarta.validation.ValidatorContext;
import jakarta.validation.ValidatorFactory;

@Requires(missingBeans={ValidatorFactory.class})
@Internal
@Singleton
public class DefaultValidatorFactory
implements ValidatorFactory {
    private final Validator validator;
    private final ValidatorConfiguration configuration;

    public DefaultValidatorFactory() {
        this(new DefaultValidatorConfiguration());
    }

    public DefaultValidatorFactory(ValidatorConfiguration configuration) {
        this(new DefaultValidator(configuration), configuration);
    }

    @Inject
    public DefaultValidatorFactory(Validator validator, ValidatorConfiguration configuration) {
        this.validator = validator;
        this.configuration = configuration;
    }

    public jakarta.validation.Validator getValidator() {
        return this.validator;
    }

    public ValidatorContext usingContext() {
        ValidatorConfiguration validatorConfiguration = this.configuration;
        if (validatorConfiguration instanceof ValidatorContext) {
            ValidatorContext validatorContext = (ValidatorContext)validatorConfiguration;
            return validatorContext;
        }
        DefaultValidatorConfiguration newValidatorConfiguration = new DefaultValidatorConfiguration();
        newValidatorConfiguration.setBeanIntrospector(this.configuration.getBeanIntrospector());
        return newValidatorConfiguration;
    }

    public MessageInterpolator getMessageInterpolator() {
        throw new UnsupportedOperationException("Method getMessageInterpolator() not supported");
    }

    public TraversableResolver getTraversableResolver() {
        return this.configuration.getTraversableResolver();
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        throw new UnsupportedOperationException("Method getConstraintValidatorFactory() not supported");
    }

    public ParameterNameProvider getParameterNameProvider() {
        throw new UnsupportedOperationException("Method getParameterNameProvider() not supported");
    }

    public ClockProvider getClockProvider() {
        return this.configuration.getClockProvider();
    }

    public <T> T unwrap(Class<T> type) {
        throw new UnsupportedOperationException("Method unwrap(..) not supported");
    }

    public void close() {
    }
}

