/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.xml.jackson;

import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.util.CollectionUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@ConfigurationProperties(value="jackson.xml")
@TypeHint(value={LinkedHashMap.class})
public class JacksonXmlConfiguration {
    private Map<FromXmlParser.Feature, Boolean> parser = Collections.emptyMap();
    private Map<ToXmlGenerator.Feature, Boolean> generator = Collections.emptyMap();
    private boolean defaultUseWrapper = true;

    public Map<FromXmlParser.Feature, Boolean> getParserSettings() {
        return this.parser;
    }

    public void setParser(Map<FromXmlParser.Feature, Boolean> parser) {
        if (CollectionUtils.isNotEmpty(parser)) {
            this.parser = parser;
        }
    }

    public Map<ToXmlGenerator.Feature, Boolean> getGeneratorSettings() {
        return this.generator;
    }

    public void setGenerator(Map<ToXmlGenerator.Feature, Boolean> generator) {
        if (CollectionUtils.isNotEmpty(generator)) {
            this.generator = generator;
        }
    }

    public boolean isDefaultUseWrapper() {
        return this.defaultUseWrapper;
    }

    public void setDefaultUseWrapper(boolean state) {
        this.defaultUseWrapper = state;
    }
}

